/*

http://jleopold.de/2010/08/10/arduino-als-webserver/

Original Version by Poldi
modified by Katsu
the functions readString.append() and readString.contains() where replaced

modified by RaKa 2011 for FLASH Library (PROGMEM) to save RAM
*/

#include <SPI.h>  // insert by Katsu
#include <Ethernet.h>
#include <Flash.h>   // Mikal Hart PROGMEM Library, http://arduiniana.org/libraries/flash/
                     //I use the F() macro (F for Flash)


byte mac[] = { 0x54, 0x55, 0x58, 0x10, 0x00, 0x24 };  // entspricht einer MAC von 84.85.88.16.0.36
byte ip[]  = { 192, 168, 1, 222 };                  // IP-Adresse
byte gateway[] = { 192, 168, 1, 1 };                // Gateway
byte subnet[]  = { 255, 255, 255, 0 };

Server server(80);

int Pin3 = 3;
int Pin4 = 4;
int Pin5 = 5;
int Pin6 = 6;

String readString = String(100);      // string for fetching data from address
boolean Pin3ON = false;                  // Status flag
boolean Pin4ON = false;


void setup()
{
    Ethernet.begin(mac, ip, gateway, subnet);
    server.begin();
    pinMode(Pin3, OUTPUT);
    pinMode(Pin4, OUTPUT);

    Serial.begin(9600); 

}

void loop()
  {

  // Create a client connection
  Client client = server.available();
  if (client) {
    while (client.connected()) 
      {
      if (client.available()) 
        {
        char c = client.read();

        //read char by char HTTP request
        if (readString.length() < 100) 
          {
          //store characters to string
          // readString.append(c);  removed by Katsu
          readString = readString + c; // insert by Katsu
          // very simple but it works...
          }

        Serial.print(c);  //output chars to serial port

        if (c == '\n') 
          {  //if HTTP request has ended

          // readString.contains() replaced with readString.indexOf(val) > -1  by Katsu
          // indexOf locates a character or String within another String.
          // Returns the index of val within the String, or -1 if not found.
          if(readString.indexOf("3=einschalten") > -1) 
            {
              digitalWrite(Pin3, HIGH);
              Serial.println("Pin 3  eingeschaltet!");
              Pin3ON = true;
            }
            
          if(readString.indexOf("3=ausschalten") > -1)
            {
              digitalWrite(Pin3, LOW);
              Serial.println("Pin 3 ausgeschaltet!");
              Pin3ON = false;
            }
          
          if(readString.indexOf("4=einschalten") > -1) 
            {
              digitalWrite(Pin4, HIGH);
              Serial.println("Pin 4 eingeschaltet!");
              Pin4ON = true;
            }
          
          if(readString.indexOf("4=ausschalten") > -1)
          { 
             digitalWrite(Pin4, LOW);
             Serial.println("Pin 4 ausgeschaltet!");
             Pin4ON = false;
          }

          if(readString.indexOf("all=Alles+aus") > -1)
          {
            digitalWrite(Pin3, LOW);
            digitalWrite(Pin4, LOW);
            Serial.println("Alles ausgeschaltet");
            Pin3ON = false;
            Pin4ON = false;
          }
          
          //--------------------------HTML------------------------
          client << F("HTTP/1.1 200 OK\n");

          client << F("Content-Type: text/html\n\n");

         

          client << F("<html><head>");

       
          client << F("<title>Arduino Webserver</title>");

          client << F("</head>\n");

          client << F("<body bgcolor='#444444'>");

          //---berschrift---
          client << F("<br><hr />\n");

          client << F("<h1><div align='center'><font color='#2076CD'>Arduino Webserver 1.0 by Poldi RaKa Version</font color></div></h1>\n");

          client << F("<hr /><br>\n");
          //---berschrift---

          //---Ausgnge schalten---
          client << F("<div align='left'><font face='Verdana' color='#FFFFFF'>Ausg&auml;nge schalten:</font></div>\n");

          client << F("<br>\n");

          client << F("<table border='1' width='500' cellpadding='5'>\n");

          client << F("<tr bgColor='#222222'>\n");

          client << F("<td bgcolor='#222222'><font face='Verdana' color='#CFCFCF' size='2'>Ausgang 3<br></font></td>\n");
 
          client << F("<td align='center' bgcolor='#222222'><form method=get><input type=submit name=3 value='einschalten'></form></td>\n");
 
          client << F("<td align='center' bgcolor='#222222'><form method=get><input type=submit name=3 value='ausschalten'></form></td>\n");
 
          if (Pin3ON)
             client << F("<td align='center'><font color='green' size='5'>ON\n");
          else
             client << F("<td align='center'><font color='#CFCFCF' size='5'>OFF\n");
   
          client << F("</tr>\n");

          client << F("<tr bgColor='#222222'>\n");

          client << F("<td bgcolor='#222222'><font face='Verdana' color='#CFCFCF' size='2'>Ausgang 4<br></font></td>\n");
 
          client << F("<td align='center' bgcolor='#222222'><form method=get><input type=submit name=4 value='einschalten'></form></td>\n");
 
          client << F("<td align='center' bgcolor='#222222'><form method=get><input type=submit name=4 value='ausschalten'></form></td>\n");
 
          if (Pin4ON)
             client << F("<td align='center'><font color='green' size='5'>ON\n");
          else
             client << F("<td align='center'><font color='#CFCFCF' size='5'>OFF\n");
   
          client << F("</tr>\n");

   
          client << F("</tr>\n");

          client << F("</table>\n");


          client << F("<br>\n");

          client << F("<form method=get><input type=submit name=all value='Alles aus'></form>\n");

          client << F("</body></html>\n");

          //---Ausgnge schalten---

          //clearing string for next read
          readString="";

          //stopping client
          client.stop();
        }
      }
    }
  }
}