/*

http://jleopold.de/2010/08/10/arduino-als-webserver/

Original Version by Poldi
modified by Katsu
the functions readString.append() and readString.contains() where replaced

modified by RaKa 2011 for FLASH Library (PROGMEM) to save RAM
*/

#include <SPI.h>  // insert by Katsu
#include <Ethernet.h>
#include <Flash.h>   // Mikal Hart PROGMEM Library, http://arduiniana.org/libraries/flash/
                     //I use the F() macro (F for “Flash”)
char prev[5]="V1.0";

byte mac[] = { 0x54, 0x55, 0x58, 0x10, 0x00, 0x24 };  // entspricht einer MAC von 84.85.88.16.0.36
byte ip[]  = { 192, 168, 1, 101 };                  // IP-Adresse
byte gateway[] = { 192, 168, 1, 1 };                // Gateway
byte subnet[]  = { 255, 255, 255, 0 };

Server server(80);

int Pin3 = 3;
boolean Pin3ON = false;                  // Status flag
int Pin6 = 6,D6val=0;
int Pin7 = 7,D7val=0;

String readString = String(100);      // string for fetching data from address



void setup()
{
    Ethernet.begin(mac, ip, gateway, subnet);
    server.begin();
    pinMode(Pin3, OUTPUT);
    
   pinMode(6, INPUT);        // sets the digital pin as input
   digitalWrite(6, HIGH);    // enable pullup

   pinMode(7, INPUT);        // sets the digital pin as input
   digitalWrite(7, HIGH);    // enable pullup


    Serial.begin(19200); 
  Serial.print("ARDUINO ETHERNET WEBSERVER by kll-engineering ");
  Serial.println(prev);

}

void loop()
  {
Pbutton();  // get D6,D7
  // Create a client connection
  Client client = server.available();
  if (client) {
    while (client.connected()) 
      {
      if (client.available()) 
        {
        char c = client.read();

        //read char by char HTTP request
        if (readString.length() < 100) 
          {
          //store characters to string
          // readString.append(c);  removed by Katsu
          readString = readString + c; // insert by Katsu
          // very simple but it works...
          }

        Serial.print(c);  //output chars to serial port

        if (c == '\n') 
          {  //if HTTP request has ended

          // readString.contains() replaced with readString.indexOf(val) > -1  by Katsu
          // indexOf locates a character or String within another String.
          // Returns the index of val within the String, or -1 if not found.
          if(readString.indexOf("3=ON") > -1) 
            {
              digitalWrite(Pin3, HIGH);
              Serial.println("Pin 3  ON");
              Pin3ON = true;
            }
            
          if(readString.indexOf("3=OFF") > -1)
            {
              digitalWrite(Pin3, LOW);
              Serial.println("Pin 3 OFF");
              Pin3ON = false;
            }
            // report also push button status ( only if client connected )
   Serial.print("pushbutton: D6 ");
   Serial.print(D6val); 
   Serial.print(" D7 ");
   Serial.println(D7val); 

          //--------------------------HTML------------------------
          client << F("HTTP/1.1 200 OK\n");

          client << F("Content-Type: text/html\n\n");

         

          client << F("<html><head>");

       
          client << F("<title>Arduino Webserver</title>");

          client << F("</head>\n");

          client << F("<body bgcolor='#444444'>");

          //---Überschrift---
          client << F("<br><hr />\n");

          client << F("<h1><div align='center'><font color='#2076CD'>Arduino Webserver FLASH</font color></div></h1>\n");

          client << F("<div align='center'><a href='http://kll.byethost7.com/kll_en7/' target='_blank'><h1>kll-engineering</h1></a> </div></br>\n");

          client << F("<hr /><br>\n");

client << F("<fieldset><legend><font face='Verdana' color='#FFFFFF'>\n");

client << F("operation:\n");

client << F("</legend><div><font face='Verdana' color='#FFFFFF'>\n");

client << F("<label for='feld_id'>\n");

client << F("Do3 ");

             if (Pin3ON)  {            
  client << F("ON  \n"); 
             } else {
  client << F("OFF \n"); 
             }
          
client << F("</label>\n");

             if (Pin3ON)  {               
    client << F("<form method=get><input type=submit name=3 value='OFF' id='feld_id' ></form>\n");
                } else {              
               client << F("<form method=get><input type=submit name=3 value='ON' id='feld_id' ></form>\n"); 
                }

client << F("</div>\n");

client << F("</fieldset>\n");

// KLL
client << F("</fieldset>\n");

client << F("<fieldset><legend><font face='Verdana' color='#FFFFFF'>\n");

client << F("analog read:\n");

client << F("</legend><div><font face='Verdana' color='#FFFFFF'>\n");

            for (int analogChannel = 0; analogChannel < 4; analogChannel++) {
              
            client << F("<div align='left'><font face='Verdana' color='#FFFFFF'>");
            client << F("A");
            client.print(analogChannel);
            client << F("[V] ");
            client.print(float(analogRead(analogChannel))*5/1024);
            client << F(" </font></div>");
            delay(20);  // analog reading delay
          } // end FOR channel
client << F("</fieldset>\n");

client << F("<fieldset><legend><font face='Verdana' color='#FFFFFF'>\n");

client << F("digital read:\n");

client << F("</legend><div><font face='Verdana' color='#FFFFFF'>\n");


            client << F("<div align='left'><font face='Verdana' color='#FFFFFF'>");
            
            client << F("Di6 ");
            if  (D6val ==1 ) { client << F("ON"); } else { client << F("OFF"); }
            client << F(" </font></div>");
            client << F("<div align='left'><font face='Verdana' color='#FFFFFF'>");
            client << F("Di7 ");
            if  (D7val ==1 ) { client << F("ON"); } else { client << F("OFF"); }
            client << F(" </font></div>");
client << F("</fieldset>\n");

//KLL
          client << F("</body></html>\n");

          //---Ausgänge schalten---

          //clearing string for next read
          readString="";

          //stopping client
          client.stop();
        }
      }
    }
  }
}


void Pbutton()               // read all time, not only at scan time
 {
   D6val = digitalRead(6);
   D7val = digitalRead(7);
   
 } // end 

