/*_________________________________________________________________*/
/*  KLL-engineering                                                */
/*  V0.1 6.5.2011 start                                            */
/*  V0.2 time controlled measuring loop  (millis)                  */
/*  V0.3 serial menu and speedfile on uSD card                     */
/*  V0.4 D6,D7 pushbutton, also logged                             */
/*  V0.5 test with original ethernet shield and Vccreadback                       */
/*_________________________________________________________________*/
char prev[5]="V0.5"; 
// uSD_kll

// 6.5.2011 add uSD card (4GB Kingston)


// as     PIN0 and PIN1 are used for serial / USB communication
// interface shield uSD card slot
// PIN10  SS
// PIN11  MOSI
// PIN12  MISO
// PIN13  SCK and ARDUINO motherboard yellow LED

// only   PIN2 PIN4, PIN5 is  still unused!

// pin6 and pin7 for push button to GND wired on my own add on shield ( on interface shield )

// incl ARDUINO SD Card library
#include <SD.h>
//SD card uses SPI, which takes place on digital pins 11, 12, and 13 (
//Additionally, another pin must be used to select the SD card. This can be the hardware SS pin - pin 10 (on most Arduino boards)

boolean haveuSDcard = false;
File myFile;
char fname[]="kll_data.csv";
char sfname[]="scan.txt";

 int A0val,A1val,A2val,A3val,A4val,A5val,D1val,D2val,D3val,D4val,D5val,D6val,D7val;

 unsigned long Ltime=0;  

 unsigned long loopcount=0; 
 int cyclecount=0,seravail=500;  
 unsigned long sampletime=60000;  // milli seconds
 
 boolean datameasure=true, datadump=false;
 
 long ser0bd = 19200;                               // 300, 1200, 2400, 9600, 14400, 19200, 28800, 38400, 57600, 115200
 int inByte;
 int delayusb = 100;                               // at 57600  setpointinput 2,3 digit dont work with 10 or 100
 
 boolean debugv = false;
 boolean debuga = false;                          // from get_set_value int function only

const int SDchipSelectPin = 4;             // original ETHERNET CARD 4, DFRobot shield 10
const int ETHERNETchipSelectPin = 10;      // original ETHERNET CARD 10,

long VCCread=0;

void setup()
{
  
  // ------------ Set pin modes ... ----------------------------------------------
  pinMode(ETHERNETchipSelectPin, OUTPUT);    // pin 10 -> make sure that the default chip select pin is set to output, even if you don't use it:  pinMode(10, OUTPUT); // set the SS pin as an output (necessary!)
  pinMode(SDchipSelectPin, OUTPUT);          // pin 4 -> On the Ethernet Shield, CS is pin 4  pinMode(4, OUTPUT); // set the SS pin as an output (necessary!)
  
// --------  Start ethernet --------------------------------
//  digitalWrite(ETHERNETchipSelectPin, HIGH);      // turn OFF the W5100 chip! by default it will be ON, so unnecessary.
//  digitalWrite(SDchipSelectPin, LOW);             // but turn ON the SD card functionality!

  
   // down ( select next menu line L0, L1, L2, L3 , L0 ring ) 
   pinMode(6, INPUT);        // sets the digital pin as input
   digitalWrite(6, HIGH);    // enable pullup
   // right ( select option of the actual line, if L0 active go up menu )
   pinMode(7, INPUT);        // sets the digital pin as input
   digitalWrite(7, HIGH);    // enable pullup
  
    Serial.begin(ser0bd);  //debug USB line

// SD card

haveuSDcard=SD.begin(SDchipSelectPin);  // DFRobot shield used pin10 for SS ETHERNET CARD pin 4

  if (!haveuSDcard) { Serial.println("SD initialization failed!"); } else {  Serial.println("SD initialization done.");    }
    
  if (haveuSDcard){
     // funny, all works, but filename on card is in capital letters!
     if (SD.exists(fname)) {
       Serial.print("SD data file found "); 
       Serial.println(fname); 
                } else {
       // if not found , make it
       myFile = SD.open(fname, FILE_WRITE);
       myFile.println("loop,millis,Vcc,A0,A1,A2,D6,D7");
       myFile.close();
       Serial.println("SD data file created");   
                  } 

    speedfile();

  } // end if have card
  //  calibrate function  
  VCCread=readVcc();
  Serial.print("Vcc read back with 1V1 Aref ");
  Serial.print(VCCread,DEC);
  Serial.println(" mV"); 


    print_menu();
  
} // end setup

void loop()
{
         if ( cyclecount == 0 ) {  // only check USB every seravail cycles 

           if (Serial.available() > 0) {        // USB terminal interrupt 
		// read the incoming byte:
                            inByte = Serial.read();
                            delay(delayusb);      // wait rest of the string is in buffer 
                            Serial.flush(); // only use first character, skip the rest 
          
            switch (inByte) {
              case 's': //   data dump command from terminal
                                    Serial.println(inByte, BYTE); // echo
                                    datadump = true;
                                    datameasure = false;
                  break;
              case 'm': //   data  measure command from terminal
                                    Serial.println(inByte, BYTE); // echo
                                    datadump = false;
                                    datameasure = true;
                  break;
              case 'h': //   HOLD data  measure command from terminal
                                    Serial.println(inByte, BYTE); // echo
                                    datadump = false;
                                    datameasure = false;
                  break;
              case 'f': //   get file info
                                    Serial.println(inByte, BYTE); // echo
                                    getfileinfo();
                  break;
              case 'd': //   delete file
                                    Serial.println(inByte, BYTE); // echo
                                    filereset();
                  break;
              case 'i': //  serial input of scantime 
                                    Serial.println(inByte, BYTE); // echo
                                    setscan();
                  break;
              case 'v': //  toggle debug mv to USB 
                    if (debugv) { debugv = false; } else { debugv = true; }
                  break;
              default:   // any other character or BLANK ENTER .. show menu 
                  print_menu(); 


            } // end swith input character        
           } // end if serial available

         } // end check USB

  
         Pbutton();
  
  if (datameasure) {
                    if ( (millis() - Ltime ) >= sampletime ) { getandsave(); }
                   } else {
                    if ( (millis() - Ltime ) >= sampletime ) {  Serial.println(" measuring OFF (use m for start )"); Ltime = millis(); }                   
                   }

  if (datadump) { 
                   // datameasure = false;
                   delay(2000);
                   senddataterminal();
                   delay(5000);
                   datameasure = true;
                   datadump=false;
                  }

   cyclecount=cyclecount+1;
   if ( cyclecount > seravail ) {cyclecount = 0; } // reset and timer for serial avail   

} // end loop


void print_menu() {
                  // print menu
                  // use terminal 
                  // - COM xx
                  // - autoscroll ON
                  // - Carriage return ( menu comes at ENTER )
                  // - xxxx baud
                  
                   Serial.println("_________________________________"); 
                   Serial.println("!  kll-engineering on ARDUINO   !"); 
                     Serial.print("! uSD card interface shield ");
                   Serial.print(prev);
                   Serial.println("!");
                   Serial.println("!_______________________________!");  
                   Serial.println("! m start measure ( default)    !");
                   Serial.println("! h hold measurement            !");
                   Serial.println("! s list saved records          !");
                   Serial.println("! f show data file info         !");
                   Serial.println("! d reset data file             !");  
                   Serial.println("! i measuring interval          !");  
                   Serial.println("! v measuring debug toggle      !");  
                   Serial.println("!_______________________________!");  
                   Serial.println("! hit SPACE ENTER to show menu  !"); 
                   Serial.println("!_______________________________!");  
  
                   
                   Serial.print("select: ");
   
}                                                                     // end print_menu 


unsigned long get_set_value (String question, unsigned long defaultval=0, int timeout=0) 
{  
                                                                     // open points: speedtests, timeout 

  int ainByte;
  int Bytecount = 0;	                                             // for incoming serial data
  unsigned long innum=0;                                                       // or long,  int limit is 32,767
  int inval = 0;
  boolean valok = false;                                             // wait for bytes from USB
   
                                                                     // send the question to USB and wait for answer of a set value 
                                                                     // convert to integer
  Serial.print(question);
                                                                    // wait answer
     do {
  	if (Serial.available() > 0) {                               // USB terminal interrupt
          delay(delayusb);                                          //get all the string to buffer
          Bytecount = Serial.available();                           // ask how many bytes, max 128
                                         if (debuga) {
                                            Serial.print (" Bytes: ");
                                            Serial.println(Bytecount);    // diag echo
                                         }                                // end if debug  
          for ( int i=0; i < Bytecount; i++){
            
          ainByte = Serial.read();
          inval = char_num(ainByte);
          if (inval != -1) 
           { 
             if ( inval == -2)                                             // CR LF 
             {
                                                                           // ignore it
             }
             else
             {
               innum = innum*10 + inval;                                   // calc number
             } 
           }
           else                                                            // -1 from char_num function
           { 
             innum = defaultval;                                           // discard input
             i = Bytecount;                                                // stop for loop
             Serial.print (" no number, defaulted to: "); 
           }
          
                                         if (debuga) {
                                           Serial.print ( ainByte);       // byte
                                           Serial.print (" ");
                                            Serial.print(inval);          // diag echo value
                                           Serial.print (" number ");
                                            Serial.println(innum);        // diag echo value
                                         }                                // end if debug  
          }                                                               // end for
           valok = true; 
         }
         else
         { 
                                                                         //delay (delayusb); //and try again
           valok = false;
          }
     } while(valok == false);                                            // wait for answer
     Serial.println(innum);                                              // echo in answer line
     return innum;
}                                                                        // end get_set_value 

void save_timesetpoint()
{
     if (haveuSDcard && SD.exists(sfname)) {
      SD.remove(sfname);
      delay(100);
     } //if file exists

     if (haveuSDcard && !SD.exists(sfname)) {
       myFile = SD.open(sfname, FILE_WRITE);
       myFile.println(sampletime);
       myFile.close();       
     } //if file not exists

} // save_timesetpoint

void setscan()  // menu typed i
{
      sampletime = get_set_value ("scantime setpoint in millis (default 60000): ",60000,0); 
      save_timesetpoint();
} // end setscan




void filereset()  // menu typed d
{
     if (haveuSDcard && SD.exists(fname)) {
      SD.remove(fname);
      delay(100);
     } //if file exists

     if (haveuSDcard && !SD.exists(fname)) {
       myFile = SD.open(fname, FILE_WRITE);
       myFile.println("loop,millis,Vcc,A0,A1,A2,D6,D7");
       myFile.close();       
       loopcount=0;
     } //if file not exists
    Serial.println(" file deleted and created anew "); 
}


void getfileinfo()   // menu typed f
{
     if (haveuSDcard && SD.exists(fname)) {
       myFile = SD.open(fname);  // FOR READ
       Serial.print(fname);
       Serial.print("   ");
       Serial.print(myFile.size());
       Serial.println(" Bytes ");
       myFile.close();
       
     } //if file exists

} // end getfileinfo

void senddataterminal()   // menu typed s
{
     if (haveuSDcard && SD.exists(fname)) {
       myFile = SD.open(fname);  // FOR READ
       if (myFile) {
       while (myFile.available()) { Serial.write( myFile.read() ); }
       myFile.close();
       } // end if data exist
     } // end  card and file ok
} // end senddataterminal

void getandsave() {
  VCCread=readVcc();
  // get data
  Ltime = millis();                  // read actual millis  
  A0val = analogRead(0);
  delay(10);
  A1val = analogRead(1);
  delay(10);
  A2val = analogRead(2);

  // save to SD card if installed
  if (haveuSDcard){
       myFile = SD.open(fname, FILE_WRITE);
 
       myFile.print(loopcount);
       myFile.print(",");
       myFile.print(Ltime);
       myFile.print(",");
       myFile.print(VCCread);
       myFile.print(",");
       myFile.print(A0val);
       myFile.print(",");
       myFile.print(A1val);
       myFile.print(",");
       myFile.print(A2val);
       myFile.print(",");
       // 2 digital lines from PB
       myFile.print(D6val);
       myFile.print(",");
       myFile.print(D7val);
       myFile.println(",");
       

       myFile.close();
       Serial.print("SD_");
                 } // end if have card                
//       print_time();

       Serial.print("rec ");
       Serial.print(loopcount);
       if (debugv) {
         
       Serial.print("_Vcc ");
       Serial.print(VCCread);
       Serial.print("_A0 ");
       Serial.print(A0val);
       Serial.print("_A1 ");
       Serial.print(A1val);
       Serial.print("_A2 ");
       Serial.print(A2val);
       Serial.print("_D6 ");
       Serial.print(D6val);
       Serial.print("_D7 ");
       Serial.print(D7val);
       } // end debugv
       Serial.println("_");
       
       loopcount = loopcount + 1;                                     // for check cycle time 

 
   }  // end getandsave
  
  
  
  
  void speedfile()
  {
   int inval=0; 
   unsigned long innum=0;
   
  if (haveuSDcard){   
      if (SD.exists(sfname)) {
      // if speedfile exists read settings
        myFile = SD.open(sfname);  // FOR READ
        while (myFile.available()) { 
          inval = char_num(myFile.read());
          if (inval != -1) 
           { 
             if ( inval == -2)                                             // CR LF 
             {     }// ignore it
             else
             { innum = innum*10 + inval;  } // calc number
           } else {  // no number character found 
             innum = 60000;                                           // discard input
             Serial.print (" no good speed number, defaulted to: 1 min"); 
           }
       } // while reading characters
       
       myFile.close();
              
       Serial.print("SD speed file found "); 
       Serial.print(sfname);
       Serial.print(" ");
       Serial.print(innum);
       Serial.println(" millis ");

       
     } else {
     // create speedfile
       myFile = SD.open(sfname, FILE_WRITE);
       myFile.println("60000");    // default 60000 millis is 1 min
       myFile.close();       
       Serial.print(sfname);
       Serial.println(" default created ");
       innum = 60000;                                           // default  1 min
     }
   sampletime=innum;
  } // SD card installed
  }// end speedfile
  
  
int char_num(int inChar) {
  if (inChar == 48) { return 0; }
  if (inChar == 49) { return 1; }
  if (inChar == 50) { return 2; }
  if (inChar == 51) { return 3; }
  if (inChar == 52) { return 4; }
  if (inChar == 53) { return 5; }
  if (inChar == 54) { return 6; }
  if (inChar == 55) { return 7; }
  if (inChar == 56) { return 8; }
  if (inChar == 57) { return 9; }
  if (inChar == 10) { return -2; }                                    // LF
  if (inChar == 13) { return -2; }                                    // CR
  
  return -1;                                                          // must be bad input / no number / or bad communication 
}                                                                     // end function

void Pbutton()               // read all time, not only at scan time
 {
   D6val = digitalRead(6);
   D7val = digitalRead(7);
 } // end 


