// SNAKE game

// snake.pde ( as processing sketch )
// snake.pjs ( as processing.js HTML load )

// All Examples Written by Casey Reas and Ben Fry  
// unless otherwise stated. 

// this project consists of 4 basic elements ( mostly from examples):
// the german snake ( by unknown) copy from processingjs.org :  examples custom demos snake
// a ( preloaded for processing.js) loaded picture FROG
// let the frog ( picture) jumping arround by BOUNCE example
// a ( preloaded) IMAGE BUTTON by 3 pictures ( for game restart )

// some game features:

// playerlevel ( with text )
// from delta = 10 down to 1 
// means how easy SNAKE can eat FROG ( pixel distance between snake head ( mousepointer )
// and FROG picture 
// also defines where FROG is inside SNAKE after eat

// independent of level at each restart: increase speed of frog
// limited by browser

// a random UPS function: ( FROG eat SNAKE , game end. )
// requires reload of game / webpage
//
// 
// by KLL-engineering
//
// developed under                  processing 1.2.1
// uploaded and test with           processing.js 1.0
// -- CHROME
// -- OPERA
// -- FIREFOX
// IE 8 and (9 beta 7) dont work


/* @pjs preload="images/play.png,images/over.png,images/pressed.png,images/frog.gif"; */
PImage a;                   // frog variables

int psize = 25;             // picture size
float xpos = 0, ypos = 0;   // Starting position    

float xspeed = 2.8;  		// Speed of the shape
float yspeed = 2.2;  		// Speed of the shape
float speedup = 1.0;

int xdirection = 1;  		// Left or Right
int ydirection = 1;  		// Top to Bottom

                            // snake variables
float[] x = new float[20];
float[] y = new float[20];
float segLength = 10;
int swide = 16, eyes = 4;
                            // game variables
boolean startup = true, eat = false, ups = false;
int delta = 10;              // player level 10 .. 1 ( delta pix frog snakehead if mouse pressed )
int startcount = 0;
ImageButtons button;


void setup() {
  size(600, 100);
  a = loadImage("images/frog.gif");
  // Define and create image button
  PImage butb = loadImage("images/play.png");
  PImage butr = loadImage("images/over.png");
  PImage butd = loadImage("images/pressed.png");
  int butx = width - butb.width;
  int buty = height - butb.height; 
  int butw = butb.width;
  int buth = butb.height;
  button = new ImageButtons(butx, buty, butw, buth, butb, butr, butd);
  smooth();
}  // end setup

void draw() {
  background(100,250,50);              // gras green 
  if (startup) {
  text(" mouse move SNAKE, mouse click open SNAKE MOUTH to eag FROG ",210,50);
  startcount = startcount + 1;
  if ( startcount == 600 ) {   startup = false; }   // end / framerate = seconds delay
                 }
  if ( !eat ) { 
  frogging();                          // add a jumping frog
  dragSegment(0, mouseX, mouseY);      // snake head follow mouse
  for(int i=0; i < x.length-1; i++) { dragSegment(i+1, x[i], y[i]); }   // and the rest of it
  text(" Player Level "+delta,510,90);
  gotit();                             // check on mouse click and mouse over(near) FROG
  
  } else {
    if ( !ups ) {
                dragSegment(0, 80, 30);      // snake full and sleep, away from button
                for(int i=0; i < x.length-1; i++) { dragSegment(i+1, x[i], y[i]); }   // and the rest of it
                button.update();
                button.display();
    }else{
                speedup = 0.5;              // slow
                frogging();                 // only show double size frog
                text(" UPS ",510,90);

    }
  }         

 }  // end draw

void gotit() {
  if ( ( abs(int(xpos) - mouseX) <= delta ) && ( abs(int(ypos) - mouseY) <= delta ) && (mousePressed == true) && ( !eat ) )   // snake head and frog in delta pix range
       { 
                      if ( delta > 1 ) { delta = delta -1; }
                      if ( int(random(1,8)) == 4 ) { ups = true; }     // frog eat snake !! game end
                      eat = true;
       }
}  // end gotit


void dragSegment(int i, float xin, float yin) {
  float dx = xin - x[i];
  float dy = yin - y[i];
  float angle = atan2(dy, dx);  
  x[i] = xin - cos(angle) * segLength;
  y[i] = yin - sin(angle) * segLength;
  //stroke(23, 79, 4, 220);
  
  pushMatrix();
  translate(x[i], y[i]);
  rotate(angle);
  
  color c;
  
  if ( i % 3 == 1 )
    c = color(0, 0, 0, 255);
  else if ( i % 3 == 2 )
    c = color(255, 255, 0, 255);
  else
    c = color(255, 0, 0, 255);

  stroke( c );
  strokeWeight(swide);
  if ( i == 0 )  {                                // bigger head
  strokeWeight(swide + 4 );  
   if (mousePressed == true) {
  strokeWeight(swide + 14 );                      // open mouth on click
                             }
  }   // head size
  
  // where is the frog?
  if ( ( i == delta ) && eat )  {strokeWeight( 3*swide ); }
  
  line(0, 0, segLength, 0);
  
  if ( i == x.length - 1 )
  {
    fill( c );
    noStroke();
    beginShape(TRIANGLES);
    vertex(0, swide/2);
    vertex(-3 * segLength, 0);                     // tail length
    vertex(0, -swide/2);
    endShape();
  }
  
  if ( i == 0 )
  {
   noStroke();
   fill(0, 255);                                   // 2 black eyes
   ellipse(segLength, -eyes, eyes, eyes);
   ellipse(segLength,  eyes, eyes, eyes);
  }
  
  popMatrix();
}   // end dragsegment


void frogging() { 
  
  // Update the position of the frog
  xpos = xpos + ( xspeed * speedup * xdirection );
  ypos = ypos + ( yspeed * speedup * ydirection );
  
 // Test to see if the shape exceeds the boundaries of the screen
 // If it does, reverse its direction by multiplying by -1
  if (xpos > width -psize || xpos < 0) { xdirection *= -1; }
  if (ypos > height-psize || ypos < 0) { ydirection *= -1; }

  if ( ups ) {
  image( a, xpos, ypos, psize*2, psize*2);       // frog picture  
  } else {
  image( a, xpos, ypos, psize, psize);       // frog picture
         }
} // end frogging

class Button
{
  int x, y;
  int w, h;
  color basecolor, highlightcolor;
  color currentcolor;
  //boolean over = false;
  boolean bpressed = false, mempressed = false, waspressed = false;  
  
  void buttonpressed() {
    if(overRect(x, y, w, h) && mousePressed) {
      bpressed = true;
    } else {
      bpressed = false;
      if ( mempressed ) { waspressed = true; }
    }    
    mempressed = bpressed;             // memory
  }
  
  boolean overRect(int x, int y, int bwidth, int bheight) {
  if ( ( mouseX >= x ) && ( mouseX <= x+bwidth ) && ( mouseY >= y ) && ( mouseY <= y+bheight ) ) {
    return true;
       } else {
    return false;
              }
}
}

class ImageButtons extends Button 
{
  PImage base;
  PImage roll;
  PImage down;
  PImage currentimage;

  ImageButtons(int ix, int iy, int iw, int ih, PImage ibase, PImage iroll, PImage idown) 
  {
    x = ix;
    y = iy;
    w = iw;
    h = ih;
    base = ibase;
    roll = iroll;
    down = idown;
    currentimage = base;
  }
  
  void update() 
  {
    buttonpressed();
    if( bpressed ) {
      currentimage = down;
    } else if (overRect(x, y, w, h)){
      currentimage = roll;
    } else {
      currentimage = base;
    }
    if ( waspressed ) {
                        eat = false;
                        speedup = speedup + 0.1;   // independend from player level
                        waspressed = false;
                        }
  }
  
 
  void display() 
  {
    image(currentimage, x, y);
  }
}

