/*_________________________________________________________________ */
/*  KLL-engineering                                                 */
/*  V0.1 6.5.2011 start                                             */
/*  V0.2 time controlled measuring loop  (millis)                   */
/*  V0.3 serial menu and speedfile on uSD card                      */
/*  V0.4 D6,D7 pushbutton, also logged                              */
/*  V0.5 test with original ethernet shield and Vccreadback         */
/*  V0.6 problem  with un setup??                                   */
/*  V0.7 start again for POWER METER                                */
/*  V0.8 include MODEM SMS and EMON ALARM                           */
/*_________________________________________________________________ */
/*   how to use uSD, alarm and SMS function                         */
/*   -- configure alarm limits for volt and current        line 141 */
/*   -- how many times the alarm must come before SMS send line 143 */
/*   -- configure mobile number for SMS to go              line 73  */
/*                                                                  */
/*   -- how many current inputs 1..5                       line 139 */
/*                                                                  */
/*   -- configure the shield SS pin for SD 10 or 4         line 127 */
/*_________________________________________________________________ */


char prev[5]="V0.8"; 


#include <avr/pgmspace.h>
// menu in FLASH
prog_uchar PROGMEM menu01[] = {"\n________________________________________"};//
prog_uchar PROGMEM menu02[] = {"  kll-engineering on ARDUINO            "};//
prog_uchar PROGMEM menu03[] = {"  POWER meter, uSD card, modem    "};//
//                   Serial.println(prev);
prog_uchar PROGMEM menu04[] = {"_________________________________________"};//
prog_uchar PROGMEM menu05[] = {" m start measure ( default)              "};//
prog_uchar PROGMEM menu06[] = {" h hold measurement                      "};//
prog_uchar PROGMEM menu07[] = {" s list saved records                    "};//
prog_uchar PROGMEM menu08[] = {" f show data file info                   "};//
prog_uchar PROGMEM menu09[] = {" d reset data file                       "};//
prog_uchar PROGMEM menu10[] = {" i measuring interval                    "};//
prog_uchar PROGMEM menu11[] = {" v measuring debug toggle                "};//
prog_uchar PROGMEM menu12[] = {" t send test SMS                         "};//
prog_uchar PROGMEM menu13[] = {"                                         "};//
//prog_uchar PROGMEM menu14[] = {"                                                               "};//          
//prog_uchar PROGMEM menu15[] = {"                                                               "};//
//prog_uchar PROGMEM menu16[] = {"                                                               "};//
//prog_uchar PROGMEM menu17[] = {"__________________________________________"};//
//prog_uchar PROGMEM menu18[] = {"                                                               "};//
//prog_uchar PROGMEM menu19[] = {"                                                               "};//
prog_uchar PROGMEM menu20[] = {"________Ix, W , VA , p , Vrms , Irms______"};//
prog_uchar PROGMEM menu21[] = {"select: "};//



prog_uchar PROGMEM sertxt01[] = {"kll-engineering on ARDUINO"};   //  (# -1) = 25
// for (int i=0; i<=25; i++) { Serial.print(pgm_read_byte(&sertxt01[i])); } Serial.println();
prog_uchar PROGMEM sertxt02[] = {"hit BLANK ENTER"};   //  (# -1) = 14
//prog_uchar PROGMEM sertxt03[] = {"Ix, W , VA , p , Vrms , Irms"};   //  (# -1) = 27
//prog_uchar PROGMEM sertxt04[] = {" to big, defaulted to: "};   //  (# -1) = 22
prog_uchar PROGMEM sertxt05[] = {" no number, defaulted to: "};   //  (# -1) = 25


//prog_uchar PROGMEM sertxt08[] = {"Vcal integer ( 100 for 1.0):     "};   //  (# -1) = 32
//prog_uchar PROGMEM sertxt09[] = {"Ical integer ( 100 for 1.0):     "};   //  (# -1) = 32
//prog_uchar PROGMEM sertxt10[] = {"Phasecal integer ( 230 for 2.3): "};   //  (# -1) = 32
// SD CARD
prog_uchar PROGMEM sdtxt01[] = {"scantime in millis (default 60000): "};   //  (# -1) = 35
prog_uchar PROGMEM sdtxt02[] = {"loop,millis,I,W,VA,p,Vrms,Arms"};   //  (# -1) = 29
prog_uchar PROGMEM sdtxt03[] = {"new file created "};   //  (# -1) = 16
prog_uchar PROGMEM sdtxt04[] = {" file deleted "};   //  (# -1) = 13
prog_uchar PROGMEM sdtxt05[] = {" no number, defaulted 1 min"};   //  (# -1) = 26
// MODEM
prog_uchar PROGMEM ATtxt01[] = {"AT+CMGF=1"};      //  (# -1) = 8
prog_uchar PROGMEM ATtxt02[] = {"AT+CMGS="};       //  (# -1) = 7
prog_uchar PROGMEM ATtxt03[] = {"+66*********"};   //  (# -1) = 11  // +66 thailand
//prog_uchar PROGMEM ATtxt03[] = {"+66 "};   //  (# -1) = 11  KLL 
//prog_uchar PROGMEM ATtxt03[] = {"+66 "};   //  (# -1) = 11  THOMAS 
prog_uchar PROGMEM ATtxt04[] = {"ALARM "};         //  (# -1) = 5
prog_uchar PROGMEM ATtxt05[] = {"DATA  "};         //  (# -1) = 5


// uSD_kll

// 6.5.2011 add uSD card (4GB Kingston)


// as     PIN0 and PIN1 are used for serial / USB communication
// interface shield uSD card slot
// PIN10  SS
// PIN11  MOSI
// PIN12  MISO
// PIN13  SCK and ARDUINO motherboard yellow LED

// only   PIN2 PIN4, PIN5 is  still unused!

// pin6 and pin7 for push button to GND wired on my own add on shield ( on interface shield )

// incl ARDUINO SD Card library
#include <SD.h>
//SD card uses SPI, which takes place on digital pins 11, 12, and 13 (
//Additionally, another pin must be used to select the SD card. This can be the hardware SS pin - pin 10 (on most Arduino boards)

boolean haveuSDcard = false;
File myFile;
// char fname[]="kll_data.csv";
char fname[]="powerdat.csv"; // file name must 8.3 type
char sfname[]="scan.txt";

 int A0val,A1val; //,A2val,A3val,A4val,A5val,D1val,D2val,D3val,D4val,D5val,D6val,D7val;

 unsigned long Ltimecard=0;  
 unsigned long Ltime=0;  
 unsigned long Ltime_old;                         // milliseconds memory last scan
 unsigned long Ltime_delta;                       // milliseconds delta from last scan

 unsigned long loopcount=0;                       // sd card record
 unsigned long sampletime=60000;  // milli seconds
 
 boolean datameasure=true, datadump=false;
 
 long ser0bd = 115200;                               // 300, 1200, 2400, 9600, 14400, 19200, 28800, 38400, 57600, 115200
 int inByte;
 int delayusb = 100;                               // at 57600  setpointinput 2,3 digit dont work with 10 or 100
 
 boolean debugv = false;
 boolean debuga = false;                          // from get_set_value int function only
 boolean debugl = false;                           // alarmcounter in emon_alarm
 
const int SDchipSelectPin = 10;             // original ETHERNET CARD 4, DFRobot shield 10
//const int ETHERNETchipSelectPin = 10;      // original ETHERNET CARD 10,

long VCCread=0;

//                                              EMON variables
//Setup variables
const int numberOfSamples = 3000;

//Set Voltage and current input pins
const int inPinV = 0;
int inPinI = 1;       
int inPinIlim = 1;     // ( 1 .. 5 currents measurement loop )
//                                             alarm limits for emon_alarm
float highlim[6] = {260.0, 4.0,4.0,4.0,4.0,4.0}, lowlim[6] = {-200.0, -1.0,-2.0,-3.0,-4.0,-5.0};
int alarmhighcount[6],alarmlowcount[6];                 // remember the consecutive alarmsituation for one input
int alarmcountlim=100;              // so 100 times must be a value out of alarmlimit to raise the SMS alarm

//Sanity check calibration method thanks to Eric Sandeen http://sandeen.net/wordpress
//See discussion here: http://openenergymonitor.org/emon/node/59
//Enter the values of your setup below 

// Voltage is reduced both by wall xfmr & voltage divider
#define AC_WALL_VOLTAGE        210.7
#define AC_ADAPTER_VOLTAGE     8.7
// Ratio of the voltage divider in the circuit
#define AC_VOLTAGE_DIV_RATIO   11.0    // 1kohm  , 100ohm  ==  1100/100 = 11
// CT: Voltage depends on current, burden resistor, and turns
#define CT_BURDEN_RESISTOR    470.0
#define CT_TURNS              1000.0



// NOTE in arduino DOUBLE same as REAL ( use 4 BYTES )    KLL

//Calibration coeficients
//These need to be set in order to obtain accurate results
//Set the above values first and then calibrate futher using normal calibration method described on how to build it page.
const double VCAL = 1.00;
const double ICAL = 1.00;
const double PHASECAL = 2.3;   //    2.3

// Initial gueses for ratios, modified by VCAL/ICAL tweaks
//#define AC_ADAPTER_RATIO       (AC_WALL_VOLTAGE / AC_ADAPTER_VOLTAGE)
//double V_RATIO_org = AC_ADAPTER_RATIO * AC_VOLTAGE_DIV_RATIO * 5.0 / 1024.0 * VCAL;
//double I_RATIO_org = (long double)CT_TURNS / CT_BURDEN_RESISTOR * 5.0 / 1024.0 * ICAL;

double V_RATIO,I_RATIO;   // for use after calibration  KLL

//Sample variables
int lastSampleV,lastSampleI;   
int sampleV,sampleI;

//Filter variables
double lastFilteredV, lastFilteredI;
double filteredV, filteredI;
// double filterTemp;             // KLL

//Stores the phase calibrated instantaneous voltage.
double shiftedV;

//Power calculation variables
double sqI,sqV,instP,sumI,sumV,sumP;

//Useful value variables
double realPower,
       apparentPower,
       powerFactor,
       Vrms,
       Irms;
       

 int cyclecount=0,seravail=1000;                      // loop and limit to check serial
 unsigned long  emonjobcount=0,emonjoblim=500000;    // timing for emon calc 500.000 about 4 sec 1 sec emon, every 5 sec
                              
// MODEM

#include <NewSoftSerial.h>

NewSoftSerial m32_serial(2, 3); // Order is input pin, output pin
  char inChar = 'A';
  boolean debugm = false;
  
/*
  if ( m32_serial.available() ) { 
    inChar =  (char)m32_serial.read();
    if (debugm) { Serial.print(inChar); } 
*/

//__________________________________________________________________________________________________


void setup()
{
  
  // ------------ Set pin modes ... ----------------------------------------------
 // pinMode(ETHERNETchipSelectPin, OUTPUT);    // pin 10 -> make sure that the default chip select pin is set to output, even if you don't use it:  pinMode(10, OUTPUT); // set the SS pin as an output (necessary!)
  pinMode(SDchipSelectPin, OUTPUT);          // pin 4 -> On the Ethernet Shield, CS is pin 4  pinMode(4, OUTPUT); // set the SS pin as an output (necessary!)
  
// --------  Start ethernet --------------------------------
//  digitalWrite(ETHERNETchipSelectPin, HIGH);      // turn OFF the W5100 chip! by default it will be ON, so unnecessary.
//  digitalWrite(SDchipSelectPin, LOW);             // but turn ON the SD card functionality!

  
   // down ( select next menu line L0, L1, L2, L3 , L0 ring ) 
   //pinMode(6, INPUT);        // sets the digital pin as input
   //digitalWrite(6, HIGH);    // enable pullup
   // right ( select option of the actual line, if L0 active go up menu )
   //pinMode(7, INPUT);        // sets the digital pin as input
   //digitalWrite(7, HIGH);    // enable pullup
  
    Serial.begin(ser0bd);      //debug USB line
    m32_serial.begin(9600);    // MODEM on (in D2, out D3 )
    
//Serial.print("Mem free: "); Serial.println(availableMemory());
  //                               show 156 but menu not run 
  //     shorten some text              214 menu ok
  //     menu in flash                  690
  //     emon start                     616
  //     more variables                 604
  //                                    638
  //     incl. modem                    478                  
  //     sd text , AT text to flash     624
  //     alarm tool                     464

// SD card

haveuSDcard=SD.begin(SDchipSelectPin);  // DFRobot shield used pin10 for SS ETHERNET CARD pin 4

  if (!haveuSDcard) { Serial.println("SD init failed!"); } else {  Serial.println("SD init done.");    }
    
  if (haveuSDcard){
     // funny, all works, but filename on card is in capital letters!
     if (SD.exists(fname)) {
       Serial.print("SD data file "); 
       Serial.println(fname); 
                } else {     filenew();  // if not found , make it
                       } 

    speedfile();

  } // end if have card
  //  calibrate function  
  VCCread=readVcc();
  Serial.print("Vcc ");
  Serial.print(VCCread,DEC);
  Serial.println(" mV"); 

  for (int i=0; i<=25; i++) { Serial.print(pgm_read_byte(&sertxt01[i])); } Serial.println();
  for (int i=0; i<=14; i++) { Serial.print(pgm_read_byte(&sertxt02[i])); } Serial.println();

//    print_menu();
  
} // end setup







void loop()
{
         if ( cyclecount == 0 ) {  // only check USB every seravail cycles 

           if (Serial.available() > 0) {        // USB terminal interrupt 
		// read the incoming byte:
                            inByte = Serial.read();
                            delay(delayusb);      // wait rest of the string is in buffer 
                            Serial.flush(); // only use first character, skip the rest 
          
            switch (inByte) {
              case 's': //   data dump command from terminal
                                    Serial.println(inByte, BYTE); // echo
                                    datadump = true;
                                    datameasure = false;
                  break;
              case 'm': //   data  measure command from terminal
                                    Serial.println(inByte, BYTE); // echo
                                    datadump = false;
                                    datameasure = true;
                  break;
              case 'h': //   HOLD data  measure command from terminal
                                    Serial.println(inByte, BYTE); // echo
                                    datadump = false;
                                    datameasure = false;
                  break;
              case 'f': //   get file info
                                    Serial.println(inByte, BYTE); // echo
                                    getfileinfo();
                  break;
              case 'd': //   delete file
                                    Serial.println(inByte, BYTE); // echo
                                    filereset();
                  break;
              case 'i': //  serial input of scantime 
                                    Serial.println(inByte, BYTE); // echo
                                    setscan();
                  break;
              case 'v': //  toggle debug mv to USB 
                                   if (debugv) { debugv = false; } else { debugv = true; }
                  break;
              case 't': //  test SMS 
                                   Serial.println(inByte, BYTE); // echo
                                   
                                   MODEM_SMS(true);
                  break;
              default:   // any other character or BLANK ENTER .. show menu 
                  print_menu(); 


            } // end swith input character        
           } // end if serial available

         } // end check USB

  
//         Pbutton();
  
  if (datameasure) {
                    if ( (millis() - Ltimecard ) >= sampletime ) { getandsave(); }
                   } else {
                    if ( (millis() - Ltimecard ) >= sampletime ) {  Serial.println(" measuring OFF (use m for start )"); Ltimecard = millis(); }                   
                   }

  if (datadump) { 
                   // datameasure = false;
                   delay(2000);
                   senddataterminal();
                   delay(5000);
                   datameasure = true;
                   datadump=false;
                  }
 
//  int emonjobcount=0,emonjoblim=30000;    // timing for emon calc
                 
   
   cyclecount=cyclecount+1;
   if ( cyclecount > seravail ) {
                                                         cyclecount = 0; 
                                 } // reset and timer for serial avail   
    emonjobcount = emonjobcount + 1;
    if ( emonjobcount > emonjoblim ) {
                                                          emonjobcount=0;
                                                          emon();      // read 3000 times VOLT and AMP takes more as 1 sec
                                                          inPinI = inPinI + 1;                         // up to 5 currents
                                                          if (inPinI == inPinIlim+1 ) {inPinI = 1;}

                                     }

} // end loop









unsigned long get_set_value (String question, unsigned long defaultval=0, int timeout=0) 
{  
                                                                     // open points: speedtests, timeout 

  int ainByte;
  int Bytecount = 0;	                                             // for incoming serial data
  unsigned long innum=0;                                                       // or long,  int limit is 32,767
  int inval = 0;
  boolean valok = false;                                             // wait for bytes from USB
   
                                                                     // send the question to USB and wait for answer of a set value 
                                                                     // convert to integer
  Serial.print(question);
                                                                    // wait answer
     do {
  	if (Serial.available() > 0) {                               // USB terminal interrupt
          delay(delayusb);                                          //get all the string to buffer
          Bytecount = Serial.available();                           // ask how many bytes, max 128
                                         if (debuga) {
                                            Serial.print (" Bytes: ");
                                            Serial.println(Bytecount);    // diag echo
                                         }                                // end if debug  
          for ( int i=0; i < Bytecount; i++){
            
          ainByte = Serial.read();
          inval = char_num(ainByte);
          if (inval != -1) 
           { 
             if ( inval == -2)                                             // CR LF 
             {
                                                                           // ignore it
             }
             else
             {
               innum = innum*10 + inval;                                   // calc number
             } 
           }
           else                                                            // -1 from char_num function
           { 
             innum = defaultval;                                           // discard input
             i = Bytecount;                                                // stop for loop
             //Serial.print (" no number, defaulted to: "); 
               for (int i=0; i<=25; i++) { Serial.print(pgm_read_byte(&sertxt05[i])); }
           }
          
                                         if (debuga) {
                                           Serial.print ( ainByte);       // byte
                                           Serial.print (" ");
                                            Serial.print(inval);          // diag echo value
                                           Serial.print (" number ");
                                            Serial.println(innum);        // diag echo value
                                         }                                // end if debug  
          }                                                               // end for
           valok = true; 
         }
         else
         { 
                                                                         //delay (delayusb); //and try again
           valok = false;
          }
     } while(valok == false);                                            // wait for answer
     Serial.println(innum);                                              // echo in answer line
     return innum;
}                                                                        // end get_set_value 
  
  
  
  
  
int char_num(int inChar) {
  if (inChar == 48) { return 0; }
  if (inChar == 49) { return 1; }
  if (inChar == 50) { return 2; }
  if (inChar == 51) { return 3; }
  if (inChar == 52) { return 4; }
  if (inChar == 53) { return 5; }
  if (inChar == 54) { return 6; }
  if (inChar == 55) { return 7; }
  if (inChar == 56) { return 8; }
  if (inChar == 57) { return 9; }
  if (inChar == 10) { return -2; }                                    // LF
  if (inChar == 13) { return -2; }                                    // CR
  
  return -1;                                                          // must be bad input / no number / or bad communication 
}                                                                     // end function


                                                       // my_functions
void get_time() {
                    Ltime = millis();                  // read actual millis  
                    Ltime_delta = Ltime - Ltime_old;   // remember delta time between 2 readings
                    Ltime_old = Ltime;                 // remember this time for next delta calc
}                                                      // end get_time



/*
void Pbutton()               // read all time, not only at scan time
 {
   D6val = digitalRead(6);
   D7val = digitalRead(7);
 } // end 

*/
