void emon() {
                             //  KLL
  VCCread=readVcc();         // calibrate on Vcc  in millivolt
  V_RATIO = AC_WALL_VOLTAGE / AC_ADAPTER_VOLTAGE * AC_VOLTAGE_DIV_RATIO * VCCread / 1024.0 * VCAL / 1000.0;
  I_RATIO = CT_TURNS / CT_BURDEN_RESISTOR * VCCread / 1024.0 * ICAL / 1000.0;
                             //
                             

  if (debugv) {
    get_time();
    Serial.print(", dt: ");
    Serial.print(Ltime_delta);
    Serial.print(", ");
                                                        } else {
    Serial.print(", ");
                                                                     }


for (int n=0; n<numberOfSamples; n++)
{

   //Used for offset removal
   lastSampleV=sampleV;
   lastSampleI=sampleI;
   
   //Read in voltage and current samples.   
   sampleV = analogRead(inPinV);
   //delayMicroseconds(20);                    // kll
   sampleI = analogRead(inPinI);
   
   //Used for offset removal
   lastFilteredV = filteredV;
   lastFilteredI = filteredI;                //kll
  
   //Digital high pass filters to remove 2.5V DC offset.
   filteredV = 0.996*(lastFilteredV+sampleV-lastSampleV);
   //filteredV = sampleV - 512;                                       // mod KLL
   filteredI = 0.996*(lastFilteredI+sampleI-lastSampleI);
   //filteredI = sampleI - 512;                                       // mod KLL
   
   
   //Phase calibration goes here.
   shiftedV = lastFilteredV + PHASECAL * (filteredV - lastFilteredV);
  
   //Root-mean-square method voltage
   //1) square voltage values
   sqV= filteredV * filteredV;
   //2) sum
   sumV += sqV;
   
   //Root-mean-square method current
   //1) square current values
   sqI = filteredI * filteredI;
   //2) sum 
   sumI += sqI;

   //Instantaneous Power
   instP = shiftedV * filteredI;
   //Sum
   sumP +=instP;
}

//Calculation of the root of the mean of the voltage and current squared (rms)
//Calibration coeficients applied. 
Vrms = V_RATIO*sqrt(sumV / numberOfSamples); 
Irms = I_RATIO*sqrt(sumI / numberOfSamples); 

//Calculation power values
realPower = V_RATIO*I_RATIO*sumP / numberOfSamples;
apparentPower = Vrms * Irms;
powerFactor = realPower / apparentPower;

// alarm tool
      emon_alarm();
//Output to serial
Serial.print("I: ");
Serial.print(inPinI);
Serial.print(" , ");
Serial.print(realPower);
Serial.print(", ");
Serial.print(apparentPower);
Serial.print(", ");
Serial.print(powerFactor);
Serial.print(", ");
Serial.print(Vrms);
Serial.print(", ");
Serial.print(Irms);

//Reset accumulators
sumV = 0;
sumI = 0;
sumP = 0;


                                                  if (debugv) {
    get_time();
    Serial.print(", dt: ");
    Serial.print(Ltime_delta);
    Serial.println();
                                                              } else {
    Serial.println(", ");
                                                                     }
                                                                     
}
