// ARDUINO SCOPE 
// use processing, controlP5 lib, arduinoscope lib
// on original ARDUINO UNO hardware

// kll engineering  
// mailto:kllsamui@gmail.com
// start 15.11.2010

// copy from:
// basic serial arduinoscope by   (c) 2009 David Konsumer <david.konsumer@gmail.com>
//
// load to arduino: "mini_scope_kll_ascii" sketch
//  with ARDUINO software
//  close ARDUINO software
//
// start Processing software
// open this sketch "mini_scope_kll_ascii"
// check on serial com port
// adjust port like 'Serial.list()[4]' here 'com13'
// run again

// digital output to PIN 13 onboard LED
// by arduino toggle after 1000 loops with analog reads, send serial data and adjusted delay time default 6 ( for slow PC)


// netbook
//   channel delaytime(ms)  sec/1000loops     sample rate Hz
//      6       0               2              300
//      6       2               4              200
//      2       2               3              250
//      1       2               2              300
//      1       1               1.5            450
//      1       0               <1             dropped
//      
// desktop
//      1       0               <1             750

// tests with v0.2beta    8 int as 16 byte serial datatransfer show no better results
//      6       0               1              530
//      1       0               0.7            730
// so go back to ascii

// netbook 
// show new sec puls pin 11 
// but need external signal as ref for calibration !!!

// mainscreen show on netbook 36  sec ( low + high pin 11 ) desktop 8.5 sec ??  DAVID ANY IDEA?
// after use ZOOM the sec pulses are shorter ?? 41 sec by arduino or by scope??

//       6       6              8              115
//       3       6              8              125
//       3       4              5.5            182
//       1       4                             191
//       3       2              3.5            289
//       1       2                             305
//       3       1              3              350 / 420
//       1       1                             450
//       3       0       drop

//       6       1                             280 / 300
//       1       1                             450
// desktop check again
//       3       1               2             350 / 404
//       1       1                             450
//       3       0               2             530 / 630
//       1       0                             740



// Analog input (A0 .. A6) and Volt indication incl. scope
// 

// operation:
// key 1,2,3,4,5,6 goes to arduino and adjust how many analog channels are read
// 
// key + - adjust a delaytimer ( from default 6 ) on ARDUINO
// play now with UP == [+] == +2    DOWN ==[-] == -1
//
// if your computer / by serial port / is in overload and u see
// processor at 100%, msg in processing package dropped

// see on LED about timing for 1000 loops ( Arduino) / data send 
// depending on adjusted channels analog read and adjusted delay

// key d toggels diagnostic print of data ( processing only )

// 17.11.2010 next 
// ok, as sync and delaytime and channel adjust helps for communication,
// but the samplerate is poor
// no we make a new approach  ZOOM / batch SAMPLING and TRANSMITTING
// key 'z' ARDUINO goes to batch mode
//
// sample 512 data to array as fast as possible ( i think i see 8.8kHz ? ) 
// with a jumperwire A0 to D11 pwm 50% count 9 low, 9 high, are 18 samples per 490Hz PWM at zoom
// with a jumperwire A0 to D10 pwm 10% still see clean high low at zoom
//
// ARDUINO serial send text "startbatch," 512 integer ( as ascii ) with ',' and "endbatch," 
// uses delaytime for serial send
// here we catch it to array and show in a new zoom scope window. ( zoom in time and space !!)
// all takes about 2 sec.
// ups, i dont know how to close this zoom windows, how to name them...
// only main window can close, this closes all zoom windows.

// V0.2 use on serial link
// 8 int as 16 byte record for 6 analog values , spare for Din , frame + command bytes 
// this version dropped because not better ( like the sync version )

// V0.3 use control button for better look
// V0.4  21.11.2010   
// sec puls from arduino Dout 11,
// + key +2, -key -1 / also as buttons
// the key operation 6 ..1 for sampling arduino how many channel
// i dont want to make as button, but also dont want to hide the text,
// because still its significant in sample rate  (all 6  290Hz / only 1 450Hz )

// the one shot A0zoom function with about 8.9kHz ( 28 PWM cycles )
// now with SAVE button ( file goes processing dir!!??)

// hope someone with good hardware ( calibrated signalgenerator.. )
// can verify this info, pls report back

// V0.5 incl a FFT on A0zoom (22.11.2010)
// int zsamplerate=8900; // to be checked  // used for FFT


// see dir [code]
import arduinoscope.*;              //   (c) 2009 David Konsumer <david.konsumer@gmail.com>
import processing.serial.*;
// see dir [code]
import controlP5.*;                 // http://www.sojamo.de/libraries/controlP5/

PFont fontLarge;
PFont fontSmall;
int[] vals;

import cc.arduino.*;

int multiscope = 6;  
int ldelta =0; // black lines for 1V/dev

int channels=6;
int delaytime = 6;    // ARDUINO start value
Oscilloscope[] scopes = new Oscilloscope[multiscope];  // 
Serial port;
int LINE_FEED=10; 

ControlP5 controlP5;                          // for buttons...

// Arduino arduino;                              // NO firmata

color off = color(4, 79, 111);
color on = color(184, 145, 0);
int dvalue =  Arduino.LOW;
int avalue = 0;                                      // analog read from A0
int mysetpulson = 127;                               // on pin 11 for check a PWM 50%

long loopcount, actmillis, oldmillis, deltamillis;
int loopend=1000;
int samplerate=0;
boolean debugp=false; // show sample rate
boolean debugd=false; // show income data.. diagnostic

// batch window variables
boolean batchmode=false, batchdata=false, showbatch=false;
int[] zoomarrray = new int[512];
int zline=0;
int zsamplerate=8900; // to be checked  // used for FFT
// PFrame f;
secondApplet s;
Oscilloscope[] Zscope = new Oscilloscope[1];  // use new zoom scope window 
int Zwidth=512;
int Zheight=520;
ControlP5 ZcontrolP5;                          // for buttons in zoom

// FFT
import ddf.minim.analysis.*;
import ddf.minim.*;
import ddf.minim.signals.*;

FFT fft;
float[] buffer = new float[512];


void setup() {
  size(642, 520);    // 642 - 130 textarea is 512 scope pixel
  controlP5 = new ControlP5(this);
  
  // set these up under tools/create font, if they are not setup.
  fontLarge = loadFont("TrebuchetMS-20.vlw");
  fontSmall = loadFont("Uni0554-8.vlw");

  vals = new int[multiscope];
  
  int[] dimv = new int[2];
  dimv[0] = width-130;                    // 130 margin for text
  dimv[1] = (height-30)/multiscope;       // for scope area
  
    for (int i=0;i<multiscope;i++){
          int[] posv = new int[2];
          posv[0]=0;
          posv[1]=dimv[1]*i+30; // shift down for header area

    // random color, that will look nice and be visible
    scopes[i] = new Oscilloscope(this, posv, dimv);   
    scopes[i].setLine_color(color((int)random(255), (int)random(127)+127, 255));
    controlP5.addButton("pause",1,dimv[0]+10,posv[1]+10,32,20).setId(i);
    controlP5.addButton("logic",1,dimv[0]+52,posv[1]+10,29,20).setId(i+50);
    controlP5.addButton("save",1,dimv[0]+92,posv[1]+10,29,20).setId(i+100);
    
   }


    controlP5.addButton("A0zoom",1,440,5,35,20).setId(200);   
 
    controlP5.addButton("diag",1,480,5,25,20).setId(201);   
    controlP5.addButton("slow",1,330,5,25,20).setId(202);   
    controlP5.addButton("fast",1,370,5,25,20).setId(203);   

//  println(Arduino.list());
//  arduino = new Arduino(this, Arduino.list()[4], 57600);   //  com13   57600 firmata

//  arduino.pinMode(11, Arduino.OUTPUT);  // PWM
//  arduino.analogWrite(11, mysetpulson);
//  arduino.pinMode(13, Arduino.OUTPUT);  // board LED operate by mouse
    println(Serial.list());                                             // kll
  port = new Serial(this, Serial.list()[1], 115200);                    // kll here (4) as com13  (1) as com3
  
  // clear and wait for linefeed
  port.clear();
  port.bufferUntil(LINE_FEED);

// check scope timing
loopcount = 0;  // reset
oldmillis=0;

}

void draw() {
  background(off);
  stroke(on);
  
  
  textFont(fontSmall);  
  fill(255);
  text("key operation: show channels  6,5,4,3,2,1/ + - z d",10,20);
  text(delaytime,360,20);
  text(samplerate + " Hz",400,20);
  
  text( str(day())+ "." + str(month()) + "." + str(year()) + " " + str(hour()) + ":" + str(minute()) + ":" + str(second())  , width-120, 20 ); 

   ldelta = (height-30)/(multiscope*5) ; //pixel / 1 volt
   // show 2 scope with Ain from ARDUINO
   for (int i=0;i<multiscope;i++){
     // update and draw scopes
   // vals[i] = arduino.analogRead(i); no firmata , see serial event for data income
    
    scopes[i].addData(vals[i]);  // arrayindex out of bounds exception 1
    scopes[i].draw();
    
    // conversion multiplier for voltage
    float multiplier = scopes[i].getMultiplier()/scopes[i].getResolution();
    
    // convert arduino vals to voltage
    float minval = scopes[i].getMinval() * multiplier;
    float maxval = scopes[i].getMaxval() * multiplier;
    int[] values = scopes[i].getValues(); 
    float pinval =  values[values.length-1] * multiplier;
    
    // add lines
    // scopes[i].drawBounds();
    // we show a 5 Volt signal, so need 4 line ( 1 V / dev )
    int[] pos = scopes[i].getPos();
    int[] dim = scopes[i].getDim();
    stroke(0);                          // black lines for 1 V dev
        line(0, pos[1]+ldelta, dim[0], pos[1]+ldelta);
        line(0, pos[1]+2*ldelta, dim[0], pos[1]+2*ldelta);
        line(0, pos[1]+3*ldelta, dim[0], pos[1]+3*ldelta);
        line(0, pos[1]+4*ldelta, dim[0], pos[1]+4*ldelta);
    stroke(255);                        // white line for scope (top)
        line(0, pos[1], width, pos[1]);
    
    // we show a 5 Volt signal, so need 4 line ( 1 V / dev )
    
    // add labels
    fill(255);
    textFont(fontLarge);
    text(pinval, width-60, pos[1] + dim[1] - 10);
    
    textFont(fontSmall);   
    text("min: " + minval, dim[0] + 10, pos[1] + 40);
    text("max: " + maxval, dim[0] + 10, pos[1] + 48);
    
    textFont(fontLarge);                           // kll to small can not read anything
    fill(scopes[i].getLine_color());
    text("A" + i, dim[0] + 10,pos[1] + dim[1] - 10);
  }
  
  // draw text seperator, based on first scope
  int[] dim = scopes[0].getDim();
  stroke(255);
  line(dim[0], 0, dim[0], height);
  
// end scope
 
 
if (showbatch) {  // zoom scope in new window with data from batch read ( 8.8kHz )
  s.background(off);
  s.stroke(on);
    
  s.textFont(fontSmall);  
  s.fill(255);
  s.text( str(day())+ "." + str(month()) + "." + str(year()) + " " + str(hour()) + ":" + str(minute()) + ":" + str(second())  , 392, 15 ); 
    for (int i=0;i<512;i++){
        Zscope[0].addData(zoomarrray[i]); 
                           } // end load data to scope
    Zscope[0].draw();        // only scope, no text area
    // conversion multiplier for voltage
    //float Zmultiplier = Zscope[0].getMultiplier()/Zscope[0].getResolution();
    
    // convert arduino vals to voltage
    //float minval = Zscope[0].getMinval() * Zmultiplier;
    //float maxval = Zscope[0].getMaxval() * Zmultiplier;
    //int[] Zvalues = Zscope[0].getValues(); 
    //float pinval =  Zvalues[Zvalues.length-1] * Zmultiplier;
    
    // add lines
    // Zscope[0].drawBounds();               // a black line 
    
    int[] Zpos = Zscope[0].getPos();
    //   println(Zpos);     0 , 20
    int[] Zdim = Zscope[0].getDim();
    // println(Zdim);      512 , 480
    s.stroke(0);                          // black 4 lines for 5 V
    for (int i=1;i<5;i++){
            s.line(0, Zpos[1]+i*(Zheight-30)/5, Zwidth, Zpos[1]+i*(Zheight-30)/5);
                         }                // end 4 lines
    s.stroke(255);                        // white
    s.line(0, Zpos[1], Zwidth, Zpos[1]);  // topline for scope area

    
    showbatch = false; // reset, window is only oneshot
                       // but in LOOP MODE so button... can work
} // end batch window


 
   // update buttons
  controlP5.draw();        
//  ZcontrolP5.draw();
 
} // end draw



public void controlEvent(ControlEvent theEvent) {   // handles button clicks
  int id = theEvent.controller().id();
    // println("got a control event from controller with id "+id);

  // button families are in chunks of 50 to avoid collisions

  if (id < 50){
    scopes[id].setPause(!scopes[id].isPause());
  }else if (id < 100){
    scopes[id-50].setLogicMode(!scopes[id-50].isLogicMode());
  }else if(id < 150){
    String fname = "data"+(id-100)+".csv";
    scopes[id-100].saveData(fname);   // ends up at mydocuments processing projectdir ???
    println("Saved as "+fname);
  }
   if (id==200){ // A0zoombutton  // do same as when key 'z'  
       port.write('z');  // send to arduino
       batchmode=true;
       PFrame f = new PFrame();     // for batch window

               } // end 200  A0zoombutton
      if (id==201){ // debug
                   debugd = !debugd;
                  }
      if (id==202){ // slow
                    port.write("+");
                    delaytime=delaytime + 2; // remember for local indication 
                  }
      if (id==203){ // fast
                    port.write("-"); 
                    delaytime=delaytime - 1; // remember for local indication
                   if ( delaytime < 0 ){ delaytime = 0;}   //limit 

                  }
 
}  // end control event (button)

// handle serial data
void serialEvent(Serial p) { 
  String data = p.readStringUntil(LINE_FEED);
  if (data != null) {
                         if ( debugd ) {  println(data); }
        if (!batchmode){ // data go scope window
        //    vals  = int(split(data, ','));
        int[] tempVals  = int(split(data, ','));
        if(tempVals.length>=scopes.length) {
          vals = tempVals;
          loopcount = loopcount +1;
                  if ( loopcount == loopend ) {
                            loopcount = 0;
                            actmillis=millis();
                            deltamillis=actmillis-oldmillis;
                            samplerate=int(float(loopend)*1000/deltamillis);
           if ( debugp ) { println("samplerate: " + samplerate + " Hz"); }
                            oldmillis = actmillis;
                            } // end loopend ( 1000 samples from serial interface )

              }  else { println("Warning: Dropped a short packet."); }
      
      
              } else {  // batch read
                        // batchmode == true
            if ( batchdata == true ) { // get 64 lines data from arduino and wait for "endbatch" text                                        
             String[] m2 = match(data, "endbatch");
                if (m2 != null) {   // found "endbatch"

                                   batchdata = false;
                                   batchmode = false; 
                                   zline=0;
                                   showbatch = true;
                                   if ( debugd ) { 
                                     println("endbatchdata: ");
                                   } 

                                       } // not found
                                        } // end look for "endbatch"

              if (batchdata) {
                    int[] tempVals  = int(split(data, ','));  // 64 * 8 values  = 512
                    
                    for (int i=0;i<8;i++){  zoomarrray[i+zline]=tempVals[i]; }
                    zline = zline + 8;   // 8 interger per line in 64 lines 
                                               if ( debugd ) { 
                                               print(zline);
                                               print(": ");
                                               println(data); 
                                                }       
                              } // end batchdata line / save to local array
              
            // batchmode == true
            if ( batchdata == false ) { // after "z" for about 200 lines wait / look for text "startbatch" from arduino
             String[] m1 = match(data, "startbatch");
               if (m1 != null) {   // found "startbatch"
                                   batchdata = true; 
                                   if ( debugd ) { 
                                   println("batchdata: "); // 
                                   } 
                                        }
                                          } // batchmode true and batchdata false

                     } // end batch read       

              }  // end if not 0 data
              
}  // end serial event

void keyPressed() {  // for send channel numbers to arduino  1 .. 6
  if (key >= '1' && key <= '6') {
     port.write(key);
     channels=int(key); 
                                } else {}
   // delaytime                             
  if ( key == '+' ){ 
                    port.write(key);
                    delaytime=delaytime + 2; // remember for local indication 
                  }
 
  if ( key == '-' ){ 
                    port.write(key); 
                    delaytime=delaytime - 1; // remember for local indication
                   if ( delaytime < 0 ){ delaytime = 0;}   //limit 
                   }
  if ( key == 'd' ){ // toggle diagnostic print of data
                     debugd = !debugd; }
  if ( key == 'z' ){ // goto zoom mode
       port.write(key);  // send to arduino
       batchmode=true;
       PFrame f = new PFrame();     // for batch window

                   } // end zoom mode
                     
}



public class PFrame extends Frame {
    public PFrame() {
	  setBounds(50,50,Zwidth+8, Zheight+36);  // problemm inner outer frame
	  s = new secondApplet();
	  add(s);
	  s.init();
	  show();
    }
}

public class secondApplet extends PApplet {
    public void setup() {
	  size(Zwidth, Zheight);
         // setup scope for zoom window
        int[] Zdimv = new int[2];
        Zdimv[0] = Zwidth;        
        Zdimv[1] = (Zheight-30);       // for scope area
  

          int[] Zposv = new int[2];
          Zposv[0]=0;
          Zposv[1]=30; // shift down for header area
   
         Zscope[0] =new Oscilloscope(this, Zposv, Zdimv); 
         ZcontrolP5 = new ControlP5(this);
         ZcontrolP5.addButton("savezoom",1,330,5,48,20).setId(300);  
         ZcontrolP5.addButton("FFT",1,290,5,35,20).setId(301);  
	 //noLoop();  // need, or get grey window
        fft = new FFT(512, zsamplerate);
    }

    public void draw() {
      ZcontrolP5.draw();
    }
    
    public void controlEvent(ControlEvent theEvent) {   // handles button clicks zoom window
    int id = theEvent.controller().id();
    // println("got a control event from controller with id "+id);
       if (id==300){ // zoom save
       //"d" + str(day()) + "m" + str(month()) + "y" + str(year()) + "h" + str(hour()) + "m" + str(minute()) + "s" + str(second())
       //    String fname = "data"+(id-100)+".csv";
         String zfname = "Zdata0_"+str(minute())+str(second())+".csv";
         Zscope[0].saveData(zfname);      // ends up at processing-1.2.1 dir ???
         println("Saved as "+zfname);      
                  }
       if (id==301){         // FFT
         println("FFT ");
                             // fft input is real, a sinus would be -1 to +1 / but our signal is 0 .. 1024 for 5 V
                             //  
         for (int i = 0; i < 512; i++) {  buffer[i] = (float(zoomarrray[i])*5/1024); }
         
                             // fft = new FFT(512, zsamplerate);  see in setup
         fft.forward(buffer);
                             // so if samplerate is ?8900? and we take 512 samples and we would see ONE SINUS
                             // in our zoom window it would have 17.5 Hz.
                             // and with a amplitude of + - 1 of the sinus
                             // after FFT we see theoratically in fft.getBand:     
                             //  [0] = 0    (real: 3)   offset
                             //  [1] = 256  (real: 240) amplitude for 1 ( ground) wave  
                             //  [2] = 0    (real: 10)      "     for 2nd wave
 
                             // show in debug window 
         for(int i = 0; i < 257; i++) { println("[" + i + "] " +int(i*zsamplerate/512)+" Hz "+ int(fft.getBand(i)) ); }
                             // show in window secondApplet
           noFill();
           stroke(255,0,255); // sorry, i like that color
           // draw the spectrum
             for(int i = 0; i < fft.specSize(); i++)  { 
                // window width is 512 so we can use 2 pix (vertical lines) for each frequency bar 
                         line(2*i, Zheight, 2*i, Zheight - 2*fft.getBand(i));
                         line(2*i+1, Zheight, 2*i+1, Zheight - 2*fft.getBand(i));
                                                     }  // end bargraph spectrum
                  } // end FFT
         }  // end control event (button)
} // end secondApplet


