/*
this goes on your arduino
for use with Processing example SimpleSerialArduinoscope by David Konsumer <david.konsumer@gmail.com>
processing application: mini_scope_kll_ascii
*/

// with running firmata here and analog..read from processing i see 22 Hz samplerate ( framerate)
// with david program here reading all inputs and send serial port
// i see 200Hz.
// now i try reduce here to n analog channel
// adjustable from processing, with  6 see 280hz, 1 see 1000hz with com problems
// operation from processing needs ser avail check what needs to much time
// with 6 channel analog read and ser avail every loop need 3 sec for 1000 loops!!!
// now we reduce ser check to 501 cycles

// so serial sync, adjustable delaytiming, adjustable channelcount ..
// all this is usefull but not a breakthrough
// now i try a zoom function, means go from continuous read write to
// read and store batch of data, then transmit it 'offline' to processing
// so we can run arduino at his best /and can use later inprovements ( 8bit..)
// without being blocked by serial link problems.
// looks like we can get 512 samples ( no memory problem )
// and speed? i see 9 high and 9 low readings of my 50% PWM signal
// so 18 samples of a 490Hz? signal is 8.8kHz?
// ok, documentation says max 10kHz for analog read

// now from keyboerd PROCESSING can send 
// 1 .. 6 for channels
// + - for delaytime adjust on overload
// z   for zoom / batch reading / transmit

  int channels=6;                                  // start with 6, processing command change
  int ainByte,inval,val;

  int loopcount =0;                              // cycles 
  int loopreport=1000;                          // reset and toogle LED 13
  int ledpin13=1;                                // toggle memory LED 13 

  int sercheck = 0, sercheckend = 201;          // every n loops check ser avail
  
  int delaytime = 6;                             // processing can change + / -
//  int delayadd = 2;                              // will add + - 2 msec delay

  long lastmsec=0;  
  int ledpin11=1;                                // toggle memory LED 11 to make 1sec pulses
     
  // batch ZOOM
  int Ain[512];
  int zoomarray=512;
  int zoomchannel=0;
  int delayusec=100;         // delay between analog read and send lines in batch mode
  int delayserialmsec=20;   // only used prior and after zoom data send
  int linec=0;
  int linelength=8;   // until LF gives 64 lines with 8 values = 512

 
void setup() {
// set 2-12 digital pins to read mode
//  for (int i=2;i<14;i++){
//    pinMode(i, INPUT);
//  }
    pinMode(10, OUTPUT);
    analogWrite(10, 26);                              // make a 10% PWM puls for test scope pin10  
    pinMode(11, OUTPUT);
    //analogWrite(11, 127);                              // make a 50% PWM puls for test scope pin11
    digitalWrite(11, HIGH);                           // set ON change each second
    ledpin11=1;                                       // memory
    pinMode(13, OUTPUT);
    ledpin13=1;
    digitalWrite(13, HIGH);                           // set LED ON  change each 1000 loops == 1000 data send
      
    Serial.begin(115200);  
}

void loop() {  
  if ( sercheck == sercheckend ) {                                 // timer for reduced ser check
    sercheck =0;                                                   // reset
  if (Serial.available() > 0) { 
    ainByte = Serial.read();
    inval = char_num(ainByte);
    if ( ( inval > 0 ) && ( inval < 7 ) ) {  channels = inval; }
    if ( inval == -4 ) { delaytime = delaytime + 2; }  // processing send +
    if ( inval == -5 ) { 
                         delaytime = delaytime - 1;
                         if ( delaytime < 0 ) {delaytime = 0;} }  // processing send -
    if ( inval == -6 ) {
      delay(delayserialmsec);  // wait for clear serial port
      onebatch();
      delay(delayserialmsec);  // to go back continuous mode
         } // end zoom mode
    

    }                                                             // end serial avail
  }                                                               // end sercheckend

                // read analog ports, send serial and split by ","
  //for (int i=0;i<channels;i++){
  for (int i=0;i<6;i++){
    if ( i < channels ) {
               Serial.print(analogRead(i));
    } else {
               Serial.print('0');      
    }
    Serial.print(",");
    
  }
  
// read all digital ports, split by ","
//  for (int i=2;i<14;i++){
//    Serial.print(digitalRead(i));
//    Serial.print(",");
//  }
  
                                                                                // frame is marked by LF
  Serial.println();
                 sercheck = sercheck + 1;                                       // delaytimer for ser avail check
                 
                 loopcount = loopcount + 1;                                     // for check cycle time
                 if ( loopcount == loopreport ) {                               // of 4 294 967 295 unsigned long
                                                  loopcount = 0;                // reset
                                                  if ( ledpin13 == 1 ) {        // toggle led to see 1 000 loops in scope (cable Ain to 13) and led
                                                    ledpin13=0;
                                                    digitalWrite(13, LOW);                                                     
                                                  } else {
                                                    ledpin13=1;
                                                    digitalWrite(13, HIGH); 
                                                  }
                                                } // end if loopcount
                 if ( (millis() - lastmsec) > 999 ) { // 1 sec over
                   lastmsec = millis();                  // memory
                                                  if ( ledpin11 == 1 ) {        // toggle Dout 11 to see 1 000  msec pulse in scope
                                                    ledpin11=0;
                                                    digitalWrite(11, LOW);                                                     
                                                  } else {
                                                    ledpin11=1;
                                                    digitalWrite(11, HIGH); 
                                                  }
                 
                                                      }
                 delay(delaytime);
  
} // end loop



int char_num(int inChar) {
  if (inChar == 48) { return 0; }
  if (inChar == 49) { return 1; }
  if (inChar == 50) { return 2; }
  if (inChar == 51) { return 3; }
  if (inChar == 52) { return 4; }
  if (inChar == 53) { return 5; }
  if (inChar == 54) { return 6; }
  if (inChar == 55) { return 7; }
  if (inChar == 56) { return 8; }
  if (inChar == 57) { return 9; }
  if (inChar == 10) { return -2; }                                    // LF
  if (inChar == 13) { return -2; }                                    // CR
  if (inChar == ',') { return -3; }  
  if (inChar == '+') { return -4; }
  if (inChar == '-') { return -5; }
  if (inChar == 'z') { return -6; }
  return -1;                                                          // must be bad input / no number / or bad communication 
}                                                                     // end function


void onebatch() {
                          // get data to array first as fast as possible
  for (int i=0;i<zoomarray;i++){ 
                 Ain[i] = analogRead(zoomchannel); 
                 //delayMicroseconds(delayusec);
                                } // end for   READ AIN to ARRAY
                 Serial.println("startbatch,");
  for  (int i=0;i<zoomarray;i++){
                   Serial.print(Ain[i]);
                   Serial.print(",");

                   linec = linec + 1;
                   if (linec == linelength ){          
                   linec = 0;                     // reset
                   Serial.println();              // frame is marked by LF
                   delayMicroseconds(delayusec);  // pause for host
                                  }               // line end
                                }   // end for   SEND to PROCESSING
                   Serial.println("endbatch,");  
                   

}                        // end onebatch
