/*_________________________________________________________________*/
/*  KLL-engineering                                                */
/*  MENU_KLL                                                       */
/*  V0.0 29.10.2010 start menu                                     */
/*  V0.1 01.11.2010 job structure                                  */
/*  V0.2 02.11.2010 conti run jobs reduced USB waste time          */
/*       runs now with 10s instead 26s for 1 000 000 loop cycles   */
/*       not use delay in main running loop!                       */
/*  V0.3 3.11.2010 semi parallel jobs                              */
/*  V0.4 5.11.2010 clean menu                                      */
/*  V0.5 14.11.2010 serial speed                                   */
/*                                                                 */
/*                                                                 */
/*_________________________________________________________________*/
char prev[5]="V0.5";
                                                   // wiring
                                                   // arduino board LED "L"
const int ledPin    = 13;
                                                   // ATmega386 PWM outputs: 3,5,6,9,10,11 

                                                   // ATmega386 Ain A0 .. A5
                                                  // variables
                                                  // serial communication
long ser0bd = 19200;                               // 300, 1200 good, 2400, 9600 good, 14400, 19200 good, 28800, 38400 good, 57600 setpoint not good, 115200 good
int inByte;
int serloop = 0, serloopend = 1001;               // only after serloopend cycles check for USB income
int delayusb = 100;                               // at 57600  setpointinput 2,3 digit dont work with 10 or 100

 unsigned long Ltime;                             // milliseconds   works for about 50 days
 unsigned long Ltime_old;                         // milliseconds memory last scan
 unsigned long Ltime_delta;                       // milliseconds delta from last scan

                                                  // L___ for calc actual values ( from millis )
                                                  // I___ for user set timer, I1__ for ON, I0__ for OFF,  
 int Ldays, I1days, I0days; 
 int Lhours, I1hours, I0hours;
 int Lminutes, I1minutes, I0minutes;
 int Lseconds, I1seconds, I0seconds;

                                                 // Menu operating system memory
  int menuselect = 58;                             //":"
  unsigned long loopcount =0;                      // cycles 
  unsigned long loopreport=1000000;                // reset and time diag
  //unsigned long execcount;                         // job cycles 

  int exec1count, exec2count, exec3count, exec4count, exec5count, exec6count, exec7count, exec8count, exec9count; // now per job, only INT
  int exectim = 1000;                              // default executer for 10sec for 1000000 loop it would be 10msec

  boolean exec1conti = false;
  boolean exec2conti = false;
  boolean exec3conti = false;
  boolean exec4conti = false;
  boolean exec5conti = false;
  boolean exec6conti = false;
  boolean exec7conti = false;
  boolean exec8conti = false;
  boolean exec9conti = false;

  boolean debugp = false;                          // variables dump to screen for diag
  boolean debuga = false;                          // from get_set_value int function only

                                                 // setup
void setup() {                
                                                 // initialize the digital pin as an output.
                                                 // Pin 13 has an LED connected on most Arduino boards:
                                                 // delay 1000 is 1 sec
  pinMode(ledPin, OUTPUT);
  digitalWrite(ledPin, HIGH);                    // set the LED on
 
  Serial.begin(ser0bd);
  Serial.println("kll-engineering on ARDUINO");
  Serial.println("hit BLANK ENTER");
  
}

                                                       // my_functions
void get_time() {
                    Ltime = millis();                  // read actual millis  
                    Ltime_delta = Ltime - Ltime_old;   // remember delta time between 2 readings
                    Ltime_old = Ltime;                 // remember this time for next delta calc
}                                                      // end get_time

void calc_time() {
                    Lseconds = Ltime / 1000;
                    Lminutes = Lseconds / 60;
                    Lhours = Lminutes / 60;
                    Ldays = Lhours / 24;
                    
                    Lseconds = Lseconds - Lminutes * 60;
                    Lminutes = Lminutes - Lhours * 60;
                    Lhours = Lhours - Ldays * 24;
}                                                       // end calc_time

void print_time() {


                    get_time();
                    calc_time();                    
                                                       //prints time since program / board started
                    //Serial.print("millis: ");
                    //Serial.println(Ltime);
                    Serial.print("days: ");
                    Serial.print(Ldays);
                    Serial.print(" time: ");
                    Serial.print(Lhours);
                    Serial.print(" : ");
                    Serial.print(Lminutes);
                    Serial.print(" : ");
                    Serial.println(Lseconds);

}                                                      // end print_time

void print_menu() {
                  // print menu
                  // use terminal 
                  // - COM3
                  // - autoscroll ON
                  // - Carriage return ( menu comes at ENTER )
                  // - xxxx baud
                  
                   Serial.println("\nkll-engineering on ARDUINO      "); 
                   Serial.print("   menu ");
                   Serial.println(prev);
                   Serial.println("0 reset conti jobs and output     ");
                   Serial.println("1 test setpoint input ");
                   Serial.println("2  ");
                   Serial.println("3  ");
                   Serial.println("4  ");
                   Serial.println("5  ");
                   Serial.println("6  ");
                   Serial.println("7  ");
                   Serial.println("8                                 ");
                   Serial.println("9                                 ");
                   Serial.println("                                  ");
                   Serial.println("a show ASCII list                 ");
                   Serial.println("d toggle diagnostic info          ");
                   Serial.println("t time                            ");
                   Serial.println("s show variables                  ");                   
                   Serial.print("select: ");
   
}                                                                     // end print_menu


int char_num(int inChar) {
  if (inChar == 48) { return 0; }
  if (inChar == 49) { return 1; }
  if (inChar == 50) { return 2; }
  if (inChar == 51) { return 3; }
  if (inChar == 52) { return 4; }
  if (inChar == 53) { return 5; }
  if (inChar == 54) { return 6; }
  if (inChar == 55) { return 7; }
  if (inChar == 56) { return 8; }
  if (inChar == 57) { return 9; }
  if (inChar == 10) { return -2; }                                    // LF
  if (inChar == 13) { return -2; }                                    // CR
  
  return -1;                                                          // must be bad input / no number / or bad communication 
}                                                                     // end function




int get_set_value (String question, int defaultval=0, int timeout=0) {  
                                                                     // open points: speedtests, timeout 

  int ainByte;
  int Bytecount = 0;	                                             // for incoming serial data
  int innum=0;                                                       // or long,  int limit is 32,767
  int inval = 0;
  boolean valok = false;                                             // wait for bytes from USB
   
                                                                     // send the question to USB and wait for answer of a set value 
                                                                     // convert to integer
  Serial.print(question);
                                                                    // wait answer
     do {
  	if (Serial.available() > 0) {                               // USB terminal interrupt
          delay(delayusb);                                          //get all the string to buffer
          Bytecount = Serial.available();                           // ask how many bytes, max 128
                                         if (debuga) {
                                            Serial.print (" Bytes: ");
                                            Serial.println(Bytecount);    // diag echo
                                         }                                // end if debug  
          for ( int i=0; i < Bytecount; i++){
            
          ainByte = Serial.read();
          inval = char_num(ainByte);
          if (inval != -1) 
           { 
             if ( inval == -2)                                             // CR LF 
             {
                                                                           // ignore it
             }
             else
             {
                                                                           // we want limit to int so prevent overflow
             if ( ( innum > 3276 ) ||  ( innum == 3276 && inval > 7 )  )   // next byte too much 
             {
               innum = 32767;                                              // discard input
               i = Bytecount;                                              // stop for loop
               Serial.print (" to big, defaulted to: ");               
             }
             else
             {
               innum = innum*10 + inval;                                   // calc number
             }
             } 
           }
           else                                                            // -1 from char_num function
           { 
             innum = defaultval;                                           // discard input
             i = Bytecount;                                                // stop for loop
             Serial.print (" no number, defaulted to: "); 
           }
          
                                         if (debuga) {
                                           Serial.print ( ainByte);       // byte
                                           Serial.print (" ");
                                            Serial.print(inval);          // diag echo value
                                           Serial.print (" number ");
                                            Serial.println(innum);        // diag echo value
                                         }                                // end if debug  
          }                                                               // end for
           valok = true; 
         }
         else
         { 
                                                                         //delay (delayusb); //and try again
           valok = false;
          }
     } while(valok == false);                                            // wait for answer
     Serial.println(innum);                                              // echo in answer line
     return innum;
}                                                                        // end get_set_value

void print_ascii() {
  
                  Serial.println("ASCII Table BIN, BYTE, DEC, HEX");
                  for ( int i=0; i < 128; i++){
                  Serial.print (i, BIN);
                  Serial.print (" , ");
                  Serial.print (i, BYTE);
                  Serial.print (" , ");
                  Serial.print (i, DEC);
                  Serial.print (" , ");
                  Serial.println (i, HEX);
                  }
}// print_ascii


// run
void loop() {

      if (serloop == serloopend) 
      {
        serloop = 0; //reset and check ( after serloopend cycles ) if usb has income 
       // by sending one byte from PC Terminal select job from menu
	if (Serial.available() > 0) {        // USB terminal interrupt 
		// read the incoming byte:
            inByte = Serial.read();
                            delay(delayusb);      // wait rest of the string is in buffer 
                            Serial.flush(); // only use first character, skip the rest 
          
            switch (inByte) {

              case 'a': //a   menu entry 
                  menuselect = inByte;

                  Serial.println(inByte, BYTE);
                  print_ascii(); // show ascii list

                  break;

              case 'd': //d   menu entry 
                  menuselect = inByte;

                  Serial.println(inByte, BYTE);
                  debugp = !debugp;                          //toggle debug
                  debuga = !debuga;                          //toggle debug
                  if (debugp) {Serial.println(" Diagnostic print enabled ");}
                  break;

              case 't': //t
                  menuselect = inByte;

                  Serial.println(inByte, BYTE);
                  print_time();
                                         if (debugp) {
                                           Serial.print("loopcount: ");
                                           Serial.print(loopcount);
                                           Serial.print(" reset after: ");
                                           Serial.println(loopreport);
                                              } // if debug
              break;

              case 's': //s show variables status
                  menuselect = inByte;

                  Serial.println(inByte, BYTE);
                  Serial.println("actual settings: ");
                  print_time();
                  Serial.print("loopcount: ");
                  Serial.print(loopcount);
                  Serial.print(" reset after: ");
                  Serial.println(loopreport);
                  
                  Serial.print(" 1 ");
                  if (exec1conti) {Serial.print("ON ");}else{Serial.print("OFF ");}
                  Serial.print(exec1count);                  
                  Serial.print(" 2 ");
                  if (exec2conti) {Serial.print("ON ");}else{Serial.print("OFF ");}
                  Serial.print(exec2count);                  
                  Serial.print(" 3 ");
                  if (exec3conti) {Serial.print("ON ");}else{Serial.print("OFF ");}
                  Serial.print(exec3count);                  
                  Serial.print(" 4 ");
                  if (exec4conti) {Serial.print("ON ");}else{Serial.print("OFF ");}
                  Serial.print(exec4count);                  
                  Serial.print(" 5 ");
                  if (exec5conti) {Serial.print("ON ");}else{Serial.print("OFF ");}
                  Serial.print(exec5count);                  
                  Serial.print(" 6 ");
                  if (exec6conti) {Serial.print("ON ");}else{Serial.print("OFF ");}
                  Serial.print(exec6count);                  
                  Serial.print(" 7 ");
                  if (exec7conti) {Serial.print("ON ");}else{Serial.print("OFF ");}
                  Serial.print(exec7count);                  
                  Serial.print(" 8 ");
                  if (exec8conti) {Serial.print("ON ");}else{Serial.print("OFF ");}
                  Serial.print(exec8count);                  
                  Serial.print(" 9 ");
                  if (exec9conti) {Serial.print("ON ");}else{Serial.print("OFF ");}
                  Serial.println(exec9count);
                  Serial.print("exectim: ");
                  Serial.println(exectim);

                  Serial.print("serlim: ");
                  Serial.print(serloopend);
                  Serial.print(" serloop: ");
                  Serial.println(serloop);

                  //Serial.print("last select: ");   // well thats "s"
                  //Serial.println(menuselect, BYTE);                  

              break;

              case '0': //0   reset
                  menuselect = inByte;

                  Serial.println(inByte, BYTE);
                    exec1conti = false;
                    exec2conti = false;
                    exec3conti = false;
                    exec4conti = false;
                    exec5conti = false;
                    exec6conti = false;
                    exec7conti = false;
                    exec8conti = false;
                    exec9conti = false;
                    
                    debugp = false; 
                    debuga = false; 
                    loopcount = 0;
                    exec1count = 0;
                    exec2count = 0;
                    exec3count = 0;
                    exec4count = 0;
                    exec5count = 0;
                    exec6count = 0;
                    exec7count = 0;
                    exec8count = 0;
                    exec9count = 0;
                    menuselect = 58; //":"
                                                            // reset outputs  

                  break;

              case '1': //1
                  menuselect = inByte;
                  exec1count = 0; //reset
                  exec1conti = true;

                  Serial.println(inByte, BYTE);
     get_set_value ("test setpoint input number default 100: ",100,0);
              break;

              case '2': //2
                  menuselect = inByte;
                  exec2count = 0; //reset
                  exec2conti = true;

                  Serial.println(inByte, BYTE);

                  break;

              case '3': //3
                  menuselect = inByte;
                  exec3count = 0; //reset
                  exec3conti = true;

                  Serial.println(inByte, BYTE);

                  break;

              case '4': //4
                  menuselect = inByte;
                  exec4count = 0; //reset
                  exec4conti = true;

                  Serial.println(inByte, BYTE);

              break;

              case '5': //5
                  menuselect = inByte;
                  exec5count = 0; //reset
                  exec5conti = true;

                  Serial.println(inByte, BYTE);
                                                
              break;

              case '6': //6 
                  //conti volt recorder from POTI and PWM output to LED
                  menuselect = inByte;
                  exec6count = 0; //reset
                  exec6conti = true;

                  Serial.println(inByte, BYTE);
                  
              break;

              case '7': //7
                  menuselect = inByte;
                  exec7count = 0;                                                   //reset
                  exec7conti = true;

                  Serial.println(inByte, BYTE);
 

              break;

              case '8': //8
                  menuselect = inByte;
                  exec8count = 0; //reset
                  exec8conti = true;

                  Serial.println(inByte, BYTE);

              break;

              case '9': //9
                  menuselect = inByte;
                  exec9count = 0; //reset
                  exec9conti = true;

                  Serial.println(inByte, BYTE);

              break;

              default:
                  menuselect = 58; //":" so any character from USB stops running menutask selected prior
                  print_menu();
                  
                          } // end switch keyboard entry
                
                        } // end serial available USB Terminal Interrupt
                     
                     } // serloop = serloopend




            // main RUN of CONTI JOBS ( semi parallel )
 
              if ( exec1conti )                                          // JOB1
              {
                 if (exec1count == 0)
                 { // 1

                 }                 
                 exec1count = exec1count +1;
                 if (exec1count == exectim) { exec1count = 0; }
              }                                                                 // end if conti true

              if ( exec2conti )                                          // JOB2
              {
                 if (exec2count == 0)
                 { // 2

                 }                 
                 exec2count = exec2count +1;
                 if (exec2count == exectim) { exec2count = 0; }                 // job timer
              }                                                                 // end if conti true

              if ( exec3conti )                                          // JOB3
              {
                 if (exec3count == 0)
                 { // 3
                   
                 }                 
                 exec3count = exec3count +1;
                 if (exec3count == exectim) { exec3count = 0; }                 // job timer
              }                                                                 // end if conti true

              if ( exec4conti )                                          // JOB4
              {
                 if (exec4count == 0)
                 { // 4
                 
                 }                 
                 exec4count = exec4count +1;
                 if (exec4count == exectim) { exec4count = 0; }                 // job timer
              }                                                                 // end if conti true

              if ( exec5conti )                                          // JOB5
              {
                 if (exec5count == 0)
                 { //5
                 
                 }                 
                 exec5count = exec5count +1;
                 if (exec5count == exectim) { exec5count = 0; }                 // job timer
              }                                                                 // end if conti true

              if ( exec6conti )                                          // JOB6
              {
                 if (exec6count == 0)
                 { // 6
                 
                 }                 
                 exec6count = exec6count +1;
                 if (exec6count == exectim) { exec6count = 0; }                 // job timer
              }                                                                 // end if conti true

              if ( exec7conti )                                          // JOB7
              {
                 if (exec7count == 0)
                 { // 7

                 }
                 exec7count = exec7count +1;
                 if (exec7count == exectim) { exec7count = 0; }                 // job timer

                 }                                                                 // end if conti true


              if ( exec8conti )                                          // JOB8
              {
                 if (exec8count == 0)
                 { //8
                 
                 }                 
                 exec8count = exec8count +1;
                 if (exec8count == exectim) { exec8count = 0; }                 // job timer
              }                                                                 // end if conti true

              if ( exec9conti )                                          // JOB9
              {
                 if (exec9count == 0)
                 { // 9
                 
                 }                 
                 exec9count = exec9count +1;
                 if (exec9count == exectim) { exec9count = 0; }                 // job timer
              }                                                                 // end if conti true
                  
                  
                  loopcount = loopcount + 1;                                     // for check cycle time
                  serloop = serloop + 1;                                         // for check on USB 

                  if ( loopcount == loopreport ) {                               // of 4 294 967 295 unsigned long
                                                  loopcount = 0;                 // reset
                                                  if (debugp) { print_time(); }  // if debug
                                                } // end if loopcount
                                       
     } // end loop
