// local functions:
//__________________________________________________________________________________________________


  int serial_wait(boolean debug, unsigned long newtimeout ) {                                                         // KLL other routine for wait on serial response line

   unsigned long l_start = millis();
   
    inputstring="";                                                            // clean global
    inputstring_complete = false;
    
    while (!inputstring_complete) {

      while (Serial.available()) {
      char inChar = (char)Serial.read();
      if (debug) { Serial.print(" S0: ,");  Serial.print(inChar); Serial.print(" , ");Serial.println(inChar, HEX); }    // global diagnostic setting
      if ((inChar == '\n') || (inChar == '\r')){                               // if EOL;  check serial monitor setting NOT "No line ending" 
          inputstring_complete = true;
          break;  
                                                } 
      else {  inputstring += inChar;            }                              // do not save <NL> <CR> to string
               }  // end while

    if  ( ( millis() - l_start ) > newtimeout ) {
          //          inputstring += "_timeout";                               // show string and indicate EOL timeout; check serial monitor setting NOT "No line ending" 
          if (debug) { Serial.print("_timeout_"); }
          inputstring_complete = true;
          return -1;          
             }
    } // end while not EOL 
    return inputstring.length();
  } // end myserialwait
  
//_____________________________________________________________________________
  
  void get_real(String instring,  boolean debug = false , float indefault = 0.0 ) {
  // got this mostly from library stream parseInt, parseFloat
    boolean isNoNumber = false;
    boolean isNegative = false;
    boolean isFraction = false;
    long value = 0;
    int string_long = instring.length();
    char c;
    float fraction = 1.0;
    // reset global numbers
    innum=0;
    innum_R=0.0;
    // check the string:  
    for ( int i = 0; i < string_long; i++ ) {
        c = instring[i];
       if( (c >= '0' && c <= '9')  || c == '.' || c == ',' || c == '-' ) {        // 

         if(c == '-')  isNegative = true;
         else if ((c == '.') || (c == ','))   isFraction = true;
         else if ((c >= '0') && (c <= '9'))  {      // is c a digit
           value = value * 10 + c - '0';
           if(isFraction)
           fraction *= 0.1;
              }  // else calc number
  
         }  // end if c is number or , or . or - 
         else { // thats bad input
    
                    isNoNumber = true;       
                  }
        if (debug) { Serial.print(i); Serial.print(" of ");Serial.print(instring.length()); Serial.print(" c "); Serial.print(c,HEX); Serial.print(" val "); Serial.print(value); Serial.println(); }

        } // end for all chars in string 

  if (!isNoNumber) {
     if(isNegative)  value = -value;
     if(isFraction)  { 
                        innum_R = value * fraction; 
                        innum = long(innum_R); 
                      } else {   
                        innum = value; innum_R = value; 
                      }  // end real number
                      
                    } else {                                    // bad char input , use default numbers
                       Serial.print(" no number input, use default! "); 
                       innum = long(indefault);
                       innum_R = indefault; 
                           } 
  } // end get_real    
  
//_____________________________________________________________________________
  
  // question ="? ", showit = true, debug = false, timeout=10000  (10sec), no processing for numbers, default number              
  void askquestion(String outstring = "", boolean showit = true, boolean debug = false, unsigned long newtimeout = 10000, boolean proc_float = false , float indefault = 0.0 ) {                  //use false to do more with the "inputstring" content, use true to show it
  int getserfunc = 0;
  
      //Serial.flush();
      if (outstring != "" ) { Serial.print(outstring); }
      getserfunc = serial_wait(debug, newtimeout );
      if (showit) { Serial.print(inputstring); }
      if (proc_float) { 
                        if ( getserfunc >= 1 ) {                                // no timeout, not only <CR>
                            get_real(inputstring, debug, indefault); 
                          }  else   {                                           // use default
                            innum = long(indefault);
                            innum_R = indefault; 
                        } 
                        //if (debug) { Serial.print(" int: "); Serial.print(innum); Serial.print(" real: "); Serial.print(innum_R); }
                      }
      if ( (outstring != "" ) || (showit) ) { Serial.println(); }
  } // ask question




