#!usr/bin/python
# arduinostream.py
# service to write the arduino measuring data from USB input
# to a file, webserver can show by PHP
# and write to a google spreadsheet what needs a url code script
# KLL engineering 20.7.2014 
# http://www.kll.engineering-news.org/kllfusion01/articles.php?article_id=70

# this program creates a timestamp ( by RPI ) because the arduino can not
# and includes it at the beginning of the record

# test with arduino leonardo sending 5sec records with a sinus for PV
# but here is the "RECORDING" timer at 30 sec

import serial
import time
#import subprocess
#import os
import urllib
import glob

# _________________________________________________________________
def scan():
    """scan for available ports. return a list of device names."""
    return glob.glob('/dev/ttyS*') + glob.glob('/dev/ttyUSB*') + glob.glob('/dev/ttyACM*')

# _________________________________________________________________
def read_save():
    writerecord = 1    # enable oneline data in ramdisk
    writecsvdb = 0     # disable write to csv database in www dir what not exist until webserver installed
    writegoogle = 1    # enable google spreadsheet full by URL makro

    sfiledata="/run/shm/arduinodata.csv"                  # one actual record
    syear  = time.strftime("%Y")
    smonth = time.strftime("%m")
    sday   = time.strftime("%d")
    if writecsvdb:
        sfiledb="/var/www/arduinodb" + syear + smonth + sday + ".csv"     # of max 1440 minute values

    foldtime = time.time()
    fnewtime = time.time()
    fstore = 30.0                                         # sec
#   sudo curl -k "https://script.google.com/macros/s/AKfycbwufk73ybR9sWEerGl7tFbV-X_AoPxHF-w3XhbkUfpv4EG_4AwL/exec?TIMESTAMP=$(date +%F@%T)&TEMP_PV=2.0&TEMP_SP=3.0&OUTPUT=50"

    googlepage = "https://script.google.com/macros/s/"
    mygooglekey = "A..L"
    
    while ser.isOpen() :
          measureline = ser.readline()
          stime=time.strftime(",%Y,%m,%d,%H,%M,%S,")  # for CSV file / cells
          wtime=time.strftime("%m/%d/%Y %H:%M:%S")    # for google spreadsheet cell
                                                      # get timing for store data to file
          fnewtime = time.time()
          fdtime = fnewtime-foldtime

          sdatline = stime + measureline
          # print sdatline + " dt: " + str(fdtime)      # diagnostic
          
          if fdtime >= fstore:                         # only store every "fstore" seconds
                foldtime = fnewtime
                if writerecord:
                    fdat = open(sfiledata,"w")             # open w file for write only one line
                    fdat.write(sdatline)
                    fdat.close()                           # close the file
                if writecsvdb:
                    fdatb = open(sfiledb,"a")              # open a file for append
                    fdatb.write(sdatline)
                    fdatb.close()                          # close the file
                if writegoogle:
                    VAL=measureline.split(",")
                    TPV = VAL[1]
                    TSP = VAL[2]
                    TOUT= VAL[3]
                    content = urllib.urlopen("%s%s/exec?TIMESTAMP=%s&TEMP_PV=%s&TEMP_SP=%s&OUTPUT=%s" %(googlepage, mygooglekey, wtime, TPV, TSP, TOUT)).read()
                    # print content
                # print sdatline                         # temporary show


if __name__=='__main__':
    print "Found ports:"
    for name in scan():
        print name
        time.sleep(1)       # give time to free ports
        
    sport = "/dev/ttyACM0"
    for inum in range(1,7):                             # try 3 times
        if inum == 4:
            sport = "/dev/ttyUSB0"                      # try 3 times
        # print str(inum) + " we test " + sport
        ser = serial.Serial(sport, 115200, timeout=60)  # arduino is reset!
        # try to open
        try:
            ser.open()
            # print " looks good"
            read_save()            
            ser.close()

#       except serial.SerialException:
        except Exception as ex:
             print "Failed to connect to port on: ", ser
             raise ex
#            print " serial problem "
        ser.close()
        pass
        
        time.sleep(1)       # give time

    
    print "end"
