/*____________________________________________________________________________*/
/*  KLL-engineering                                                           */
/*____________________________________________________________________________*/

/*  TMPB2 V0.1 1.12.2010                                                      */
/*  use copy from: dmx_kll_localPB                                            */
/*  but delete terminal menu, remote DMX, DMX output,                         */
/*                                                                            */
/*  the serial link can be used only for diagnostic outprint if enabled       */
/*                                                                            */
/*  just 2 TMPB and 2 RGB PWM out for stand alone house installation          */

/*  V0.2  use a SINUS setpoint as ramp                                        */
/*        incl color dimmer                                                   */

/*  V0.3 incl color wheel  and Saturation   ( full HSI operation )            */
/*       selectable HSI or RGB operation type                                 */

/*  V0.4 for my mini arduino with downloaded 2009 bootloader cpu              */
/*       developed a AVR ATMEGA328 minimal board as function controller       */
/*       for upload a 2009 board NO CPU can be used as FTDI,  4 (5) wires     */

/*       for power I/O use logic level n MOSFET                               */

/*  V0.5 design change to use one push button per PWM and run                 */
/*       instead of 1 RGB ( channel A ) 3 PWM dimmer                          */
/*  HOLD move that job to a different software project  (6 DIMMER )           */
/*       now go on here ( and first use the 3 PB for each RGB parallel        */
/*       later we can give them different functions like light sensor....)    */

/*       first some more FIXES                                                */
/*       in power off longtip ( go dimmer... ) works, but then OFF ON memory  */
/*       confused. FIXED                                                      */
/**/
/*       also now can use dimmer without first go two tip for select          */
/*       so if someone only know about                                        */
/*       -- short tip   ON OFF                                                */
/*       -- long tip    DIMMER                                                */
/*       its also ok,                                                         */
/*       but if you use one time the two tip you need to use it 2 times more  */
/*       and because the dimmer is default, the                               */
/*       -- first TWO TIP selects RGB show                                    */
/*       -- second TWO TIP saturation show                                    */
/*       -- third TWO TIP  again DIMMER ( of that color )                     */

/*   V0.6                                                                     */
/*       every cheap christmas tree LED light has stored programs             */
/*       my setpointprogram is close to that, the question is how to include  */
/*       it in the operation concept?                                         */
/*       now use 3 TWO TIP for cycle programming modes                        */
/*       must make one more / alternative would be to introduce a TREE TIP    */
/*       its also confusing and need lots of new timervariables               */
/*       -- 4 TWO TIP  programmed samples                                     */
/*                     indicated by some green green white red blue blinking  */
/*       prog 1   blink 4 sec preset colors random                            */
/*       prog 2   RGB sinus ( like color wheel setpoint)                      */
/*       prog 3   RGB sinus soft ( clamped RGB of above RGB sinus)            */

/*  V0.7                                                                      */
/*       bug, if progshow run, a TWO TIP selects new prog mode,               */
/*       but the related show is not visible because progshow still run       */
/*       set progshow to OFF for that time                                    */
/*       and this show ( what mode you are in ) is not clear                  */
/*       better a BLACK before and after                                      */
/*                                                                            */
/*       have many ideas to improve / extend that program                     */
/*       -- glitch report ( dignostic )                                    *  */
/*       -- Ain 1 connect light sensor control a high limit                   */
/*          so will automatically dimm down on sunlight                       */
/*       -- ideas for PB A1, A2, B1, B2:                                      */
/*       --- A1 central ON OFF must be potential free switch closing for ON   */
/*       --- A2 central ALARM contact OPEN for ALARM                          */
/*          ALARM program ( not selectable by operator) white,  red           */
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*                                                                            */
/*                                                                            */
/* here are 2 links to find more info                                         */
/*                                                                            */
/*  http://www.editgrid.com/user/kll/uDUINO_docu                              */
/*  http://kll.byethost7.com/kll_en7/news.php?readmore=15                     */
/*                                                                            */

/*____________________________________________________________________________*/
/* functional description     for TMPB push button operation                  */
/*                                                                            */
/*        tip POWER OFF  tip POWER ON                                         */
/*                                                                            */
/*        after a double tip get a sequence of programming options,           */
/*        to show what would be operated (by using the long tip )             */
/*        there will be shown for 3 sec some light effect to indicate it      */
/*        tip tip 1  color dimmer           show FULL WHITE                   */
/*        tip tip 2  color wheel            show RGB each 1 sec               */
/*        tip tip 3  color saturation       show warm yellow                  */
/* optional                                                                   */
/*        tip tip 4  red   adjust           show FULL RED                     */
/*        tip tip 5  green adjust           show FULL GREEN                   */
/*        tip tip 6  blue  adjust           show FULL BLUE                    */
/*                                                                            */
/*        long tip   the above selected function / color is adjusted          */
/*                   until long tip end     show sinus ramp mixed color       */
/*        a long tip job start after a long tip is detected, this can be only */
/*        after pressing longer as a timeout ( about 2 sec)                   */
/*____________________________________________________________________________*/
/* structural description                                                     */
/*        job 1     push button check (A)                                     */
/*        job 2     show ramps... (A)                                         */
/*        job 3     push button check (B)                                     */
/*        job 4     show ramps... (B)                                         */
/*        job 5     sinus ramp calc                                           */
/*        job 6     prog 1 ..n (A)                                            */
/*        job 7     prog 1 ..n (B)                                            */
/*____________________________________________________________________________*/


// hardware
//              __________________________       ________________________ 
//              |    ATMEGA 328 P -PU    |       |                      |        [] = 16MHz crystal HC49S-16M-LF
//              |                        |       |                      |        || = 2 * 22pF C T220JSLM042LF
//              | ARDUINO bootloader2009 |       |                      |        K = IRL530PBF N MOSFET
//  FTDI header |                        |       |                      |        T = KIA378R05 ( 5 VDC ) with 100uF
//          RX  o D0      (2)            |       |  _reset PB----GND    |        |<| = diodes to separate 2 external LED powersupply
//          TX  o D1      (3)            |       | |                    |        Ø = 2 * 12  screw terminals
//       reset  o PCINT14 (1)------------=-------o-+-[10kΩ]----V+       |        1 * 10kΩ pin1 reset pullup to V+
//              |                        |       |   +--[330Ω]-LEDy-GND |
//              |                        |       |   +V+-----T--12 Vin  |        1 * pin19 330Ω yellow LED to GND 
//         GND  o         (8)GND         =-------o-GND      GND         |        1 * V+ 330R green LED to GND
//              |         (22)GND        =-------o-GND                  |
// (5V otional) o         (7)5V          =-------o-V+                   |
//              |         (20)5V         =-------o-V+                   |
//              |                        |       |        GNDo----------Ø  GND  (_A_PS)              
//              |                        |       |        Vin-------|<|-Ø  12V  (_A_PS)
//              |                        |       |                    |-Ø  12V  (_A)   12V LED STRIP A
//              |         (5)    Dout  3 =-------o-----[100R]-----K-----Ø  R    (_A)
//              |         (4)    D in  2 =-------o----------------------Ø  TMPB+(_A)   push button A1
//              |                        |       |        GNDo----------Ø  TMPB-(_A)              
//              |         (11)   Dout  5 =-------o-----[100R]-----K-----Ø  G    (_A)
//              |         (6)    D in  4 =-------o----------------------Ø  TMPB+(_A)   push button A2
//              |                        |       |        GNDo----------Ø  TMPB-(_A)             
//              |         (12)   Dout  6 =-------o-----[100R]-----K-----Ø  B    (_A)
//              |         (13)   D in  7 =-------o----------------------Ø  TMPB+(_A)   push button A3 RGB
//              |                        |       |        GNDo----------Ø  TMPB-(_A)
//              |                        |       |                      |
//              |                        |       |        GNDo----------Ø  GND  (_B_PS)              
//              |                        |       |        Vin-------|<|-Ø  12V  (_B_PS)
//              |                        |       |                    |-Ø  12V  (_B)   12V LED STRIP B
//              |         (15)   Dout  9 =-------o-----[100R]-----K-----Ø  R    (_B)
//              |         (14)   D in  8 =-------o----------------------Ø  TMPB+(_B)   push button B1
//              |                        |       |        GNDo----------Ø  TMPB-(_B)              
//              |         (16)   Dout 10 =-------o-----[100R]-----K-----Ø  G    (_B)
//              |         (23)   A in  0 =-------o----------------------Ø  TMPB+(_B)   push button B2
//              |                        |       |        GNDo----------Ø  TMPB-(_B)              
//              |         (17)   Dout 11 =-------o-----[100R]-----K-----Ø  B    (_B)
//              |         (18)   D in 12 =-------o-----o----------------Ø  TMPB+(_B)   push button B3 RGB
//              |                        |       |        GNDo----------Ø  TMPB-(_B)              
//              |                        |       |                      |
//              |         (19)   Dout 13 =-------o-----[330R]-LEDy-GND  |
//              |                        |       |                      |
//              |         (9)    XTAL1   =-------o--+-||-GND            |
//              |                        |       | []    16MHz          |
//              |         (10)   XTAL2   =-------o--+-||-GND            |
//              |                        |       |                      |
//              |________________________|       |______________________|



// HSI, for Hue, Saturation, and Intensity
// dimmer ( from actual color mixture down to black )  ( V 0 .. 100% )
// color wheel ( select a color mixture ) 
//       with the 6 HUE ranges 0 .. 60 ...360 °
//
// R********                                    *********
// R           *                           *
//_R________________******************___________________
//
// G                          *****************
// G                     *                         *
// G****************____________________________________*
//
// B       ******************
// B    *                        *
// B*_________________________________******************
//|0       |60      |120     |180     |240     |300     |360
//_______________________________________________________
//|R  255  |  ramp- |     0  |     0  |  ramp+ |   255  |
//|G    0  |     0  |  ramp+ |   255  |   255  |  ramp- |
//|B ramp+ |   255  |   255  |  ramp- |     0  |     0  |
//_______________________________________________________
// but here i use the sinus ramp, not the linear ramp
// need 6 ramps in that seq. so use 3 sinus 
// that color wheel loop is 3 time longer as the dimmer / saturation loop
// what only use one sinus

// and color Saturation                                          ( S 0 .. 100% ) 
// if you have red color ( 255,0,0 )  ( or any mixture of above color wheel calculated colors )
// the Saturation is 100%
// A dimmer ( Intensity ) reduction means to go down ( reduce all 3 colors )  to BLACK 
// reducing the Saturation instead means ramp UP 2 lower colors up to the highest color
// until all 3 are same, u get white ( but depending on Intensity white grey or black )

// more info
// http://en.wikipedia.org/wiki/HSL_and_HSV
// http://www.colorspire.com/rgb-color-wheel/

// in the R G B model use just 3 slider for each 3 colors from 0 .. 255 (black to full color R or G or B)
// both model give same color space
// anyhow need 3 slider (modes)


