/*____________________________________________________________________________*/
/*  KLL-engineering                                                           */
/*____________________________________________________________________________*/

char prev[5]="V0.7";
                                                   // wiring

                                                  
const int ledPin    = 13;                          // arduino board LED "L"
                                                   // ATmega386 PWM outputs: 3,5,6,9,10,11 
                                                   // serial communication
long ser0bd = 115200;                              // 300, 1200, 2400, 9600, 14400, 19200, 28800, 38400, 57600, 115200

// for main loop timecheck
 unsigned long Ltime;                              // milliseconds   works for about 50 days
 unsigned long Ltime_old;                          // milliseconds memory last scan
 unsigned long Ltime_delta;                        // milliseconds delta from last scan
 
                                                   // L___ for calc actual values ( from millis )
                                                   // I___ for user set timer, I1__ for ON, I0__ for OFF,  
 int Ldays, I1days, I0days; 
 int Lhours, I1hours, I0hours;
 int Lminutes, I1minutes, I0minutes;
 int Lseconds, I1seconds, I0seconds;
                                                   // loop operating system memory
  unsigned long loopcount =0;                      // cycles 
  unsigned long loopreport=1000000;                // reset and time diag

  int exec1count, exec2count, exec3count, exec4count, exec5count, exec6count, exec7count, exec8count, exec9count; // now per job, only INT

  int exectim = 500;                               // default executer, if 1000000 loop need about 22sec, every 100 loops would mean 2msec jobtimer
                                                   // but even all 9 loops are enabled and all 9 run with this timer, they not are executed
                                                   // all in one loop and then exectim loops only counting.
                                                   // each job has a loopcounterlimit of exectim + jobnumber 
                                                   // so we will have rotating time slices for each job, 
                                                   // !! jobs should not depend on each other in a time critical way !!

  boolean exec1conti = true;                       // PB A
  boolean exec2conti = true;                       // PB A ramp
  boolean exec3conti = true;                       // PB B
  boolean exec4conti = true;                       // PB B ramp
  boolean exec5conti = true;                       // sinus ramp
  boolean exec6conti = true;                       // prog show A
  boolean exec7conti = true;                       // prog show B
  boolean exec8conti = true;                       // read 4 more field switches
  boolean exec9conti = false;   

// diagnostic print to USB
  boolean debugp = true;                           // variables dump to screen for diag
  boolean debugb = true;                           // moody push button diag
  
// variables for hardware pwm output to LT 3060 LED power repeater or MOSFET
// globals
 boolean pwminv = false;                           // invert pwm to 255 - signal
                                                   // TRUE for LT3060 control input, FALSE for MOSFET gate 100R

 int showcolT = 3000, showcolTG=2000, showcolTB=1000;                              // show time witch color to operate
 int rampexecuter = 1000;                          // slow ramp 
 int progexecuter = 1000;                          // show programs 

 int progsubcountA = 0;                             // slow programs counter / subdivider
 int progsubcountB = 0;                             // slow programs counter / subdivider
 int progsubdivA   = 200;                           // slow blink... 1000 * 200 == 4 sec
 int progsubdivB   = 200;                           // slow blink... 1000 * 200 == 4 sec
 int progshowlim  = 100;                           // two tip show for programs counter limit, then next program show ( 5 sec? per show )
  byte llim=50;                                    // clamp RGB output for MOODY
  byte hlim=200;                                   // clamp RGB output for MOODY

 int PBexecuter = 500;                             // check on push button ( 5msec )
 int PBtipmin = 50, PBtipmax =1500;                // millis pressed, a tip must be between 50millis and 1.5 sec pressed 
 int PBdtipmin = 100, PBdtipmax =1000;             // valid pause time between double click ( double click speed )

// sinus ramp     see JOB 5 running and used from A and B as setpoint  "rampsin"
 int rampcount;
 const float rad = 0.0245;                             // 2 * PI / 256
 byte rampsin;                                         // byte format for RGB   
 int sinexecuter = 1000;                               // same timing as ramp jobs

const int colopH =5;   //      5 programmed light shows
const int colopL =1;   //



// channel (_A)
 const byte pwm_R_A = 3;                           // Dout PWM pins 
 const byte pwm_G_A = 5;
 const byte pwm_B_A = 6;

  byte hw_R_A = 125;                               // variables to hold color values  start with HALF WHITE
  byte hw_G_A = 125;    
  byte hw_B_A = 125;

  byte hw_R_Amem = 125;
  byte hw_G_Amem = 125; 
  byte hw_B_Amem = 125; 
  byte highsetAmem = 0;
  int cwstepA=0;                                    // color wheel step
  int progsA=0;                                     // programmed shows 
  int progsAmem=0;                                     // programmed shows 
  int progshowcountA = 0;
  boolean black_A = false;



// MOODY BUTTON                                       local RGB control by one button
 const byte buttonpin_A1 = 2;                       // D in for field push button TMPB DIMMER 1
 const byte buttonpin_A2 = 4;                       // D in for field push button TMPB DIMMER 2
 const byte buttonpin_A3 = 7;                       // D in for field push button TMPB DIMMER 3 AND RGB
 
 int moody_A = LOW, moody_Amem = LOW;              // variables for button state
 boolean PBtipA = false, PBtipAmem = false;        // internal procedure variables
 boolean onetipA = false, twotipA = false, longtipAstart = false, longtipAend = false; // handover for prog control, 
 boolean powerstateA = true;                       // for switch light ON OFF by double click
 int colopA = 1;                                   // on TWO TIP select other color to operate ( by ramp function ) 
 boolean showstartA = false;                       // back to show actual color mix / ramp function
 boolean showR_A = false, showG_A = false,showB_A = false;
 
 unsigned long PBLtimeA;                           // milliseconds   works for about 50 days
 unsigned long PBLtimeA_old;                       // milliseconds memory last scan
 unsigned long PBLtimeA_delta;                     // milliseconds delta from last scan



// channel (_B)
 const byte pwm_R_B = 9;                           // Dout PWM pins 
 const byte pwm_G_B =10;
 const byte pwm_B_B =11;

  byte hw_R_B = 125;                               // variables to hold color values  start with HALF WHITE
  byte hw_G_B = 125;    
  byte hw_B_B = 125;

  byte hw_R_Bmem = 125;                            // memory used for dimmer..
  byte hw_G_Bmem = 125; 
  byte hw_B_Bmem = 125; 
  byte highsetBmem = 0;
  int cwstepB=0;                                    // color wheel step
  int progsB=0;                                     // programmed shows 
  int progsBmem=0;                                     // programmed shows 
  int progshowcountB = 0;
  boolean black_B = false;


  
// MOODY BUTTON     local RGB control by one button
 const byte buttonpin_B1 = 8;                      // D in for field push button TMPB DIMMER 1
// use Ain 0 for field push button TMPB DIMMER B2
 const byte buttonpin_B3 = 12;                     // D in for field push button TMPB DIMMER 3 AND RGB
 
 int moody_B = LOW, moody_Bmem = LOW;              // variables for button state
 boolean PBtipB = false, PBtipBmem = false;        // internal procedure variables
 boolean onetipB = false, twotipB = false, longtipBstart = false, longtipBend = false; // handover for prog control, 
 boolean powerstateB = true;                       // for switch light ON OFF by double click
 int colopB = 1;                                   // on TWO TIP select other color to operate ( by ramp function ) 
 boolean showstartB = false;                       // back to show actual color mix / ramp function
 boolean showR_B = false, showG_B = false,showB_B = false;
 unsigned long PBLtimeB;                           // milliseconds   works for about 50 days
 unsigned long PBLtimeB_old;                       // milliseconds memory last scan
 unsigned long PBLtimeB_delta;                     // milliseconds delta from last scan



                                                  // setup
void setup() {                
                                                  // initialize the digital pin as an output.
                                                  // Pin 13 has an LED connected on most Arduino boards:
  pinMode(ledPin, OUTPUT);                        // mainboard LED 
  digitalWrite(ledPin, HIGH);                     // set the LED on, later this LED will show if one pushbutton is pressed
 
// CHANNEL A
  pinMode(pwm_R_A, OUTPUT);                       // PWM Dout pin to LED power repeater init
  pinMode(pwm_G_A, OUTPUT); 
  pinMode(pwm_B_A, OUTPUT); 
                                                  // start with HALF WHITE               even without master control LED on 
    hw_rgbA(hw_R_A,hw_G_A,hw_B_A);

  // MOODY BUTTON
  pinMode(buttonpin_A1, INPUT);                   // D in push button to GND
  digitalWrite(buttonpin_A1, HIGH);               // enable internal pullup resistor

  pinMode(buttonpin_A2, INPUT);                   // D in push button to GND
  digitalWrite(buttonpin_A2, HIGH);               // enable internal pullup resistor

  pinMode(buttonpin_A3, INPUT);                   // D in push button to GND
  digitalWrite(buttonpin_A3, HIGH);               // enable internal pullup resistor

                                                  // CHANNEL B
  pinMode(pwm_R_B, OUTPUT);                       // PWM Dout pin to LED power repeater init
  pinMode(pwm_G_B, OUTPUT);
  pinMode(pwm_B_B, OUTPUT); 
                                                  // start with HALF WHITE  even without master control LED on 
    hw_rgbB(hw_R_B,hw_G_B,hw_B_B);

                                                  // MOODY BUTTON

  pinMode(buttonpin_B1, INPUT);                   // D in push button to GND
  digitalWrite(buttonpin_B1, HIGH);               // enable internal pullup resistor

//  pinMode(buttonpin_B2, INPUT);                 // D in push button to GND
//  digitalWrite(buttonpin_B2, HIGH);             // enable internal pullup resistor
  pinMode(A0, INPUT);                             // D in push button to GND
  digitalWrite(A0, HIGH);                         // enable internal pullup resistor

  pinMode(buttonpin_B3, INPUT);                   // D in push button to GND
  digitalWrite(buttonpin_B3, HIGH);               // enable internal pullup resistor
  
                                                  // serial interface  only for diagnostic prints to terminal
  Serial.begin(ser0bd);
  Serial.println("kll-engineering on ARDUINO "); 
  Serial.print(" TMPB2 ");
  Serial.println(prev); 
                                                  // V0.5  fix dimmer must work without two tip 
                                   RGB_mem_A();
                                   RGB_mem_B();

}


// run
void loop() {

                                                                         // main RUN of CONTI JOBS ( semi parallel )
 
              if ( exec1conti )                                          // JOB1
              {
                 if (exec1count == 0)
                 { // 1
                 PB_read_A();
                 PB_check_A();
                 PB_prog_A();                
                 }                 
                 exec1count = exec1count +1;
                 if (exec1count == ( PBexecuter + 1 )) { exec1count = 0; }
              }                                                                 // end if conti true

              if ( exec2conti )                                          // JOB2
              {
                 if (exec2count == 0)
                 { // 2
                 PB_ramp_A();
                 }                 
                 exec2count = exec2count +1;
                 if (exec2count == ( rampexecuter + 2 )) { exec2count = 0; }                 // job timer
              }                                                                 // end if conti true

              if ( exec3conti )                                          // JOB3
              {
                 if (exec3count == 0)
                 { // 3                                            
                 PB_read_B();
                 PB_check_B();
                 PB_prog_B();                

                 }                 
                 exec3count = exec3count +1;
                 if (exec3count == ( PBexecuter + 3 )) { exec3count = 0; }                 // job timer
              }                                                                 // end if conti true

              if ( exec4conti )                                          // JOB4
              {
                 if (exec4count == 0)
                 { // 4
                 PB_ramp_B();
                 
                 }                 
                 exec4count = exec4count +1;
                 if (exec4count == ( rampexecuter + 4 )) { exec4count = 0; }                 // job timer
              }                                                                 // end if conti true

              if ( exec5conti )                                          // JOB5
              {
                 if (exec5count == 0)
                 { //5                                                   sinus ramp is actually a (1 - cos())*128 => 0 .. 255 .. 0
                   rampcount = rampcount + 2;  // speed up
                   if (rampcount >= 256) { rampcount = 0;}
                   rampsin = byte( (1.0 - cos(float(rampcount) * rad)) * 128 );
                   //if (debugp) { 
                   //                            Serial.print("rampcount: "); 
                   //                            Serial.print(rampcount);
                   //                            Serial.print("rampsin: "); 
                   //                            Serial.println(rampsin,DEC);              
                   //            }  // if debug
                 }                 
                 exec5count = exec5count +1;
                 if (exec5count == (  sinexecuter + 5 )) { exec5count = 0; }                 // job timer
              }                                                                 // end if conti true

              if ( exec6conti )                                          // JOB6
              {
                 if (exec6count == 0)
                 { // 6
                 progshow_A();
                 }                 
                 exec6count = exec6count +1;
                 if (exec6count == ( progexecuter + 6 )) { 
                                                          exec6count = 0; 
                                                         }                 // job timer
              }                                                                 // end if conti true

              if ( exec7conti )                                          // JOB7
              {
                 if (exec7count == 0)
                 { // 7
                 progshow_B();

                 }
                 exec7count = exec7count +1;
                 if (exec7count == ( progexecuter + 7 )) { exec7count = 0; }                 // job timer

                 }                                                                 // end if conti true


              if ( exec8conti )                                          // JOB8
              {
                 if (exec8count == 0)
                 { //8
                   ext_func();                                           // read 4 more field switches
                 }                 
                 exec8count = exec8count +1;
                 if (exec8count == ( exectim + 8 )) { exec8count = 0; }                    // job timer
              }                                                                 // end if conti true

              if ( exec9conti )                                          // JOB9
              {

                 if (exec9count == 0)
                 { // 9

                 }                 
                 exec9count = exec9count +1;
                 if (exec9count == ( exectim + 9 )) { exec9count = 0; }                      // job timer about 1 msec
              }                                                                 // end if conti true
                  
                  
                  loopcount = loopcount + 1;                                     // for check cycle time

                  if ( loopcount == loopreport ) {                               // of 4 294 967 295 unsigned long
                                                  loopcount = 0;                 // reset
                                                  if (debugp) { print_time(); }  // if debug
                
                                                } // end if loopcount
                  
                    digitalWrite(ledPin, ( moody_A || moody_B ) );               // show on board LED ON if button is pressed, for loopcheck
                                       
     } // end loop



