//Demo LCD12864 spi
//www.dfrobot.com
// chinese to english by google/KLL

#include "LCD12864RSPI.h"


extern "C" 
{
#include <wiring.h> 
#include <inttypes.h>
#include <stdio.h>  //not needed yet
#include <string.h> //needed for strlen()
#include <avr/pgmspace.h>
}



LCD12864RSPI::LCD12864RSPI() 
{
this->DEFAULTTIME = 80; // 80 ms default time
this->delaytime = DEFAULTTIME;
} 

//*********************Delay function************************//
void LCD12864RSPI::delayns(void)
{   
delayMicroseconds(delaytime);
 }


void LCD12864RSPI::WriteByte(int dat)
{
    digitalWrite(latchPin, HIGH);
    delayns();
    shiftOut(dataPin, clockPin, MSBFIRST, dat);
    digitalWrite(latchPin, LOW);
}


void LCD12864RSPI::WriteCommand(int CMD)
{
   int H_data,L_data;
   H_data = CMD;
   H_data &= 0xf0;           //Lower 4 bits of data mask
   L_data = CMD;             //xxxx0000Format
   L_data &= 0x0f;           //High 4-bit data mask
   L_data <<= 4;             //xxxx0000 Format
   WriteByte(0xf8);          //RS=0 Write the instructions;
   WriteByte(H_data);
   WriteByte(L_data);
}


void LCD12864RSPI::WriteData(int CMD)
{
   int H_data,L_data;
   H_data = CMD;
   H_data &= 0xf0;           //
   L_data = CMD;             //
   L_data &= 0x0f;           //
   L_data <<= 4;             //xxxx0000
   WriteByte(0xfa);          //RS=1
   WriteByte(H_data);
   WriteByte(L_data);
}



void LCD12864RSPI::Initialise()
{
    pinMode(latchPin, OUTPUT);     
    pinMode(clockPin, OUTPUT);    
    pinMode(dataPin, OUTPUT);
    digitalWrite(latchPin, LOW);
    delayns();

    WriteCommand(0x30);        //Function set control word
    WriteCommand(0x0c);        //Display switch control word
    WriteCommand(0x01);        //Clear the screen control word
    WriteCommand(0x06);        //Into the set-point control word
}


void LCD12864RSPI::CLEAR(void)
{  
    WriteCommand(0x30);//
    WriteCommand(0x01);//Clear Display
}


void LCD12864RSPI::DisplayString(int X,int Y,uchar *ptr,int dat)
{
  int i;

  switch(X)
   {
     case 0:  Y|=0x80;break;

     case 1:  Y|=0x90;break;

     case 2:  Y|=0x88;break;

     case 3:  Y|=0x98;break;

     default: break;
   }

  WriteCommand(Y); //Location display start address

  for(i=0;i<dat;i++)
    { 
      WriteData(ptr[i]);//Note that the value of time code display Chinese characters, a character code indicates two consecutive
    }
}



void LCD12864RSPI::DisplaySig(int M,int N,int sig)
{
  switch(M)
   {
     case 0:  N|=0x80;break;

     case 1:  N|=0x90;break;

     case 2:  N|=0x88;break;

     case 3:  N|=0x98;break;

     default: break;
   }
  WriteCommand(N); //Location display start address
  WriteData(sig); //Output a single character
 }




void LCD12864RSPI::DrawFullScreen(uchar *p)
{
      int ygroup,x,y,i;
      int temp;
      int tmp;
             
      for(ygroup=0;ygroup<64;ygroup++)           //Upper part of the LCD image is written
        {                           //Write coordinates
           if(ygroup<32)
            {
             x=0x80;
             y=ygroup+0x80;
            }
           else 
            {
              x=0x88;
              y=ygroup-32+0x80;    
            }         
           WriteCommand(0x34);        //Write expanded command in the command
           WriteCommand(y);           //Write y axis
           WriteCommand(x);           //Write x-axis coordinate
           WriteCommand(0x30);        //Write basic instruction command
           tmp=ygroup*16;
           for(i=0;i<16;i++)
		 {
		    temp=p[tmp++];
		    WriteData(temp);
               }
          }
        WriteCommand(0x34);        //Write expanded command in the command
        WriteCommand(0x36);        //Display image
}



void LCD12864RSPI::DrawFullScreen_FLASH(uchar *p)    // new function by KLL
{
      int ygroup,x,y,i;
      int temp;
      int tmp;
             
      for(ygroup=0;ygroup<64;ygroup++)           //Upper part of the LCD image is written
        {                           //Write coordinates
           if(ygroup<32)
            {
             x=0x80;
             y=ygroup+0x80;
            }
           else 
            {
              x=0x88;
              y=ygroup-32+0x80;    
            }         
           WriteCommand(0x34);        //Write expanded command in the command
           WriteCommand(y);           //Write y axis
           WriteCommand(x);           //Write x-axis coordinate
           WriteCommand(0x30);        //Write basic instruction command
           tmp=ygroup*16;
           for(i=0;i<16;i++)
		 {
		    temp=pgm_read_byte(&p[tmp++]);          // from flash readback KLL
		    WriteData(temp);
               }
          }
        WriteCommand(0x34);        //Write expanded command in the command
        WriteCommand(0x36);        //Display image
}





LCD12864RSPI LCDA = LCD12864RSPI();