// SPI_LCD_MENU_inflash_kll
// 4.5.2011 KLL engineering
// 12.5.2011 use flash progmem utility
// FRIDAY 13.5.2011 measuring subroutine has problems??


//#include <Flash.h>   // Mikal Hart PROGMEM Library, 
                     // http://arduiniana.org/libraries/flash/

#include <avr/pgmspace.h>
// try menutext in FLASH to save SRAM memory,
// but need to copy to RAM variable

/* DFRobot interface shield shiftout cable
to LCD12864 SPI input 
DFRobot LCD  Arduino
PIN1 = GND
PIN2 = 5V
RS(CS) = 8;             (latchPin)
RW(SID)= 9;             (dataPin)
EN(CLK) = 3;            (clockPin)
PIN15 PSB = GND;
*/
// MOD KLL 4.5.2011
// use 4 Dins for menu operation pushbuttons
// use internal pullup and wire Pushbuttons to ground

// up     PIN5  ( not needed  4 * down = first line )
// down   PIN6
// left   PIN4  ( not needed  )
// right  PIN7

// as     PIN0 and PIN1 are used for serial / USB communication
// interface shield uSD card slot
// PIN10  SS
// PIN11  MOSI
// PIN12  MISO
// PIN13  SCK and ARDUINO motherboard yellow LED
// only   PIN2 PIN4, PIN5 is  still unused!

#include "LCD12864RSPI.h" 
// has functions:
// LCDA.Initialise(void);
// LCDA.delayns(void);
// LCDA.WriteByte(int dat);
// LCDA.WriteData(int CMD);
// LCDA.CLEAR(void);
// LCDA.DisplayString(int X,int Y,uchar *ptr,int dat);
// LCDA.DrawFullScreen(uchar *p);

// LCDA.DrawFullScreen_FLASH(uchar *p);    //new KLL

// in FLASH
prog_uchar PROGMEM enchar0[] = {"KLL-engineering "};//
prog_uchar PROGMEM enchar1[] = {"    test        "};// 
prog_uchar PROGMEM enchar2[] = {"DFRobot SPI LCD "};// 
prog_uchar PROGMEM enchar3[] = {"ST7920 LCD12864 "};// 

prog_uchar PROGMEM enchar4[]="Measuring       ";//
prog_uchar PROGMEM enchar5[]="                ";// 
prog_uchar PROGMEM enchar6[]="                ";// 
prog_uchar PROGMEM enchar7[]="                ";// 

// remember character must be 16, but 16th must be " ", is used for menu operation 
prog_uchar PROGMEM M00[]="M0desc          ";//
prog_uchar PROGMEM M01[]="M1              ";//
prog_uchar PROGMEM M02[]="M2              ";//
prog_uchar PROGMEM M03[]="M3              ";//

prog_uchar PROGMEM M10[]="M1desc          ";//
prog_uchar PROGMEM M11[]="M11             ";// job11();
prog_uchar PROGMEM M12[]="M12             ";// job12();
prog_uchar PROGMEM M13[]="M13             ";// job13();

prog_uchar PROGMEM M20[]="M2desc          ";//
prog_uchar PROGMEM M21[]="M21             ";// job21();
prog_uchar PROGMEM M22[]="M22             ";// job22();
prog_uchar PROGMEM M23[]="M23             ";// job23();

prog_uchar PROGMEM M30[]="M3desc          ";//
prog_uchar PROGMEM M31[]="M31             ";// job31();
prog_uchar PROGMEM M32[]="M32             ";// job32();
prog_uchar PROGMEM M33[]="M33             ";// job33(); measurescreen();


// in SRAM
unsigned char headerline[]=" job00          ";//
unsigned char emptyline[]="                ";//
// in SRAM will hold copies of Mxx and overwritten Mxx[15]
// because write to FLASH variables not possible
unsigned char mline1[]="                ";//
unsigned char mline2[]="                ";//
unsigned char mline3[]="                ";//
unsigned char mline4[]="                ";//
  
// menue position
int Mpoint = 0;
int Mline = 0;

// button operated 4 line menu
int MdownPin = 6;   // menu line select next
boolean Mdownold = false;
boolean Mdown = false;
boolean Mdownpressed = false;
int MrightPin = 7;  // menu select ok
boolean Mrightold = false;
boolean Mright = false;
boolean Mrightpressed = false;
boolean redraw = true;


int menudelay = 0;
int showjob = 3000;
int buttondelay= 100;

// measurement screen
int val = 0;
int sval_long = 0;
String sval;
int dval;

void setup()
{
   // down ( select next menu line L0, L1, L2, L3 , L0 ring ) 
   pinMode(6, INPUT);        // sets the digital pin as input
   digitalWrite(6, HIGH);    // enable pullup
   // right ( select option of the actual line, if L0 active go up menu )
   pinMode(7, INPUT);        // sets the digital pin as input
   digitalWrite(7, HIGH);    // enable pullup
   
  LCDA.Initialise(); // INIT SCREEN
  delay(100);

  showlogo();

  showmenuintro();

    Serial.begin(19200);  //debug USB line
  // This proves that all the big data is really in flash memory and not consuming RAM
  Serial.print("free Mem: "); Serial.print(availableMemory()); Serial.println(" of 2048 byte");
// first run without flash  Prog 10502 bytes, Mem: 171
// second run with 4 emptylines in SRAM, rest in FLASH Prog 10826 bytes, Mem: 511
// NOW  Binary sketch size: 10852 bytes (of a 32256 byte maximum)  free Mem: 1528 of 2048 byte

}

void loop()
{

  if (redraw) {   drawmenu();   redraw=false; }                // only write LCD 4 lines if change

  menubutton();                                                // check 2 buttons and init actions and redraw
  delay(buttondelay);                                          // slow buttoncheck / this main program

} // end main loop


void screen4L(unsigned char X0[],unsigned char X1[],unsigned char X2[],unsigned char X3[],int showtime,boolean sclear)
{

 if ( sclear ) { LCDA.CLEAR(); delay(100); } //

LCDA.DisplayString(0,0,X0,16);//
delay(20);
LCDA.DisplayString(1,0,X1,16);//
delay(20);
LCDA.DisplayString(2,0,X2,16);//
delay(20);
LCDA.DisplayString(3,0,X3,16);//
delay(showtime);
}


void menubutton()               
// generates a oneshot true on Mxxxpressed if button goes HIGH / LOW (just pressed)
{
Mdownold = Mdown;
Mdown = digitalRead(MdownPin);
if ( ( Mdown == false ) && (Mdownold == true) ) // pressed = short to ground
{ 
  Mdownpressed = true; 
  redraw = true;  
  Serial.print("Mpoint ");  
  Serial.print(Mpoint);  
  Serial.print(" Mline ");  
  Serial.print(Mline);  
  Serial.println(" down ");
} else {
  Mdownpressed = false;
} 


Mrightold = Mright;
Mright = digitalRead(MrightPin);
if ( ( Mright == false ) && (Mrightold == true) ) // pressed = short to ground
{ 
  Mrightpressed = true;   
  redraw = true;
  Serial.print("Mpoint ");  
  Serial.print(Mpoint);  
  Serial.print(" Mline ");  
  Serial.print(Mline);  
  Serial.println(" right ");
} else {
  Mrightpressed = false;
} 
if ( Mdownpressed ) {  // active line in 4 line menu
                      Mline = Mline +1;
                      if (Mline == 4) { Mline = 0; }
                      }
// action matrix
if (( Mrightpressed ) && (Mpoint == 0) && (Mline ==0)) {Mline=0; Mpoint = 0; Mrightpressed=false;}
if (( Mrightpressed ) && (Mpoint == 0) && (Mline ==1)) {Mline=0; Mpoint = 1; Mrightpressed=false;}
if (( Mrightpressed ) && (Mpoint == 0) && (Mline ==2)) {Mline=0; Mpoint = 2; Mrightpressed=false;}
if (( Mrightpressed ) && (Mpoint == 0) && (Mline ==3)) {Mline=0; Mpoint = 3; Mrightpressed=false;}

if (( Mrightpressed ) && (Mpoint == 1) && (Mline ==0)) {Mline=0; Mpoint = 0; Mrightpressed=false;}  // up
if (( Mrightpressed ) && (Mpoint == 1) && (Mline ==1)) {Mline=0; Mpoint = 1; Mrightpressed=false; job11();}
if (( Mrightpressed ) && (Mpoint == 1) && (Mline ==2)) {Mline=0; Mpoint = 1; Mrightpressed=false; job12();}
if (( Mrightpressed ) && (Mpoint == 1) && (Mline ==3)) {Mline=0; Mpoint = 1; Mrightpressed=false; job13();}

if (( Mrightpressed ) && (Mpoint == 2) && (Mline ==0)) {Mline=0; Mpoint = 0; Mrightpressed=false;}  // up
if (( Mrightpressed ) && (Mpoint == 2) && (Mline ==1)) {Mline=0; Mpoint = 2; Mrightpressed=false; job21();}
if (( Mrightpressed ) && (Mpoint == 2) && (Mline ==2)) {Mline=0; Mpoint = 2; Mrightpressed=false; job22();}
if (( Mrightpressed ) && (Mpoint == 2) && (Mline ==3)) {Mline=0; Mpoint = 2; Mrightpressed=false; job23();}

if (( Mrightpressed ) && (Mpoint == 3) && (Mline ==0)) {Mline=0; Mpoint = 0; Mrightpressed=false;}  //up
if (( Mrightpressed ) && (Mpoint == 3) && (Mline ==1)) {Mline=0; Mpoint = 3; Mrightpressed=false; job31();}
if (( Mrightpressed ) && (Mpoint == 3) && (Mline ==2)) {Mline=0; Mpoint = 3; Mrightpressed=false; job32();}
if (( Mrightpressed ) && (Mpoint == 3) && (Mline ==3)) {Mline=0; Mpoint = 3; Mrightpressed=false; 
                                                                             job33();   }
                                                                             //measurescreen(); }
} // end menubutton


