
#!usr/bin/python
# PMS3scope.py
# a service write the arduino measuring data from USB input
# to a file, with this sketch we can show scope graph
# KLL engineering 2013 11 22
# 


import numpy as np
import matplotlib.pyplot as plt
from matplotlib.widgets import Button
from array import *

multiscope = 3
Vrange = 5.0                              # arduino 5VDC

arraylong = 360                           # arduino batch array
PMS0array = array('f',[])
PMS1array = array('f',[])
PMS2array = array('f',[])
# info from summary (last) line
A_delaypoint = ' '
A_channela = ' '
A_channelb = ' '
A_channelc = ' '
A_sampletime = ' '
A_samples = ' '
A_samplefreq = ' '

filename      = 'later'
pointfilename = '/run/shm/current.txt'
linecount = 0
        
def read_filename():
    global filename
    fdatp = open(pointfilename,"r")
    filename = fdatp.readline()           # points to the actual datafile in ringbuffer
    fdatp.close()


def read_batchfile():
    global linecount, A_delaypoint, A_channela, A_channelb, A_channelc
    global A_sampletime, A_samples, A_samplefreq
    global PMS0array, PMS1array, PMS2array
    
    temp_list = []                        # all lines from file
    tempVals  = []                        # clean
    tempSvals = []                        # clean
    linecount = 0                         # clean
    reccount = 0                          # clean
    PMS0array = []                        # clean
    PMS1array = []                        # clean
    PMS2array = []                        # clean
    #print 'read_batchfile from %s' % (filename)
    with open(filename,"r") as fdat:      # open w file for write only a for append
        for line in fdat:
            linecount = linecount + 1
            line = line.strip('\r\n') 
            #print "line: %s, %s" % (linecount,line)
            temp_list.append(line)
    fdat.close()                          # close the file ?NEED? with open?
    #print ('batchfile read finished, see: ' +str(linecount) +' lines')
    for line in temp_list:
        tempVals  = []                     # clean
        tempSvals = []                     # clean
        reccount = reccount + 1
        tempSvals = line.split(',')
        for svals in tempSvals:
                try :
                    vals = int(svals)
                    tempVals.append(vals)
                except :
                    pass
            
        if len(tempVals) == multiscope :   # 3 beams
            #print 'rec: %s 1: %s 2: %s 3: %s ' % (reccount,tempVals[0],tempVals[1],tempVals[2])
            PMS0array.append(tempVals[0]*Vrange/1024)
            PMS1array.append(tempVals[1]*Vrange/1024)
            PMS2array.append(tempVals[2]*Vrange/1024)
        else:
            if len(tempVals) > multiscope :
                #print tempVals
                #[1, 0, 1, 2, 23, 360, 15627]
                # delaypointer, channela, channelb, channelc, sampletime msec, samples, sampleFreq Hz
                A_delaypoint = tempSvals[0]
                A_channela   = tempSvals[3]
                A_channelb   = tempSvals[5]
                A_channelc   = tempSvals[7]
                A_sampletime = tempSvals[9]
                A_samples    = tempSvals[11]
                A_samplefreq = tempSvals[13]
            else :
                print 'bad line'
        
    pass #end read_batchfile


def get_data():
    global linecount, filename
    global PMS0array, PMS1array, PMS2array
    
    read_filename()
    read_batchfile()
    print 'read lines %s from file: %s' % (linecount,filename)



# main

get_data()
# again backward, newest data left!
x1 = np.linspace(arraylong,1,arraylong)  
x2 = np.linspace(arraylong,1,arraylong)
x3 = np.linspace(arraylong,1,arraylong)

y1 = np.array(PMS0array)
y2 = np.array(PMS1array)
y3 = np.array(PMS2array)

fig = plt.figure(figsize=(7,7))

ax1 = fig.add_subplot(multiscope, 1, 1)
line1, = ax1.plot(x1, y1, 'y.-')
ax1.axis([1,360,0,Vrange])
ax1.set_title('PMS3 Arduino oscilloscope on RPI')
ax1.set_ylabel('A'+A_channela)

ax2 = fig.add_subplot(multiscope, 1, 2)
line2, = ax2.plot(x2, y2, 'b.-')
ax2.axis([1,360,0,Vrange])
ax2.set_ylabel('A'+A_channelb)

ax3 = fig.add_subplot(multiscope, 1, 3)
line3, = ax3.plot(x3, y3, 'g.-')
ax3.axis([1,360,0,Vrange])
ax3.set_ylabel('A'+A_channelc)
ax3.set_xlabel('samples: '+A_samples+', sampletime: '+A_sampletime+'ms, samplefreq: '+A_samplefreq+' Hz,')

# make update button
updateax = plt.axes([0.89,0.025,0.1, 0.04])
button =Button(updateax, 'UPDATE', color='lightgoldenrodyellow', hovercolor='0.975')

def update(event):
    global PMS0array, PMS1array, PMS2array
    global x1, y1
    global x2, y2
    global x3, y3
    print 'update button pressed'
    get_data()
    y1 = np.array(PMS0array)
    line1.set_data(x1, y1)
    y2 = np.array(PMS1array)
    line2.set_data(x2, y2)
    y3 = np.array(PMS2array)
    line3.set_data(x3, y3)
    fig.canvas.draw()
    pass

button.on_clicked(update)


plt.show()
