// POWER_meter_kll_V03 ( for Processing 1.5.1 )
// by kll-engineering

// a 5 channel powermeter ( 1 VAC, 5 AAC inputs )
// http://kll.byethost7.com/kll_en7/news.php?readmore=20



// expects to run in ARDUINO 
// a sketch: POWER_meter_kll_V03 ( V0.3c ARDUINO 1.0 )


// see dir [code]
import arduinoscope.*;              // (c) 2009 David Konsumer <david.konsumer@gmail.com>
import processing.serial.*;
import controlP5.*;                 // http://www.sojamo.de/libraries/controlP5/




PFont fontLarge;
PFont fontSmall;
int[] vals;

import cc.arduino.*;

int multiscope = 6;  
int ldelta =0; // black lines for 1V/dev

int channels = 6;
int delaytime = 6;    // ARDUINO start value
Oscilloscope[] scopes = new Oscilloscope[multiscope];  // 
Serial port;
int LINE_FEED=10; 

ControlP5 controlP5;                          // for buttons...

int OFFSET = 512;              //  for FFT calc only, without the 2.5v offset

color off = color(4, 79, 111);
color on = color(184, 145, 0);
int dvalue =  Arduino.LOW;

long loopcount, actmillis, oldmillis, deltamillis;
int loopend=1000;
int samplerate=0;
boolean debugp=false; // show sample rate
boolean debugd=false; // show income data.. diagnostic

// batch window variables
boolean batchmode=false, batchdata=false, showbatch=false;
int[] zoomarray = new int[512];
int zline = 0;
char zchannel = '0';                                                      // Ain 0
int zsamplerate=5120; // used for FFT, after  int delayusec=86; in arduino get 5 sinus in 512 samples window, 
                      // and gives a nice FFT in zoom window after subtract OFFSET 512
/*
FFT 
[0] 0 Hz 16
[1] 10 Hz 14
[2] 20 Hz 16
[3] 30 Hz 21
[4] 40 Hz 36
[5] 50 Hz 287
[6] 60 Hz 40
[7] 70 Hz 17
[8] 80 Hz 10
[9] 90 Hz 7
*/


secondApplet s;

Oscilloscope[] Zscope = new Oscilloscope[1];  // use new zoom scope window 
int Zwidth=512;
int Zheight=520;
// ControlP5 ZcontrolP5;                          // for buttons in zoom

// FFT
import ddf.minim.analysis.*;
import ddf.minim.*;
import ddf.minim.signals.*;

FFT fft;
float[] buffer = new float[512];


void setup() {
  size(642, 520);    // 642 - 130 textarea is 512 scope pixel
  controlP5 = new ControlP5(this);
  
  // set these up under tools/create font, if they are not setup.
  fontLarge = loadFont("TrebuchetMS-20.vlw");
  fontSmall = loadFont("Uni0554-8.vlw");

  vals = new int[multiscope];
  
  int[] dimv = new int[2];
  dimv[0] = width-130;                    // 130 margin for text
  dimv[1] = (height-30)/multiscope;       // for scope area
  
    for (int i=0;i<multiscope;i++){
          int[] posv = new int[2];
          posv[0]=0;
          posv[1]=dimv[1]*i+30; // shift down for header area

    // random color, that will look nice and be visible
    scopes[i] = new Oscilloscope(this, posv, dimv);   
    scopes[i].setLine_color(color((int)random(255), (int)random(127)+127, 255));

    controlP5.addButton("pause",1,dimv[0]+2,posv[1]+10,32,20).setId(i);
    controlP5.addButton("logic",1,dimv[0]+36,posv[1]+10,29,20).setId(i+50);
    controlP5.addButton("save",1,dimv[0]+67,posv[1]+10,29,20).setId(i+100);
    controlP5.addButton("zoom",1,dimv[0]+98,posv[1]+10,29,20).setId(i+150);    
   }  // for 6 scopes


    println(Serial.list());                                             // kll
    port = new Serial(this, Serial.list()[3], 115200);                    // kll here (4) as com13  (1) as com3
  
  // clear and wait for linefeed
  port.clear();
  port.bufferUntil(LINE_FEED);

// check scope timing
loopcount = 0;  // reset
oldmillis=0;

//           port.write('0');  // reset other job
//           delay(100);
           port.write('5');  // send to arduino for start sending OSCI data

}

void draw() {
  background(off);
  stroke(on);
  
  
  textFont(fontSmall);  
  fill(255);
//  text("key operation: zoom channel 0,1,2,3,4,5 / z d",10,20);
//  text(delaytime,360,20);
  text(samplerate + " Hz",400,20);
  
  text( str(day())+ "." + str(month()) + "." + str(year()) + " " + str(hour()) + ":" + str(minute()) + ":" + str(second())  , width-120, 20 ); 

   ldelta = (height-30)/(multiscope*5) ; //pixel / 1 volt
   // show 2 scope with Ain from ARDUINO
   for (int i=0;i<multiscope;i++){
     // update and draw scopes
   // vals[i] = arduino.analogRead(i); no firmata , see serial event for data income
    
    scopes[i].addData(vals[i]);  // arrayindex out of bounds exception 1
    scopes[i].draw();
    
    // conversion multiplier for voltage
    float multiplier = scopes[i].getMultiplier()/scopes[i].getResolution();
    
    // convert arduino vals to voltage
    float minval = scopes[i].getMinval() * multiplier;
    float maxval = scopes[i].getMaxval() * multiplier;
    int[] values = scopes[i].getValues(); 
    float pinval =  values[values.length-1] * multiplier;
    
    // add lines
    // scopes[i].drawBounds();
    // we show a 5 Volt signal, so need 4 line ( 1 V / dev )
    int[] pos = scopes[i].getPos();
    int[] dim = scopes[i].getDim();
    stroke(0);                          // black lines for 1 V dev
        line(0, pos[1]+ldelta, dim[0], pos[1]+ldelta);
        line(0, pos[1]+2*ldelta, dim[0], pos[1]+2*ldelta);
        line(0, pos[1]+3*ldelta, dim[0], pos[1]+3*ldelta);
        line(0, pos[1]+4*ldelta, dim[0], pos[1]+4*ldelta);
    stroke(255);                        // white line for scope (top)
        line(0, pos[1], width, pos[1]);
    
    // we show a 5 Volt signal, so need 4 line ( 1 V / dev )
    
    // add labels
    fill(255);
    textFont(fontLarge);
    text(pinval, width-60, pos[1] + dim[1] - 10);
    
    textFont(fontSmall);   
    text("min: " + minval, dim[0] + 10, pos[1] + 40);
    text("max: " + maxval, dim[0] + 10, pos[1] + 48);
    
    textFont(fontLarge);                           // kll to small can not read anything
    fill(scopes[i].getLine_color());
    text("A" + i, dim[0] + 10,pos[1] + dim[1] - 10);
  }
  
  // draw text seperator, based on first scope
  int[] dim = scopes[0].getDim();
  stroke(255);
  line(dim[0], 0, dim[0], height);

  controlP5.draw();        // button update
 
} // end draw



