
// POWER_meter_kll_V03 ( for ARDUINO 1.0 )
// by kll-engineering

// a 5 channel powermeter ( 1 VAC, 5 AAC inputs )
// http://kll.byethost7.com/kll_en7/news.php?readmore=20


/*_________________________________________________________________*/
/*   POWER METER                                                   */
/*                                                                 */
/*_________________________________________________________________*/

/*_________________________________________________________________*/
/*  KLL-engineering                                                */
/*  V0.1 02.9.2011 setup from menue V0.6                           */
/*  V0.2 include 512 sample collection for OSCI ZOOM               */
/*       and normal SCOPE 6 channel when processing sketch is used */
/*       but the original EMON program as default job              */
/*  V0.3 project work 5 current measurement                        */
/*  V0.3b more cleanup                                             */
/*  V0.3b calibrate emon  on Vcc                                   */
/*  V0.3c ARDUINO 1.0 version                                      */
/*_________________________________________________________________*/
char prev[5]="V0.3";
// change reporting reverse timing
// check on quiet for processing on menuoperation

// because there was a SRAM problem earlier
// i reduced ARRAY ZOOMDATA to 256 integer
// now try to change back to 512 after
// checking on other variables
// use flash progmem utility
// but the memtest utility not runs alltime, only for diagnostic




const int OFFSET = 0;    // 512 to subtract from each measurement because new power meter shield work with virtual NULL

                                                   // wiring
                                                   // arduino board LED "L"
const int ledPin    = 13;
                                                   // ATmega386 PWM outputs: 3,5,6,9,10,11 

                                                   // ATmega386 Ain A0 .. A5
                                                  // variables
                                                  // serial communication
const long ser0bd = 115200;                               // 300, 1200 good, 2400, 9600 good, 14400, 19200 good, 28800, 38400 good, 57600 setpoint not good, 115200 good
int inByte;
int serloop = 0, serloopend = 501;               // only after serloopend cycles check for USB income
const int delayusb = 20;                               // at 57600  setpointinput 2,3 digit dont work with 10 or 100

 unsigned long Ltime;                             // milliseconds   works for about 50 days
 unsigned long Ltime_old;                         // milliseconds memory last scan
 unsigned long Ltime_delta;                       // milliseconds delta from last scan

                                                  // L___ for calc actual values ( from millis )
                                                  // I___ for user set timer, I1__ for ON, I0__ for OFF,  
 int Ldays; 
 int Lhours;
 int Lminutes;
 int Lseconds;
const char ONs[]="ON ";
const char OFs[]="OFF ";

  int ledpin13=1;                                // toggle memory LED 13 
                                                   // Menu operating system memory
  int menuselect = 58;                             //":"
  unsigned long loopcount =0;                      // cycles 
  unsigned long loopreport=1000000;                // reset and time diag
  //unsigned long execcount;                         // job cycles 

  int exec1count, exec2count, exec3count, exec4count, exec5count, exec6count, exec7count, exec8count, exec9count; // now per job, only INT
//  int exectim = 1000;                              // default executer for 10sec for 1000000 loop it would be 10msec

  boolean exec1conti = true;                  // test EMON
const   int exec1tim = 30001;
  boolean exec2conti = false;
const   int exec2tim = 1002;
  boolean exec3conti = false; 
const   int exec3tim = 30003;                 // show Ain
  boolean exec4conti = false;
const   int exec4tim = 1004;
  boolean exec5conti = false;
const   int exec5tim = 405;                   // for scope
  boolean exec6conti = false;
const   int exec6tim = 1006;
  boolean exec7conti = false;
const   int exec7tim = 1007;
  boolean exec8conti = false;
const   int exec8tim = 1008;
  boolean exec9conti = false;
  //int exec9tim = 1009;   see samplerate

  boolean debugp = false;                          // variables dump to screen for diag
// get setpoint function dump
  boolean debuga = false;                          // from get_set_value int function only


// analog in and filter
long VCCread=0;

int samplerate = 2000;    // exec9tim means after how many loops ameaseure is executed
// 1001 == 1000 samples and 1:54 for 1.000.000 loops: 8.76 samples per second
//  200 == 5000 samples and 8:47 for 1.000.000 loops: 9.48 samples per second
// vcc afterdelay disabled (100), ameasure delay from 20 to 10
//  200 == 5000 samples and 5:28 for 1.000.000 loops: 15.24 samples per second
//  100 == 10000 samples and 10:45 for 1.000.000 loops: 15.50 samples per second
// 2000 == 500 samples and 0:42 for 1.000.000 loops: 11.90 samples per second
// now test again about reducing ains
// only VCC, A0, A1 2000 == 500 samples and 0:21 for 1.000.000 loops: 22.85 samples per second
// only A0, A1 2000 == 500 samples and 0:15 for 1.000.000 loops: 31.91 samples per second
// no aread 2000 == 500 samples and 0:11 for 1.000.000 loops: for check OS basic


int samplecount = 0;
int channels=6;                                  // Ain 0 ..5

const int adelay=10;   //20   milli sec between analog reads

//int   A0in, A1in, A2in, A3in, A4in, A5in;                                     // analog ins

//float A0val = 0.0, A1val = 0.0, A2val = 0.0, A3val = 0.0, A4val = 0.0, A5val = 0.0;         // analog inputs VOLT calc

// recursiv digital filter
// Y = old * filter0 + new * filter1
// see http://www.editgrid.com/user/kll/filterdesign
// used in TAB ameasure

//float A0Y = 0.0, A1Y = 0.0, A2Y = 0.0, A3Y = 0.0, A4Y = 0.0, A5Y = 0.0;                     // filtered values 

//float A0fil0 = 0.9, A1fil0 = 0.9, A2fil0 = 0.9, A3fil0 = 0.9, A4fil0 = 0.9, A5fil0 = 0.9;         // analog inputs filter first order
//float A0fil1 = 0.1, A1fil1 = 0.1, A2fil1 = 0.1, A3fil1 = 0.1, A4fil1 = 0.1, A5fil1 = 0.1;         // analog inputs filter first order

                                   // batch ZOOM   , run at 512 into SRAM problems
  int Ain[512];                    // test 256 to 512 after menu text in flash
const  int zoomarray=512;
  int zoomchannel=0;
const  int delayusec=86;                // delay between ZOOM analog read: with 86 usec delay i get in 512 samples 5 times 50Hz sinus ( is 100msec time ) and 102 samples per sinus
                                   // this reduces the sample rate from max 8900Hz to 5120Hz ( 0.000192 sec )?? pls check
const  int delayserialusec=100;         // delay send lines in batch mode
const  int delayserialmsec=20;          // only used prior and after zoom data send
  int linec=0;
const  int linelength=8;                // until LF gives 64 lines with 8 values = 512


//                                              EMON variables
//Setup variables
const int numberOfSamples = 3000;

//Set Voltage and current input pins
const int inPinV = 0;
int inPinI = 1;  // ( 1 .. 5 loop )
int inPinIlim = 1;   // adjust current channels 1 .. 5 here
//Sanity check calibration method thanks to Eric Sandeen http://sandeen.net/wordpress
//See discussion here: http://openenergymonitor.org/emon/node/59
//Enter the values of your setup below 

// Voltage is reduced both by wall xfmr & voltage divider
#define AC_WALL_VOLTAGE        210.7
#define AC_ADAPTER_VOLTAGE     8.7
// Ratio of the voltage divider in the circuit
#define AC_VOLTAGE_DIV_RATIO   11.0
// CT: Voltage depends on current, burden resistor, and turns
#define CT_BURDEN_RESISTOR    470.0
#define CT_TURNS              1000.0

//Calibration coeficients
//These need to be set in order to obtain accurate results
//Set the above values first and then calibrate futher using normal calibration method described on how to build it page.
const double VCAL = 1.00;
const double ICAL = 1.00;
const double PHASECAL = 2.3;   //    2.3

// Initial gueses for ratios, modified by VCAL/ICAL tweaks
// #define AC_ADAPTER_RATIO       (AC_WALL_VOLTAGE / AC_ADAPTER_VOLTAGE)
// double V_RATIO = AC_ADAPTER_RATIO * AC_VOLTAGE_DIV_RATIO * 5 / 1024 * VCAL;
// double I_RATIO = (long double)CT_TURNS / CT_BURDEN_RESISTOR * 5 / 1024 * ICAL;

double V_RATIO,I_RATIO;   // for use after calibration  KLL

//Sample variables
int lastSampleV,lastSampleI;   
int sampleV,sampleI;

//Filter variables
double lastFilteredV, lastFilteredI;
double filteredV, filteredI;
// double filterTemp;             // KLL

//Stores the phase calibrated instantaneous voltage.
double shiftedV;

//Power calculation variables
double sqI,sqV,instP,sumI,sumV,sumP;

//Useful value variables
double realPower,
       apparentPower,
       powerFactor,
       Vrms,
       Irms;
       

//__________________________________________________________________________________________________

int get_set_value (String question, int defaultval=0, int timeout=0) {  
  int ainByte;
  int Bytecount = 0;	                                             // for incoming serial data
  int innum=0;                                                       // or long,  int limit is 32,767
  int inval = 0;
  boolean valok = false;                                             // wait for bytes from USB
                                                                     // open points: speedtests, timeout 
   
                                                                     // send the question to USB and wait for answer of a set value 
  if (question == "") { } else {    // quiet for processing
  Serial.print(question); }
                                                                    // wait answer
     do {
  	if (Serial.available() > 0) {                               // USB terminal interrupt
          delay(delayusb);                                          //get all the string to buffer
          Bytecount = Serial.available();                           // ask how many bytes, max 128
                                         if (debuga) {
                                            Serial.print (F(" Bytes: "));
                                            Serial.println(Bytecount);    // diag echo
                                         }                                // end if debug  
          for ( int i=0; i < Bytecount; i++){
            
          ainByte = Serial.read();
          inval = char_num(ainByte);
          if (inval != -1) 
           { 
             if ( inval == -2)                                             // CR LF 
             {
                                                                           // ignore it
             }
             else
             {
                                                                           // we want limit to int so prevent overflow
             if ( ( innum > 3276 ) ||  ( innum == 3276 && inval > 7 )  )   // next byte too much 
             {
               innum = 32767;                                              // discard input
               i = Bytecount;                                              // stop for loop
               Serial.print (F(" to big, defaulted to: "));               
             }
             else
             {
               innum = innum*10 + inval;                                   // calc number
             }
             } 
           }
           else                                                            // -1 from char_num function
           { 
             innum = defaultval;                                           // discard input
             i = Bytecount;                                                // stop for loop
             Serial.print (F(" no number, defaulted to: ")); 
           }
          
                                         if (debuga) {
                                           Serial.print ( ainByte);       // byte
                                           Serial.print (" ");
                                            Serial.print(inval);          // diag echo value
                                           Serial.print (F(" number "));
                                            Serial.println(innum);        // diag echo value
                                         }                                // end if debug  
          }                                                               // end for
           valok = true; 
         }
         else
         { 
                                                                         //delay (delayusb); //and try again
           valok = false;
          }
     } while(valok == false);                                            // wait for answer
  if (question == "") { } else {    // quiet for processing     
     Serial.println(innum);  }                                            // echo in answer line
     
     return innum;
}                                                                        // end get_set_value

//__________________________________________________________________________________________________



                                                 // setup
void setup() {                
                                                 // initialize the digital pin as an output.
                                                 // Pin 13 has an LED connected on most Arduino boards:
                                                 // delay 1000 is 1 sec
  pinMode(ledPin, OUTPUT);
  digitalWrite(ledPin, HIGH);                    // set the LED on // toggle all 1000 read job 9
 
  Serial.begin(ser0bd);
  Serial.println(F("kll-engineering on ARDUINO"));
  Serial.println(F("hit BLANK ENTER"));

  VCCread=readVcc();
  Serial.print(F("Vcc: "));
  Serial.print(VCCread,DEC);
  Serial.println(" mV");


//Serial.print("Mem free: "); Serial.println(availableMemory());
  //                               show 143   
  // delete filter real variables  show 251
  // menu in FLASH                 show 781
  // array from 256 to 512         show 269   very good
  // with EMON var.                show 109
  // make some const               show 135
  
 if ( exec1conti ) { Serial.println(F("Ix, W , VA , p , Vrms , Irms")); } // JOB1 EMON enabled

}

//__________________________________________________________________________________________________

                                                 // run
void loop() {

      if (serloop == serloopend) 
      {
        serloop = 0; //reset and check ( after serloopend cycles ) if usb has income 
       // by sending one byte from PC Terminal select job from menu
	if (Serial.available() > 0) {        // USB terminal interrupt 
		// read the incoming byte:
            inByte = Serial.read();
                            delay(delayusb);      // wait rest of the string is in buffer 
                            Serial.flush(); // only use first character, skip the rest 
          
            switch (inByte) {

              case 'a': //a   menu entry 
                  menuselect = inByte;

                  Serial.write(inByte);
                  print_ascii(); // show ascii list

                  break;

              case 'd': //d   menu entry 
                  menuselect = inByte;

                  Serial.write(inByte);
                  debugp = !debugp;                          //toggle debug
                  debuga = !debuga;                          //toggle debug
                  if (debugp) {Serial.println(F(" Diag on "));}
                  break;

              case 't': //t
                  menuselect = inByte;

                  Serial.write(inByte);
                  print_time();
                                         if (debugp) {
                                           Serial.print(F("loops: "));
                                           Serial.print(loopcount);
                                           Serial.print(F(" reset: "));
                                           Serial.println(loopreport);
                                              } // if debug
              break;

              case 's': //s show variables status
                  menuselect = inByte;

                  Serial.write(inByte);
                 // Serial.println("actual settings: ");
                  print_time();
                  Serial.print(F("loops: "));
                  Serial.print(loopcount);
                  Serial.print(F(" reset: "));
                  Serial.println(loopreport);
                  
                  Serial.print(" 1 ");
                  if (exec1conti) {Serial.print(ONs);}else{Serial.print(OFs);}
                  Serial.print(exec1count);                  
                  Serial.print(" 2 ");
                  if (exec2conti) {Serial.print(ONs);}else{Serial.print(OFs);}
                  Serial.print(exec2count);                  
                  Serial.print(" 3 ");
                  if (exec3conti) {Serial.print(ONs);}else{Serial.print(OFs);}
                  Serial.print(exec3count);                  
                  Serial.print(" 4 ");
                  if (exec4conti) {Serial.print(ONs);}else{Serial.print(OFs);}
                  Serial.print(exec4count);                  
                  Serial.print(" 5 ");
                  if (exec5conti) {Serial.print(ONs);}else{Serial.print(OFs);}
                  Serial.print(exec5count);                  
                  Serial.print(" 6 ");
                  if (exec6conti) {Serial.print(ONs);}else{Serial.print(OFs);}
                  Serial.print(exec6count);                  
                  Serial.print(" 7 ");
                  if (exec7conti) {Serial.print(ONs);}else{Serial.print(OFs);}
                  Serial.print(exec7count);                  
                  Serial.print(" 8 ");
                  if (exec8conti) {Serial.print(ONs);}else{Serial.print(OFs);}
                  Serial.print(exec8count);                  
                  Serial.print(" 9 ");
                  if (exec9conti) {Serial.print(ONs);}else{Serial.print(OFs);}
                  Serial.println(exec9count);
//                  Serial.print("exectim: ");
//                  Serial.println(exectim);

//                  Serial.print("serlim: ");
//                  Serial.print(serloopend);
//                  Serial.print(" serloop: ");
//                  Serial.println(serloop);

                  //Serial.print("last select: ");   // well thats "s"
                  //Serial.println(menuselect, BYTE);                  

              break;

              case 'c':                                    //c   get data for OSCI ZOOM analog channel
                menuselect = inByte;
                //Serial.write(inByte);
                   
                   zoomchannel = get_set_value("",0,0);
                   if (( zoomchannel > 5 ) || ( zoomchannel < 0 )) { zoomchannel = 0; }

              break;

              case 'z':                                    //z   get data for OSCI ZOOM
                menuselect = inByte;
                // Serial.write(inByte);  // not report to processing
                  get_zoom();
              break;

              case '0': //0   reset
                  menuselect = inByte;

              //    Serial.write(inByte); not send to prozessing
                    exec1conti = false;
                    exec2conti = false;
                    exec3conti = false;
                    exec4conti = false;
                    exec5conti = false;
                    exec6conti = false;
                    exec7conti = false;
                    exec8conti = false;
                    exec9conti = false;
                    
                    debugp = false; 
                    debuga = false; 
                    loopcount = 0;
                    exec1count = 0;
                    exec2count = 0;
                    exec3count = 0;
                    exec4count = 0;
                    exec5count = 0;
                    exec6count = 0;
                    exec7count = 0;
                    exec8count = 0;
                    exec9count = 0;
                    menuselect = 58; //":"
                    
                      samplecount = 0;
/*
                      A0Y = 0.0;
                      A1Y = 0.0;
                      A2Y = 0.0;
                      A3Y = 0.0;
                      A4Y = 0.0;
                      A5Y = 0.0;
 */                     
                                                            // reset outputs  

                  break;


              case '1': //1                                    EMON
                  menuselect = inByte;
                  exec1count = 0; //reset
                  exec1conti = true;

                  Serial.write(inByte);

                  Serial.println(F("Ix, W , VA , p , Vrms , Irms"));
                                                                // EMON
              break;

              case '2': //2    
                  menuselect = inByte;
                  exec2count = 0; //reset
                  exec2conti = true;

                  Serial.write(inByte);


                  break;

              case '3': //3                                                    show Ains
                  menuselect = inByte;
                  exec3count = 0; //reset
                  exec3conti = !exec3conti;    // toggle

                  Serial.write(inByte);


                  break;

              case '4': //4                                                
                  menuselect = inByte;
                  exec4count = 0; //reset
                  exec4conti = true;   

                  Serial.write(inByte);

              break;

              case '5': //5                                             start OSCI function
                  menuselect = inByte;
                  exec5count = 0; //reset
                  exec5conti = true;
                  
                  exec1conti = false;  // disable EMON
                  exec9conti = false;  // disable ameasure
                                                              // at processing send '0' null reversed
                 // Serial.write(inByte);    not send to processing
                                                
              break;

              case '6': //6 
                  //conti volt recorder from POTI and PWM output to LED
                  menuselect = inByte;
                  exec6count = 0; //reset
                  exec6conti = true;

                  Serial.write(inByte);
                  
              break;

              case '7': //7
                  menuselect = inByte;
                  exec7count = 0;                                                   //reset
                  exec7conti = true;

                  Serial.write(inByte);
 

              break;

              case '8': //8                                                      zoom data
                  menuselect = inByte;
                  exec8count = 0; //reset
                  exec8conti = true;
                  Serial.write(inByte);

              break;

              case '9': //9
                  menuselect = inByte;
                  exec9count = 0; //reset
                  exec9conti = true;

//                  Serial.write(inByte);
//                   samplerate = get_set_value("sample# ( 1001): ",1001,0);
                   
              break;

              default:
                  menuselect = 58; //":" so any character from USB stops running menutask selected prior
                  print_menu();
                  
                          } // end switch keyboard entry
                
                        } // end serial available USB Terminal Interrupt
                     
                     } // serloop = serloopend








            // main RUN of CONTI JOBS ( semi parallel )
 
              if ( exec1conti )                                          // JOB1
              {
                 if (exec1count == 0)
                 { // 1
                   
                   emon();                   // call  EMON 
                   inPinI = inPinI + 1;
                   if (inPinI == inPinIlim+1 ) {inPinI = 1;}
                   
                 }                 
                 exec1count = exec1count +1;
                 if (exec1count == exec1tim) { exec1count = 0; }
              }                                                                 // end if conti true

              if ( exec2conti )                                          // JOB2
              {
                 if (exec2count == 0)
                 { // 2

                 }                 
                 exec2count = exec2count +1;
                 if (exec2count == exec2tim) { exec2count = 0; }                 // job timer
              }                                                                 // end if conti true

              if ( exec3conti )                                          // JOB3
              {
                 if (exec3count == 0)
                 { // 3
                 show_Ameasure('u');
                   
                 }                 
                 exec3count = exec3count +1;
                 if (exec3count == exec3tim) { exec3count = 0; }                 // job timer
              }                                                                 // end if conti true

              if ( exec4conti )                                          // JOB4
              {
                 if (exec4count == 0)
                 { // 4
                 
                 }                 
                 exec4count = exec4count +1;
                 if (exec4count == exec4tim) { exec4count = 0; }                 // job timer
              }                                                                 // end if conti true

              if ( exec5conti )                                          // JOB5  processing OSCI
              {
                 if (exec5count == 0)
                 { //5
                     for (int i=0;i<6;i++){
                                if ( i < channels ) {
                                Serial.print(analogRead(i)-OFFSET);
                                } else {
                                Serial.print('0');      
                                }
                                Serial.print(",");
                                       }
                     Serial.println();
                 
                 }                 
                 exec5count = exec5count +1;
                 if (exec5count == exec5tim) { exec5count = 0; }                 // job timer
              }                                                                 // end if conti true

              if ( exec6conti )                                          // JOB6
              {
                 if (exec6count == 0)
                 { // 6
                 
                 }                 
                 exec6count = exec6count +1;
                 if (exec6count == exec6tim) { exec6count = 0; }                 // job timer
              }                                                                 // end if conti true

              if ( exec7conti )                                          // JOB7
              {
                 if (exec7count == 0)
                 { // 7

                 }
                 exec7count = exec7count +1;
                 if (exec7count == exec7tim) { exec7count = 0; }                 // job timer

                 }                                                                 // end if conti true


              if ( exec8conti )                                          // JOB8
              {
                 if (exec8count == 0)
                 { //8
                 
                 }                 
                 exec8count = exec8count +1;
                 if (exec8count == exec8tim) { exec8count = 0; }                 // job timer
              }                                                                 // end if conti true

              if ( exec9conti )                                          // JOB9
              {
                 if (exec9count == 0)
                 { // 9             samplerate adjust

                 }                 
                 exec9count = exec9count +1;
                 if (exec9count == samplerate) { exec9count = 0; }                 // job timer
              }                                                                 // end if conti true
                  
                  
                  loopcount = loopcount + 1;                                     // for check cycle time
                  serloop = serloop + 1;                                         // for check on USB 

                  if ( loopcount == loopreport ) {                               // of 4 294 967 295 unsigned long
                                                  loopcount = 0;                 // reset


                                                  if (debugp) { print_time(); }  // if debug
                                                } // end if loopcount
                                       
     } // end loop
     
