/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino;

import processing.core.PApplet;
import processing.serial.Serial;

public class Arduino {
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    public static final int ANALOG = 2;
    public static final int PWM = 3;
    public static final int SERVO = 4;
    public static final int SHIFT = 5;
    public static final int I2C = 6;
    public static final int LOW = 0;
    public static final int HIGH = 1;
    private final int MAX_DATA_BYTES = 32;
    private final int DIGITAL_MESSAGE = 144;
    private final int ANALOG_MESSAGE = 224;
    private final int REPORT_ANALOG = 192;
    private final int REPORT_DIGITAL = 208;
    private final int SET_PIN_MODE = 244;
    private final int REPORT_VERSION = 249;
    private final int SYSTEM_RESET = 255;
    private final int START_SYSEX = 240;
    private final int END_SYSEX = 247;
    PApplet parent;
    Serial serial;
    SerialProxy serialProxy;
    int waitForData = 0;
    int executeMultiByteCommand = 0;
    int multiByteChannel = 0;
    int[] storedInputData = new int[32];
    boolean parsingSysex;
    int sysexBytesRead;
    int[] digitalOutputData = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    int[] digitalInputData = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    int[] analogInputData = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    int majorVersion = 0;
    int minorVersion = 0;

    public void dispose() {
        this.serial.dispose();
    }

    public static String[] list() {
        return Serial.list();
    }

    public Arduino(PApplet parent, String iname) {
        this(parent, iname, 57600);
    }

    public Arduino(PApplet parent, String iname, int irate) {
        int i;
        this.parent = parent;
        this.serialProxy = new SerialProxy();
        this.serial = new Serial((PApplet)this.serialProxy, iname, irate);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        for (i = 0; i < 6; ++i) {
            this.serial.write(0xC0 | i);
            this.serial.write(1);
        }
        for (i = 0; i < 2; ++i) {
            this.serial.write(0xD0 | i);
            this.serial.write(1);
        }
        parent.registerDispose((Object)this);
    }

    public int digitalRead(int pin) {
        return this.digitalInputData[pin >> 3] >> (pin & 7) & 1;
    }

    public int analogRead(int pin) {
        return this.analogInputData[pin];
    }

    public void pinMode(int pin, int mode) {
        this.serial.write(244);
        this.serial.write(pin);
        this.serial.write(mode);
    }

    public void digitalWrite(int pin, int value) {
        int portNumber = pin >> 3 & 0xF;
        if (value == 0) {
            int n = portNumber;
            this.digitalOutputData[n] = this.digitalOutputData[n] & ~(1 << (pin & 7));
        } else {
            int n = portNumber;
            this.digitalOutputData[n] = this.digitalOutputData[n] | 1 << (pin & 7);
        }
        this.serial.write(0x90 | portNumber);
        this.serial.write(this.digitalOutputData[portNumber] & 0x7F);
        this.serial.write(this.digitalOutputData[portNumber] >> 7);
    }

    public void analogWrite(int pin, int value) {
        this.pinMode(pin, 3);
        this.serial.write(0xE0 | pin & 0xF);
        this.serial.write(value & 0x7F);
        this.serial.write(value >> 7);
    }

    private void setDigitalInputs(int portNumber, int portData) {
        this.digitalInputData[portNumber] = portData;
    }

    private void setAnalogInput(int pin, int value) {
        this.analogInputData[pin] = value;
    }

    private void setVersion(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    private int available() {
        return this.serial.available();
    }

    private void processInput() {
        int inputData = this.serial.read();
        if (this.parsingSysex) {
            if (inputData == 247) {
                this.parsingSysex = false;
            } else {
                this.storedInputData[this.sysexBytesRead] = inputData;
                ++this.sysexBytesRead;
            }
        } else if (this.waitForData > 0 && inputData < 128) {
            --this.waitForData;
            this.storedInputData[this.waitForData] = inputData;
            if (this.executeMultiByteCommand != 0 && this.waitForData == 0) {
                switch (this.executeMultiByteCommand) {
                    case 144: {
                        this.setDigitalInputs(this.multiByteChannel, (this.storedInputData[0] << 7) + this.storedInputData[1]);
                        break;
                    }
                    case 224: {
                        this.setAnalogInput(this.multiByteChannel, (this.storedInputData[0] << 7) + this.storedInputData[1]);
                        break;
                    }
                    case 249: {
                        this.setVersion(this.storedInputData[1], this.storedInputData[0]);
                    }
                }
            }
        } else {
            int command;
            if (inputData < 240) {
                command = inputData & 0xF0;
                this.multiByteChannel = inputData & 0xF;
            } else {
                command = inputData;
            }
            switch (command) {
                case 144: 
                case 224: 
                case 249: {
                    this.waitForData = 2;
                    this.executeMultiByteCommand = command;
                }
            }
        }
    }

    public class SerialProxy
    extends PApplet {
        public SerialProxy() {
            this.disposeMethods = new PApplet.RegisteredMethods((PApplet)this);
        }

        public void serialEvent(Serial which) {
            while (Arduino.this.available() > 0) {
                Arduino.this.processInput();
            }
        }
    }
}

