/*
 * Decompiled with CFR 0.152.
 */
package arduinoscope;

import processing.core.PApplet;
import processing.core.PConstants;

public class Oscilloscope
implements PConstants {
    PApplet myParent;
    public final String VERSION = "0.1.0";
    private int[] pos = new int[2];
    private int[] dim = new int[2];
    private int line_color;
    private int bounds_color;
    private int[] logic_colors = new int[2];
    private int[] values;
    private float resolution;
    private float multiplier;
    private int minval;
    private int maxval;
    private boolean logic;
    private boolean pause;

    public int[] getPos() {
        return this.pos;
    }

    public void setPos(int[] nArray) {
        this.pos = nArray;
    }

    public int[] getDim() {
        return this.dim;
    }

    public void setDim(int[] nArray) {
        this.dim = nArray;
        this.values = new int[nArray[0]];
    }

    public int getLine_color() {
        return this.line_color;
    }

    public void setLine_color(int n) {
        this.line_color = n;
    }

    public int getBounds_color() {
        return this.bounds_color;
    }

    public void setBounds_color(int n) {
        this.bounds_color = n;
    }

    public int[] getLogic_colors() {
        return this.logic_colors;
    }

    public void setLogic_colors(int[] nArray) {
        this.logic_colors = nArray;
    }

    public int[] getValues() {
        return this.values;
    }

    public void setValues(int[] nArray) {
        this.values = nArray;
    }

    public float getResolution() {
        return this.resolution;
    }

    public void setResolution(float f) {
        this.resolution = f;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(float f) {
        this.multiplier = f;
    }

    public int getMinval() {
        return this.minval;
    }

    public void setMinval(int n) {
        this.minval = n;
    }

    public int getMaxval() {
        return this.maxval;
    }

    public void setMaxval(int n) {
        this.maxval = n;
    }

    public boolean isLogicMode() {
        return this.logic;
    }

    public void setLogicMode(boolean bl) {
        this.logic = bl;
    }

    public boolean isPause() {
        return this.pause;
    }

    public void setPause(boolean bl) {
        this.pause = bl;
    }

    public Oscilloscope(PApplet pApplet, int[] nArray, int[] nArray2) {
        this.myParent = pApplet;
        this.bounds_color = this.myParent.color(30);
        this.resolution = 1024.0f;
        this.multiplier = 5.0f;
        this.logic = false;
        this.pause = false;
        this.pos = nArray;
        this.dim = nArray2;
        this.line_color = this.myParent.color(255, 255, 255);
        this.logic_colors[0] = this.myParent.color(255, 0, 0);
        this.logic_colors[1] = this.myParent.color(0, 255, 0);
        this.minval = (int)this.resolution;
        this.values = new int[this.dim[0]];
    }

    public String version() {
        return "0.1.0";
    }

    public void draw() {
        if (!this.logic) {
            this.myParent.stroke(this.line_color);
        }
        for (int i = 1; i < this.dim[0]; ++i) {
            if (this.logic) {
                if ((float)this.values[i] > this.resolution / 2.0f) {
                    this.myParent.stroke(this.logic_colors[1]);
                } else {
                    this.myParent.stroke(this.logic_colors[0]);
                }
                this.myParent.line((float)(this.pos[0] + this.dim[0] - i - 2), (float)this.pos[1], (float)(this.pos[0] + this.dim[0] - i - 2), (float)(this.pos[1] + this.dim[1]));
                continue;
            }
            this.myParent.line((float)(this.pos[0] + this.dim[0] - i), (float)(this.pos[1] + this.dim[1] - this.getY(this.values[i - 1]) - 1), (float)(this.pos[0] + this.dim[0] - i), (float)(this.pos[1] + this.dim[1] - this.getY(this.values[i]) - 1));
        }
    }

    public void drawBounds() {
        this.myParent.stroke(this.bounds_color);
        this.myParent.line((float)this.pos[0], (float)(this.pos[1] + this.dim[1] / 2), (float)this.dim[0], (float)(this.pos[1] + this.dim[1] / 2));
    }

    public void addData(int n) {
        if (!this.pause) {
            for (int i = 0; i < this.dim[0] - 1; ++i) {
                this.values[i] = this.values[i + 1];
            }
            this.values[this.dim[0] - 1] = n;
            if (n < this.minval) {
                this.minval = n;
            }
            if (n > this.maxval) {
                this.maxval = n;
            }
        }
    }

    public void saveData(String string) {
        String[] stringArray = new String[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            stringArray[i] = "" + this.values[i];
        }
        this.myParent.saveStrings(string, stringArray);
    }

    private int getY(int n) {
        return (int)((float)n / this.resolution * (float)this.dim[1]) - 1;
    }
}

