
public void controlEvent(ControlEvent theEvent) {   // handles button clicks
  int id = theEvent.controller().id();
    // println("got a control event from controller with id "+id);

  // button families are in chunks of 50 to avoid collisions

  if (id < 50){
    scopes[id].setPause(!scopes[id].isPause());
  }else if (id < 100){
    scopes[id-50].setLogicMode(!scopes[id-50].isLogicMode());
  }else if(id < 150){
    String fname = "data"+(id-100)+".csv";
    scopes[id-100].saveData(fname);   // ends up at mydocuments processing projectdir ???
    println("Saved as "+fname);
  } else if (id < 200){                // zoom button per channel id =150 .. 155

     port.write('0');                  // menu select reset 
     delay(50);   
     port.write('c');                  // menu select channel
     delay(50); 
   if (id==150){ zchannel='0'; }    // menu select channel A0
   if (id==151){ zchannel='1'; }    // menu select channel A1
   if (id==152){ zchannel='2'; }    // menu select channel A2
   if (id==153){ zchannel='3'; }    // menu select channel A3
   if (id==154){ zchannel='4'; }    // menu select channel A4
   if (id==155){ zchannel='5'; }    // menu select channel A5

//     println("zoom"+zchannel);  
     port.write(zchannel);
     delay(50);        
     port.write('z');                  // to arduino to send zoom data
       batchmode=true;
 //      PFrame f = new PFrame();        // for batch window  MOVED BEHIND ENDBATCH

  } // end channel zoom buttons  

}  // end control event (button)

// handle serial data
void serialEvent(Serial p) { 
  String data = p.readStringUntil(LINE_FEED);
  if (data != null) {
                         if ( debugd ) {  println(data); }
        if (!batchmode){ // data go scope window
        //    vals  = int(split(data, ','));
        int[] tempVals  = int(split(data, ','));
        if(tempVals.length>=scopes.length) {
          vals = tempVals;
          loopcount = loopcount +1;
                  if ( loopcount == loopend ) {
                            loopcount = 0;
                            actmillis=millis();
                            deltamillis=actmillis-oldmillis;
                            samplerate=int(float(loopend)*1000/deltamillis);
           if ( debugp ) { println("samplerate: " + samplerate + " Hz"); }
                            oldmillis = actmillis;
                            } // end loopend ( 1000 samples from serial interface )

              }  else { println("Warning: Dropped a short packet."); }
      
      
              } else {  // batch read
                        // batchmode == true
            if ( batchdata == true ) { // get 64 lines data from arduino and wait for "endbatch" text                                        
             String[] m2 = match(data, "endbatch");
                if (m2 != null) {   // found "endbatch"
                  print("endbatchdata: ");
                // now there is more info in that line,
                                   //println(data);
                                   int[] tempVals  = int(split(data, ','));
                                   //println(tempVals[0]);
                                    print(" channel: "); print(tempVals[2]);   // reported from arduino
                                    print(" millis: "); print(tempVals[1]);    // reported from arduino
                                    print(" Hz: ");
                                   zsamplerate=int(512000/float(tempVals[1])); // calc local again
                                   print(zsamplerate); println();
                                   batchdata = false;
                                   batchmode = false; 
                                   zline=0;
                                   showbatch = true;
                                   //if ( debugd ) { 
                                   
                                   //} 
                                   
                                   

                                   
                                   PFrame f = new PFrame();        // for batch window as oneshot

                                       } // not found
                                        } // end look for "endbatch"

              if (batchdata) {

                    int[] tempVals  = int(split(data, ','));  // 64 * 8 values  = 512
                    
                    for (int i=0;i<8;i++){  zoomarray[i+zline]=tempVals[i]; }
//                    for (int i=0;i<8;i++){  zoomarray[i+zline]=( tempVals[i] + 128 )*4; }  // arduino send Ain (0 ..1023) / 4 -128 stored as byte, send as ASCII 
                    zline = zline + 8;   // 8 integer per line in 64 lines 
                                               if ( debugd ) { 
                                               print(zline);
                                               print(": ");
                                               println(data); 
                                                }       
                              } // end batchdata line / save to local array
              
            // batchmode == true
            if ( batchdata == false ) { // after "z" for about 200 lines wait / look for text "startbatch" from arduino
             String[] m1 = match(data, "startbatch");
               if (m1 != null) {   // found "startbatch"
                                   batchdata = true; 
                                   // if ( debugd ) { 
                                   println("batchdata: "); // 
                                   //} 
                                        }
                                          } // batchmode true and batchdata false

                     } // end batch read       

              }  // end if not 0 data
              
}  // end serial event

void keyPressed() {                    // for send zoom channel number to arduino  0 .. 5
/*
  if (key >= '0' && key <= '5') {
     port.write('c');                  // menu select for Ain channel select inside arduino
     delay(250);   
     port.write(key);
         print("send c"); 
         println(key);
     zchannel=key; 
     delay(250);
                                } else {}
   // delaytime                             

  if ( key == '+' ){ 
                    port.write(key);
                    delaytime=delaytime + 2; // remember for local indication 
                  }
 
  if ( key == '-' ){ 
                    port.write(key); 
                    delaytime=delaytime - 1; // remember for local indication
                   if ( delaytime < 0 ){ delaytime = 0;}   //limit 
                   }
*/
  if ( key == 'd' ){ // toggle diagnostic print of data
                     debugd = !debugd; }
                     
  if ( key == 'T' ){ // toggle diagnostic ZOOM data

                          port.write('T');                  // menu select reset 
                          delay(50);   
 }
/*
  if ( key == 'z' ){ // goto zoom mode
     port.write('0');                  // menu stop all
     delay(250);   
       port.write('z');  // send to arduino
       batchmode=true;
       PFrame f = new PFrame();     // for batch window

                   } // end zoom mode
*/                     
}


void stop()
{
  // always close Minim audio classes when you finish with them
  // minim.stop();
  
  super.stop();
}



