// Ver 3.2 KLL 30.9.2013
// Ver 3.2.RPI KLL 20.11.2013
//not serial, only read data from file ( written by python )
// framerate(2)     results in 1 frame in 18 sec ( 100% load )

// check on the SAVE button of processing
// give new name for 3 button: save0, save1, save2
// now stores in /data/ as data0.csv, data1.csv, data2.csv.

// setup send "c" not work, keyboard c OK  

// channel button "B" works like A0A1A2, A0A2A2, A0A3A2, A0A4A2, A0A5A2, A0A0A2,
// changed to send a "C" for PMS3 version works like A0A1A2, A0A1A3, A0A1A4, A0A1A5, A0A1A0, A0A1A1,
// Ver 3.2b
// the div lines 1 px wrong and on top of graph??
// new scope size and first black lines then scope data.
// use multiplier and resolution of ardoino scope class

// PMS3 PoorManScope KLL 17.9.2013
// 3 channel
// exchange P5 lib with 2.0.4 version
//  http://www.sojamo.de/libraries/controlP5/download/controlP5-2.0.4.zip
// test with PMS3 V3.1

//old
// PMS2 PoorManScope KLL 15.7.2012
// on ARDUINO UNO (AVR) and chipKIT MAX32 (PIC)

// check same in arduino sketch
//  
final static int ARRAYlong=360;    // 360 max for UNO  PMS2, 256 for POWER_METER_TOOLBOX  

// see dir [code]
import arduinoscope.*;              //   (c) 2009 David Konsumer <david.konsumer@gmail.com>
//import processing.serial.*;
// see dir [code]
import controlP5.*;                 // http://www.sojamo.de/libraries/controlP5/

PFont fontLarge;
PFont fontSmall;
int[] vals;

import cc.arduino.*;

int multiscope = 3;  
int ldelta =0; // black lines for 1V/dev

// ARDUINO UNO , MEGA
float Vrange =5.0; // Volt for UNO...
int Vlines = 5;    // divs for UNO data

// MAX32
//float Vrange =6.6; // Volt for MAX32 3v3 with voltage divider 10k 10k
//int Vlines = 7;    // used for number of division lines AND for multiplier calc

float Vresolution = 1023*Vlines/Vrange;

//int channels=2;
//int delaytime = 6;    // ARDUINO start value
Oscilloscope[] scopes = new Oscilloscope[multiscope];  // 
//Serial port;
int LINE_FEED=10; 

ControlP5 controlP5;                          // for buttons...

// Arduino arduino;                              // NO firmata

color off = color(4, 79, 111);
color on = color(184, 145, 0);


boolean debugd=false; // show income data.. diagnostic  // as there is the chartline off problem

int[] ser0array = new int[ARRAYlong];
int[] ser1array = new int[ARRAYlong];
int[] ser2array = new int[ARRAYlong];
int linecount=0;

// get the arduino sample info
int channela,channelb,channelc,samples,sampletime,hz;



void setup() {
  // size must be first line!!
//  size(ARRAYlong+130, 520);    // 
  size(ARRAYlong+130, 534);    // 


  controlP5 = new ControlP5(this);
  
  // set these up under tools/create font, if they are not setup.
  fontLarge = loadFont("TrebuchetMS-20.vlw");
  fontSmall = loadFont("Uni0554-8.vlw");

  vals = new int[multiscope];
  
  int[] dimv = new int[2];
  dimv[0] = width-130;                    // 130 margin for text
  dimv[1] = (height-30)/multiscope;       // for scope area
  
    for (int i=0;i<multiscope;i++){
          int[] posv = new int[2];
          posv[0]=0;
          posv[1]=dimv[1]*i+30; // shift down for header area

    // random color, that will look nice and be visible
    scopes[i] = new Oscilloscope(this, posv, dimv);   
    scopes[i].setLine_color(color((int)random(255), (int)random(127)+127, 255));
//    scopes[i].setMultiplier(Vrange);
    scopes[i].setMultiplier(Vlines);
    scopes[i].setResolution(Vresolution);

   }

// scopes
//    controlP5.addButton("save0",1,dimv[0]+92,dimv[1]*0+30+10,29,20).setId(0+100);
    
//    controlP5.addButton("save1",1,dimv[0]+92,dimv[1]*1+30+10,29,20).setId(1+100);
    
//    controlP5.addButton("Channel",1,dimv[0]+10,dimv[1]*2+30+10,40,20).setId(200);  
//    controlP5.addButton("save2",1,dimv[0]+92,dimv[1]*2+30+10,29,20).setId(2+100);    

 // header line
//    controlP5.addButton("slow",1,85,5,25,20).setId(202);   
//    controlP5.addButton("fast",1,180,5,25,20).setId(203);   

//    controlP5.addButton("diag",1,230,5,25,20).setId(201);   

//  println(Serial.list());                                             // kll
//  port = new Serial(this, Serial.list()[0], 115200);                    // kll 
  // clear and wait for linefeed
  //delay(500);
//  port.write('c'); // 'c'=99 stop sending chart if on, only data // NOT WORK ANY MORE??
  //port.write(13);  //CR
//  port.clear();
//  port.bufferUntil(LINE_FEED);
    frameRate(2);
    noLoop();
}

void draw() {
  read_python_file();
  background(off);
  stroke(on);
  
  float minval=0.0,maxval=0.0;
    
  textFont(fontSmall);  
  fill(255);
//  text("key operation: channel select B, speed  + - , diag d",10,20);
  
//  text( str(day())+ "." + str(month()) + "." + str(year()) + " " + str(hour()) + ":" + str(minute()) + ":" + str(second())  , width-120, 20 ); 

  text(hz+"Hz  FOR UPDATE press [SPACE]",120,20);

// check:   (520-30)/(3*7) = 23.333, change to 534 pix height
   ldelta = (height-30)/(multiscope*Vlines) ; //pixel / 1 volt
   // show 3 scope with Ain from ARDUINO
   for (int i=0;i<multiscope;i++){
    // add lines
    // scopes[i].drawBounds();
    // we show a 5 Volt signal, so need 4 line ( 1 V / dev )
    int[] pos = scopes[i].getPos();
    int[] dim = scopes[i].getDim();
    stroke(0);                          // black lines for 1 V dev
    for (int k=1;k < Vlines;k++){
        line(0, pos[1]+k*ldelta, dim[0], pos[1]+k*ldelta);
                                }
    stroke(255);                        // white line for scope (top)
        line(0, pos[1], width, pos[1]);
    
    // we show a 5 Volt signal, so need 4 black line ( 1 V / dev )  UNO
    // we show a 6v6 Volt signal, so need 6 black lines ( 1V /div ) MAX32 with 10k 10k voltage divider

     // update and draw scopes
   // vals[i] = arduino.analogRead(i); no firmata , see serial event for data income
    
//    scopes[i].addData(vals[i]);  // a
// arduino send 360 records batch now
    if ( i == 0 ) { scopes[i].setValues(ser0array); } // 
    if ( i == 1 ) { scopes[i].setValues(ser1array); } // 
    if ( i == 2 ) { scopes[i].setValues(ser2array); } // 

    scopes[i].draw();
    
    // conversion multiplier for voltage
    float multiplier = scopes[i].getMultiplier()/scopes[i].getResolution();
//multiplier0.0064453124                   print("multiplier");println(multiplier);
//scopes[i].getMultiplier()6.6             print("scopes[i].getMultiplier()");println(scopes[i].getMultiplier());
//scopes[i].getResolution()1024.0          print("scopes[i].getResolution()");println(scopes[i].getResolution());

    // convert arduino vals to voltage
//    float minval = scopes[i].getMinval() * multiplier;
//    float maxval = scopes[i].getMaxval() * multiplier;
    if ( i == 0 ) { 
    minval = min(ser0array) * multiplier;
    maxval = max(ser0array) * multiplier;
    }
    if ( i == 1 ) { 
    minval = min(ser1array) * multiplier;
    maxval = max(ser1array) * multiplier;  
    } 
    if ( i == 2 ) { 
    minval = min(ser2array) * multiplier;
    maxval = max(ser2array) * multiplier;  
    } 
    int[] values = scopes[i].getValues(); 
    float pinval =  values[values.length-1] * multiplier;
    
    
    // add labels
    fill(255);
    textFont(fontLarge);
    text(pinval, width-60, pos[1] + dim[1] - 10);
    
    textFont(fontSmall);   
    text("max: " + maxval, dim[0] + 10, pos[1] + 40);
    text("min: " + minval, dim[0] + 10, pos[1] + 52);
    
    textFont(fontLarge);                           // kll to small can not read anything
    fill(scopes[i].getLine_color());
    // Cx useless , show An here
//  text("A"+channela+"A"+channelb+"A"+channelc,55,20);

    if ( i==0) { text("A" + channela, dim[0] + 10,pos[1] + dim[1] - 10); }
    if ( i==1) { text("A" + channelb, dim[0] + 10,pos[1] + dim[1] - 10); }
    if ( i==2) { text("A" + channelc, dim[0] + 10,pos[1] + dim[1] - 10); }

  }
  
  // draw text seperator, based on first scope
  int[] dim = scopes[0].getDim();
  stroke(255);
  line(dim[0], 0, dim[0], height);
  
// end scope
 
   // update buttons
  controlP5.draw();        
 
} // end draw



public void controlEvent(ControlEvent theEvent) {   // handles button clicks
  int id = theEvent.controller().id();
    // println("got a control event from controller with id "+id);

  // button families are in chunks of 50 to avoid collisions

  if (id < 50){
//    scopes[id].setPause(!scopes[id].isPause());
  }else if (id < 100){
//    scopes[id-50].setLogicMode(!scopes[id-50].isLogicMode());
  }else if(id < 150){
//    String fname = "/data/data"+(id-100)+".csv";
//    scopes[id-100].saveData(fname);   // ends up at mydocuments processing projectdir ???
//    println("Saved as "+fname);
  }
//     if (id==200){ // channel button for C2 only
//                   port.write("B");  // channelb change   FOR PMS2
//                   port.write("C");  // channelc change   FOR PMS3
//                  }

//      if (id==201){ // debug
//                   debugd = !debugd;
//                  }
//      if (id==202){ // slow
//                    port.write("+");
//                    delaytime=delaytime + 1; // remember for local indication 
//                  }
//      if (id==203){ // fast
//                    port.write("-"); 
//                    delaytime=delaytime - 1; // remember for local indication
//                   if ( delaytime < 0 ){ delaytime = 0;}   //limit 
//
//                 }
// 
}  // end control event (button)


// handle serial data


// MOD for linux processing2.1 where readStringUntil(int) does not exist // back 2.0.3
/*
void serialEvent(Serial p) { 
  String data = p.readStringUntil(LINE_FEED);
//  byte temp[] = p.readBytesUntil('\n');
//  if (temp == null) { String data = null; } else { String data = String(temp); }
  
  if (data != null) {
                         if ( debugd ) {  print(data); }

        int[] tempVals  = int(split(data, ','));

        if(tempVals.length == multiscope+1 ) { vals = tempVals; 
                                             ser0array[linecount]=vals[0]; //if ( debugd ) {  print("_"); print(ser0array[linecount]); }
                                             ser1array[linecount]=vals[1]; //if ( debugd ) {  print("_"); print(ser1array[linecount]); }
                                             ser2array[linecount]=vals[2]; //if ( debugd ) {  print("_"); print(ser2array[linecount]); }
                                             linecount=linecount+1;
                                             if ( linecount > ARRAYlong-1 ) { linecount = 0; }
                                            }  else {  // too short or too long
                                                        
if ( tempVals.length > 15 ) {   // info from sampling:
                                // ,,channela,0,channelb,1,channelc,2,sampletimemsec,48,samples,400,samplefreq,8307,Hz,

 //     println(data);  
  channela = tempVals[3];
  channelb = tempVals[5];
  channelc = tempVals[7];
  sampletime = tempVals[9];
  samples = tempVals[11];
  hz = tempVals[13];

  linecount = 0;  // trigger right
  if ( debugd ) {  print("arrayend"); }
}  // if long info line
                                                                      } // too short or long  
      //if ( debugd ) {  println(); }
              }  // end if not 0 data
              
}  // end serial event
*/
void read_python_file() {
    linecount = 0;
    String linesc[] = loadStrings("/run/shm/current.txt");     // first read the filename from the pointer info
    String currentfile = linesc[0];
    println(currentfile); 
    String linesd[] = loadStrings(currentfile);     // read last batchfile
    println("there are " + linesd.length + " lines");
    for (int i = 0 ; i < linesd.length; i++) {  
        //println(linesd[i]);  
        int[] tempVals  = int(split(linesd[i], ','));
        if(tempVals.length == multiscope+1 ) { 
                    vals = tempVals; 
                    ser0array[linecount]=vals[0]; //if ( debugd ) {  print("_"); print(ser0array[linecount]); }
                    ser1array[linecount]=vals[1]; //if ( debugd ) {  print("_"); print(ser1array[linecount]); }
                    ser2array[linecount]=vals[2]; //if ( debugd ) {  print("_"); print(ser2array[linecount]); }
                    linecount=linecount+1;
                    if ( linecount > ARRAYlong-1 ) { linecount = 0; }
                                            }  else {  // too short or too long
                    if ( tempVals.length > 15 ) {   // ,,channela,0,channelb,1,channelc,2,sampletimemsec,48,samples,400,samplefreq,8307,Hz,
                              channela = tempVals[3];
                              channelb = tempVals[5];
                              channelc = tempVals[7];
                              sampletime = tempVals[9];
                              samples = tempVals[11];
                              hz = tempVals[13];
                              linecount = 0;  // trigger right
                              if ( debugd ) {  print("arrayend"); }
                                                }  // if long info line
                                            } // end else
                                    } // 3 values    
} // end read_python_file


void keyPressed() {  // for send channel numbers to arduino 
/*
  if (key == 'B') {                            // PMS2 channel 2 select
                    port.write(key);  
                  }                        
  if (key == 'C') {                            // PMS3 channel 3 select
                    port.write(key);
                  }                        
  if ( key == '+' ){ 
                    port.write(key);
                  }
 
  if ( key == '-' ){ 
                    port.write(key); 
                   }
                   */
  if ( key == 'd' ){ // toggle local diagnostic print of data
                     debugd = !debugd; }
/*                     
  if (key == 'c') {         //works manually
                    port.write(key);
                  }
*/                  
  if (key == ' '){ // update
                      print(" update by [space]\n");
                      //read_python_file();
                      redraw();
                    }
                     
}

