/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.BitFont;
import controlP5.CColor;
import controlP5.CP;
import controlP5.CallbackListener;
import controlP5.Canvas;
import controlP5.ControlBroadcaster;
import controlP5.ControlFont;
import controlP5.ControlKey;
import controlP5.ControlListener;
import controlP5.ControlP5Base;
import controlP5.ControlWindow;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerInterface;
import controlP5.ControllerProperty;
import controlP5.FieldChangedListener;
import controlP5.Tab;
import controlP5.Textfield;
import controlP5.Tooltip;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PVector;
import processing.event.KeyEvent;
import processing.event.MouseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlP5
extends ControlP5Base {
    @Invisible
    public ControlWindow controlWindow;
    public static final CColor RETRO = new CColor(-16750196, -16763310, -16211249, -1, -1);
    public static final CColor CP5BLUE = new CColor(-16683874, -16632755, -16730902, -1, -1);
    public static final CColor RED = new CColor(-5636096, -10092544, -65536, -1, -1);
    public static final CColor WHITE = new CColor(-1711276033, 0x55FFFFFF, -1, -1, -1);
    @Invisible
    static CColor color = new CColor(CP5BLUE);
    @Invisible
    public PApplet papplet;
    @Invisible
    public static final String VERSION = "2.0.3";
    @Invisible
    public static boolean isApplet = false;
    public static final int standard58 = 0;
    public static final int standard56 = 1;
    public static final int synt24 = 2;
    public static final int grixel = 3;
    public static final int J2D = 1;
    public static final int P2D = 2;
    public static final int P3D = 3;
    static int renderer = 1;
    public static boolean DEBUG;
    @Invisible
    public static final Logger logger;
    private Map<String, ControllerInterface<?>> _myControllerMap;
    protected ControlBroadcaster _myControlBroadcaster;
    protected ControlWindow window;
    protected boolean isMoveable = false;
    protected boolean isAutoInitialization = false;
    protected boolean isGlobalControllersAlwaysVisible = true;
    protected boolean isTabEventsActive;
    protected boolean isUpdate;
    protected boolean isControlFont;
    protected ControlFont controlFont;
    protected static final PFont BitFontStandard56;
    protected static final PFont BitFontStandard58;
    protected ControlFont defaultFont = new ControlFont(BitFontStandard58);
    protected ControlFont defaultFontForText = new ControlFont(BitFontStandard56);
    protected boolean isShortcuts = false;
    @Deprecated
    public boolean blockDraw;
    protected Tooltip _myTooltip;
    protected boolean isAnnotation;
    boolean isAndroid = false;
    static int welcome;

    public ControlP5(PApplet pApplet) {
        this.papplet = pApplet;
        this.init();
    }

    public ControlP5(PApplet pApplet, PFont pFont) {
        this.papplet = pApplet;
        this.init();
        this.setFont(pFont);
    }

    public ControlP5(PApplet pApplet, ControlFont controlFont) {
        this.papplet = pApplet;
        this.init();
        this.setFont(controlFont);
    }

    protected void init() {
        renderer = this.papplet.g.getClass().getCanonicalName().indexOf("Java2D") > -1 ? 1 : 3;
        Class<?> clazz = this.papplet.getClass();
        while (clazz != null) {
            if ((clazz = clazz.getSuperclass()) == null || clazz.toString().toLowerCase().indexOf("android.app.") <= -1) continue;
            this.isAndroid = true;
            break;
        }
        this.isTabEventsActive = false;
        this._myControlBroadcaster = new ControlBroadcaster(this);
        this.controlFont = this.defaultFont;
        this.controlWindow = new ControlWindow(this, this.papplet);
        this.papplet.registerMethod("pre", (Object)this);
        this.papplet.registerMethod("dispose", (Object)this);
        this._myControllerMap = new TreeMap();
        this.setFont(this.controlFont);
        this._myTooltip = new Tooltip(this);
        super.init(this);
        if (welcome++ < 1) {
            this.welcome();
        }
        this.mapKeyFor(new ControlKey(){

            public void keyEvent() {
                ControlP5.this.saveProperties();
            }
        }, 18, 16, Character.valueOf('s'));
        this.mapKeyFor(new ControlKey(){

            public void keyEvent() {
                ControlP5.this.loadProperties();
            }
        }, 18, 16, Character.valueOf('l'));
        this.mapKeyFor(new ControlKey(){

            public void keyEvent() {
                if (ControlP5.this.controlWindow.isVisible) {
                    ControlP5.this.hide();
                } else {
                    ControlP5.this.show();
                }
            }
        }, 18, 16, Character.valueOf('h'));
        this.disableShortcuts();
        this.setFont(this.controlFont);
    }

    private void welcome() {
        System.out.println("ControlP5 2.0.3 infos, comments, questions at http://www.sojamo.de/libraries/controlP5");
    }

    public void setTabEventsActive(boolean bl) {
        this.isTabEventsActive = bl;
    }

    public void setAutoInitialization(boolean bl) {
        this.isAutoInitialization = bl;
    }

    public void setAutoDraw(boolean bl) {
        if (this.isAutoDraw() && !bl) {
            this.controlWindow.papplet().unregisterMethod("draw", (Object)this.controlWindow);
        }
        if (!this.isAutoDraw() && bl) {
            this.controlWindow.papplet().registerMethod("draw", (Object)this.controlWindow);
        }
        this.controlWindow.isAutoDraw = bl;
    }

    public boolean isAutoDraw() {
        return this.controlWindow.isAutoDraw;
    }

    public ControlBroadcaster getControlBroadcaster() {
        return this._myControlBroadcaster;
    }

    public ControlP5 addListener(ControlListener ... controlListenerArray) {
        this.getControlBroadcaster().addListener(controlListenerArray);
        return this;
    }

    public ControlP5 removeListener(ControlListener ... controlListenerArray) {
        this.getControlBroadcaster().removeListener(controlListenerArray);
        return this;
    }

    public ControlP5 removeListener(ControlListener controlListener) {
        this.getControlBroadcaster().removeListener(controlListener);
        return this;
    }

    public ControlListener getListener(int n) {
        return this.getControlBroadcaster().getListener(n);
    }

    public ControlP5 addCallback(CallbackListener ... callbackListenerArray) {
        this.getControlBroadcaster().addCallback(callbackListenerArray);
        return this;
    }

    public ControlP5 addCallback(CallbackListener callbackListener) {
        this.getControlBroadcaster().addCallback(callbackListener);
        return this;
    }

    public ControlP5 addCallback(CallbackListener callbackListener, Controller<?> ... controllerArray) {
        this.getControlBroadcaster().addCallback(callbackListener, controllerArray);
        return this;
    }

    public ControlP5 removeCallback(CallbackListener ... callbackListenerArray) {
        this.getControlBroadcaster().removeCallback(callbackListenerArray);
        return this;
    }

    public ControlP5 removeCallback(Controller<?> ... controllerArray) {
        this.getControlBroadcaster().removeCallback(controllerArray);
        return this;
    }

    public ControlP5 removeCallback(Controller<?> controller) {
        this.getControlBroadcaster().removeCallback(controller);
        return this;
    }

    public void addControlsFor(Object object) {
    }

    public Tab getTab(String string) {
        for (int i = 0; i < this.controlWindow.getTabs().size(); ++i) {
            if (!((Tab)this.controlWindow.getTabs().get(i)).getName().equals(string)) continue;
            return (Tab)this.controlWindow.getTabs().get(i);
        }
        Tab tab = this.addTab(string);
        return tab;
    }

    public Tab getTab(ControlWindow controlWindow, String string) {
        for (int i = 0; i < controlWindow.getTabs().size(); ++i) {
            if (!((Tab)controlWindow.getTabs().get(i)).getName().equals(string)) continue;
            return (Tab)controlWindow.getTabs().get(i);
        }
        Tab tab = controlWindow.add(new Tab(this, controlWindow, string));
        return tab;
    }

    public ControlP5 register(Object object, String string, ControllerInterface<?> controllerInterface) {
        String string2 = "";
        if (object == this.papplet) {
            string2 = controllerInterface.getName().startsWith("/") ? "" : "/";
            string2 = string2 + controllerInterface.getName();
        } else {
            string2 = string.length() == 0 || string.startsWith("/") ? "" : "/";
            string2 = string2 + string;
            string2 = string2 + (controllerInterface.getName().startsWith("/") ? "" : "/");
            string2 = string2 + controllerInterface.getName();
        }
        controllerInterface.setAddress(string2);
        if (this.checkName(controllerInterface.getAddress())) {
            this.remove(controllerInterface.getAddress());
        }
        this._myControllerMap.put(controllerInterface.getAddress(), controllerInterface);
        List<ControllerProperty> list = this.getProperties().get(controllerInterface);
        if (list != null) {
            for (ControllerProperty controllerProperty : list) {
                controllerProperty.setAddress(controllerInterface.getAddress());
            }
        }
        controllerInterface.init();
        if (controllerInterface instanceof Controller) {
            if (object == null) {
                object = this.papplet;
            }
            if (!object.equals(this.papplet)) {
                ((Controller)((Controller)controllerInterface).unplugFrom(this.papplet)).plugTo(object);
            }
            if (!this._myObjectToControllerMap.containsKey(object)) {
                this._myObjectToControllerMap.put(object, new ArrayList());
            }
            ((ArrayList)this._myObjectToControllerMap.get(object)).add(controllerInterface);
        }
        return this;
    }

    public List<ControllerInterface<?>> getAll() {
        return new ArrayList(this._myControllerMap.values());
    }

    public <T> List<T> getAll(Class<T> clazz) {
        ArrayList arrayList = new ArrayList();
        for (ControllerInterface<?> controllerInterface : this._myControllerMap.values()) {
            if (controllerInterface.getClass() != clazz && controllerInterface.getClass().getSuperclass() != clazz) continue;
            arrayList.add(controllerInterface);
        }
        return arrayList;
    }

    protected void deactivateControllers() {
        for (Textfield textfield : this.getAll(Textfield.class)) {
            textfield.setFocus(false);
        }
    }

    private String checkAddress(String string) {
        if (!string.startsWith("/")) {
            return "/" + string;
        }
        return string;
    }

    public void printControllerMap() {
        ArrayList<String> arrayList = new ArrayList<String>();
        System.out.println("============================================");
        for (Map.Entry<String, ControllerInterface<?>> object : this._myControllerMap.entrySet()) {
            String string = object.getKey();
            ControllerInterface<?> controllerInterface = object.getValue();
            arrayList.add(string + " = " + controllerInterface);
        }
        Collections.sort(arrayList);
        for (String string : arrayList) {
            System.out.println(string);
        }
        System.out.println("============================================");
    }

    protected void remove(ControllerInterface<?> controllerInterface) {
        this._myControllerMap.remove(controllerInterface.getAddress());
    }

    public void remove(String string) {
        String string2 = this.checkAddress(string);
        if (this.getController(string2) != null) {
            this.getController(string2).remove();
        }
        if (this.getGroup(string2) != null) {
            this.getGroup(string2).remove();
        }
        for (int i = 0; i < this.controlWindow.getTabs().size(); ++i) {
            if (!this.controlWindow.getTabs().get(i).getAddress().equals(string2)) continue;
            this.controlWindow.getTabs().get(i).remove();
        }
        this._myControllerMap.remove(string2);
    }

    public ControllerInterface<?> get(String string) {
        String string2 = this.checkAddress(string);
        if (this._myControllerMap.containsKey(string2)) {
            return this._myControllerMap.get(string2);
        }
        return null;
    }

    public <C> C get(Class<C> clazz, String string) {
        for (ControllerInterface<?> controllerInterface : this._myControllerMap.values()) {
            if (controllerInterface.getClass() != clazz && controllerInterface.getClass().getSuperclass() != clazz) continue;
            return (C)this.get(string);
        }
        return null;
    }

    @Invisible
    public List<ControllerInterface<?>> getList() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.controlWindow.getTabs().get());
        linkedList.addAll(this.getAll());
        return linkedList;
    }

    public float getValue(String string) {
        Controller<?> controller = this.getController(string);
        if (controller != null) {
            return controller.getValue();
        }
        return Float.NaN;
    }

    public Controller<?> getController(String string) {
        String string2 = this.checkAddress(string);
        if (this._myControllerMap.containsKey(string2) && this._myControllerMap.get(string2) instanceof Controller) {
            return (Controller)this._myControllerMap.get(string2);
        }
        return null;
    }

    public ControllerGroup<?> getGroup(String string) {
        String string2 = this.checkAddress(string);
        if (this._myControllerMap.containsKey(string2) && this._myControllerMap.get(string2) instanceof ControllerGroup) {
            return (ControllerGroup)this._myControllerMap.get(string2);
        }
        return null;
    }

    private boolean checkName(String string) {
        if (this._myControllerMap.containsKey(this.checkAddress(string))) {
            ControlP5.logger().warning("Controller with name \"" + string + "\" already exists. overwriting reference of existing controller.");
            return true;
        }
        return false;
    }

    public void moveControllersForObject(Object object, ControllerGroup<?> controllerGroup) {
        if (this._myObjectToControllerMap.containsKey(object)) {
            ArrayList arrayList = (ArrayList)this._myObjectToControllerMap.get(object);
            for (ControllerInterface controllerInterface : arrayList) {
                ((Controller)controllerInterface).moveTo(controllerGroup);
            }
        }
    }

    public void move(Object object, ControllerGroup<?> controllerGroup) {
        this.moveControllersForObject(object, controllerGroup);
    }

    protected void clear() {
        this.controlWindow.clear();
        this._myControllerMap.clear();
    }

    @Invisible
    public void pre() {
        Iterator iterator = this._myFieldChangedListenerMap.values().iterator();
        while (iterator.hasNext()) {
            ((FieldChangedListener)iterator.next()).update();
        }
    }

    @Invisible
    public void draw() {
        if (!this.isAutoDraw()) {
            this.controlWindow.draw();
        }
    }

    public ControlWindow getWindow() {
        return this.getWindow(this.papplet);
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        this.getWindow().mouseEvent(mouseEvent);
    }

    public void keyEvent(KeyEvent keyEvent) {
        this.getWindow().keyEvent(keyEvent);
    }

    public ControlWindow.Pointer getPointer() {
        return this.getWindow(this.papplet).getPointer();
    }

    public boolean isMouseOver() {
        return this.getWindow(this.papplet).isMouseOver();
    }

    public boolean isMouseOver(ControllerInterface<?> controllerInterface) {
        return this.getWindow(this.papplet).isMouseOver(controllerInterface);
    }

    public List<ControllerInterface<?>> getMouseOverList() {
        return this.getWindow(this.papplet).getMouseOverList();
    }

    public ControlWindow getWindow(PApplet pApplet) {
        if (pApplet.equals(this.papplet)) {
            return this.controlWindow;
        }
        return this.controlWindow;
    }

    public ControlP5 addCanvas(Canvas canvas) {
        this.getWindow().addCanvas(canvas);
        return this;
    }

    public ControlP5 removeCanvas(Canvas canvas) {
        this.getWindow().removeCanvas(canvas);
        return this;
    }

    public ControlP5 setColor(CColor cColor) {
        this.setColorBackground(cColor.getBackground());
        this.setColorForeground(cColor.getForeground());
        this.setColorActive(cColor.getActive());
        this.setColorCaptionLabel(cColor.getCaptionLabel());
        this.setColorValueLabel(cColor.getValueLabel());
        return this;
    }

    public static CColor getColor() {
        return color;
    }

    public ControlP5 setColorActive(int n) {
        color.setActive(n);
        this.controlWindow.setColorActive(n);
        return this;
    }

    public ControlP5 setColorForeground(int n) {
        color.setForeground(n);
        this.controlWindow.setColorForeground(n);
        return this;
    }

    public ControlP5 setColorBackground(int n) {
        color.setBackground(n);
        this.controlWindow.setColorBackground(n);
        return this;
    }

    public ControlP5 setColorCaptionLabel(int n) {
        color.setCaptionLabel(n);
        this.controlWindow.setColorLabel(n);
        return this;
    }

    public ControlP5 setColorValueLabel(int n) {
        color.setValueLabel(n);
        this.controlWindow.setColorValue(n);
        return this;
    }

    public ControlP5 setMoveable(boolean bl) {
        this.isMoveable = bl;
        return this;
    }

    public boolean isMoveable() {
        return this.isMoveable;
    }

    public boolean saveProperties() {
        return this._myProperties.save();
    }

    public boolean saveProperties(String string) {
        return this._myProperties.saveAs(string);
    }

    public boolean saveProperties(String string, String ... stringArray) {
        return this._myProperties.saveAs(string, stringArray);
    }

    public boolean loadProperties() {
        return this._myProperties.load();
    }

    public boolean loadProperties(String string) {
        File file = new File(string = this.checkPropertiesPath(string));
        if (file.exists()) {
            return this._myProperties.load(string);
        }
        file = new File(string = this.checkPropertiesPath(string + ".ser"));
        if (file.exists()) {
            return this._myProperties.load(string);
        }
        logger.info("Properties File " + string + " does not exist.");
        return false;
    }

    String checkPropertiesPath(String string) {
        string = string.startsWith("/") || string.startsWith(".") ? string : this.papplet.sketchPath(string);
        return string;
    }

    @Invisible
    public boolean loadLayout(String string) {
        File file = new File(string = this.checkPropertiesPath(string));
        if (file.exists()) {
            this.getLayout().load(string);
            return true;
        }
        logger.info("Layout File " + string + " does not exist.");
        return false;
    }

    public void saveLayout(String string) {
        this.getLayout().save(string);
    }

    public String version() {
        return VERSION;
    }

    public void show() {
        this.controlWindow.show();
    }

    public ControlP5 setBroadcast(boolean bl) {
        this._myControlBroadcaster.broadcast = bl;
        return this;
    }

    public boolean isVisible() {
        return this.controlWindow.isVisible();
    }

    public void hide() {
        this.controlWindow.hide();
    }

    public void update() {
        this.controlWindow.update();
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void setUpdate(boolean bl) {
        this.isUpdate = bl;
        this.controlWindow.setUpdate(bl);
    }

    @Deprecated
    public boolean setFont(int n) {
        logger.warning("BitFont is now of type PFont, use setFont(PFont) instead.");
        return false;
    }

    public boolean setFont(ControlFont controlFont) {
        this.controlFont = controlFont;
        this.isControlFont = true;
        this.updateFont(this.controlFont);
        return this.isControlFont;
    }

    public boolean setFont(PFont pFont, int n) {
        this.controlFont = new ControlFont(pFont, n);
        this.isControlFont = true;
        this.updateFont(this.controlFont);
        return this.isControlFont;
    }

    public boolean setFont(PFont pFont) {
        this.controlFont = new ControlFont(pFont);
        this.isControlFont = true;
        this.updateFont(this.controlFont);
        return this.isControlFont;
    }

    protected void updateFont(ControlFont controlFont) {
        this.controlWindow.updateFont(controlFont);
    }

    public ControlFont getFont() {
        return this.controlFont;
    }

    public void disableShortcuts() {
        this.isShortcuts = false;
    }

    public boolean isShortcuts() {
        return this.isShortcuts;
    }

    public void enableShortcuts() {
        this.isShortcuts = true;
    }

    public Tooltip getTooltip() {
        return this._myTooltip;
    }

    public void setTooltip(Tooltip tooltip) {
        this._myTooltip = tooltip;
    }

    public void setMouseWheelRotation(int n) {
        this.getWindow().setMouseWheelRotation(n);
    }

    public ControllerGroup<?> begin() {
        return this.begin(this.controlWindow.getTab("default"));
    }

    public ControllerGroup<?> begin(ControllerGroup<?> controllerGroup) {
        this.setCurrentPointer(controllerGroup);
        return controllerGroup;
    }

    public ControllerGroup<?> begin(int n, int n2) {
        return this.begin(this.controlWindow.getTab("default"), n, n2);
    }

    public ControllerGroup<?> begin(ControllerGroup<?> controllerGroup, int n, int n2) {
        this.setCurrentPointer(controllerGroup);
        controllerGroup.autoPosition.x = n;
        controllerGroup.autoPosition.y = n2;
        controllerGroup.autoPositionOffsetX = n;
        return controllerGroup;
    }

    public ControllerGroup<?> begin(ControlWindow controlWindow) {
        return this.begin(controlWindow.getTab("default"));
    }

    public ControllerGroup<?> begin(ControlWindow controlWindow, int n, int n2) {
        return this.begin(controlWindow.getTab("default"), n, n2);
    }

    public ControllerGroup<?> end(ControllerGroup<?> controllerGroup) {
        this.releaseCurrentPointer(controllerGroup);
        return controllerGroup;
    }

    public ControllerGroup<?> end() {
        return this.end(this.controlWindow.getTab("default"));
    }

    public void addPositionTo(int n, int n2, List<ControllerInterface<?>> list) {
        PVector pVector = new PVector((float)n, (float)n2);
        for (ControllerInterface<?> controllerInterface : list) {
            controllerInterface.setPosition(PVector.add((PVector)controllerInterface.getPosition(), (PVector)pVector));
        }
    }

    public void addPositionTo(int n, int n2, ControllerInterface<?> ... controllerInterfaceArray) {
        this.addPositionTo(n, n2, Arrays.asList(controllerInterfaceArray));
    }

    public void dispose() {
        if (!isApplet) {
            this.clear();
        }
    }

    public static Logger logger() {
        return logger;
    }

    @Deprecated
    public boolean setControlFont(ControlFont controlFont) {
        return this.setFont(controlFont);
    }

    @Deprecated
    public boolean setControlFont(PFont pFont, int n) {
        return this.setFont(pFont, n);
    }

    @Deprecated
    public boolean setControlFont(PFont pFont) {
        return this.setFont(pFont);
    }

    @Deprecated
    public ControlFont getControlFont() {
        return this.getFont();
    }

    @Deprecated
    public boolean save(String string) {
        ControlP5.logger().info("Saving ControlP5 settings in XML format has been removed, have a look at controlP5's properties instead.");
        return false;
    }

    @Deprecated
    public boolean save() {
        ControlP5.logger().info("Saving ControlP5 settings in XML format has been removed, have a look at controlP5's properties instead.");
        return false;
    }

    @Deprecated
    public boolean load(String string) {
        ControlP5.logger().info("Loading ControlP5 from an XML file has been removed, have a look at controlP5's properties instead.");
        return false;
    }

    @Deprecated
    public void trigger() {
        for (String string : this._myControllerMap.keySet()) {
            if (!(this._myControllerMap.get(string) instanceof Controller)) continue;
            ((Controller)this._myControllerMap.get(string)).trigger();
        }
    }

    @Deprecated
    public void disableKeys() {
        this.isShortcuts = false;
    }

    @Deprecated
    public void enableKeys() {
        this.isShortcuts = true;
    }

    @Deprecated
    public void lock() {
        this.isMoveable = false;
    }

    @Deprecated
    public void unlock() {
        this.isMoveable = true;
    }

    @Deprecated
    protected Vector<ControlWindow> controlWindows() {
        return this.getControlWindows();
    }

    @Deprecated
    public Controller<?> controller(String string) {
        return this.getController(string);
    }

    @Deprecated
    public ControllerGroup<?> group(String string) {
        return this.getGroup(string);
    }

    @Deprecated
    public ControlWindow window(String string) {
        return this.getWindow(string);
    }

    @Deprecated
    public ControlWindow window() {
        return this.getWindow();
    }

    @Deprecated
    public Tab tab(ControlWindow controlWindow, String string) {
        return this.getTab(controlWindow, string);
    }

    @Deprecated
    public ControlWindow window(PApplet pApplet) {
        return this.getWindow(pApplet);
    }

    @Deprecated
    public ControlBroadcaster controlbroadcaster() {
        return this._myControlBroadcaster;
    }

    @Deprecated
    public Tab tab(String string) {
        return this.getTab(string);
    }

    @Deprecated
    public ControllerInterface<?>[] getControllerList() {
        ControllerInterface[] controllerInterfaceArray = new ControllerInterface[this._myControllerMap.size()];
        this._myControllerMap.values().toArray(controllerInterfaceArray);
        return controllerInterfaceArray;
    }

    @Deprecated
    public ControlP5 setColorLabel(int n) {
        return this.setColorCaptionLabel(n);
    }

    @Deprecated
    public ControlP5 setColorValue(int n) {
        return this.setColorValueLabel(n);
    }

    @Deprecated
    public ControlP5 disableMouseWheel() {
        this.getWindow().disableMouseWheel();
        return this;
    }

    @Deprecated
    public ControlP5 enableMouseWheel() {
        this.getWindow().enableMouseWheel();
        return this;
    }

    @Deprecated
    public boolean isMouseWheel() {
        return this.getWindow().isMouseWheel();
    }

    @Deprecated
    protected ControlP5 remove(ControlWindow controlWindow) {
        controlWindow.remove();
        return this;
    }

    @Deprecated
    public ControlWindow getWindow(String string) {
        return this.controlWindow;
    }

    @Deprecated
    protected Vector<ControlWindow> getControlWindows() {
        Vector<ControlWindow> vector = new Vector<ControlWindow>();
        vector.add(this.controlWindow);
        return vector;
    }

    static {
        logger = Logger.getLogger(ControlP5.class.getName());
        BitFontStandard56 = new BitFont(CP.decodeBase64("AeYACQBgACAEAgQGBggHAgMDBgYDBQIFBgMGBgYGBgYGBgIDBAYEBggGBgYGBgYGBgIGBgUIBgYGBgYGBgYGCAYGBgMFAwYHAwUFBQUFAwUFAgMFAggFBQUFBAQEBQUIBQUFBAMEBQKgUgghRwoBAIAcOQ7yOZ/jAADAAXAe5/k+JwqKQlDkPM7jfFGUFEXfwghAQAAICIQUAgAAAAABAAAAQAkVqBSvJFJUEQCQaFHEBBEURQAAiDiiKIqCIIqCkjAWRVEURUQUJUURFCEFIBAAAgEBhAAAAABAAAAAAEikBIIvkFAQOQQAJBIEKU8ARVGiLyCRKAqiIAiioCJUTVEURQERRUmKgkQoAsAd40zcSambY447u5SSUnoSAYBAcRBMRNWHh4iEMAn0II4HBBAk6XuC6HmyL2gISVX0RI9DREoSQRAhAgBIKaW0lFIpKaWUIiSlpJRQhAAg+CCSFBFBACAiEdAHRUgEgfiIqIqiIAqCKAoqQlAWBVEBEZGSpBBCiAAAUgrpJaU0SkoppRBJKckkIxEAAJRHKkIEEACESEKERBERRUEAAVKiKIqCIIqKkhAURUGUREREJEVEECQAgJRSCkkplZJSSilIUkpKKUgEAAKFCHGhAIBAwdHnII5DOA4iIAiB6HGeL3CinOgFRU7gRA7hEDYR8QUJ+MEd40xcSqmkZI6LEWdsknsSAQAAAAAAAAAgAAAAAAAAAACAAACAAwAAAAAAAAAAAAAAQAAAAAAAAAADAwAAAAAABBAAAICAAAAAAIAAJQAAAAAAAAAABAAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwAACAAAgIAAAAAAYAAA="));
        BitFontStandard58 = new BitFont(CP.decodeBase64("AakACQBgACAEAgQGBggGAgMDBAYDBAIGBQMFBQUFBQUFBQICBAUEBQgFBQUFBQUFBQIFBQQGBQUFBQUFBAUGCAUGBQMFAwYGAwQEBAQEBAQEAgQEAgYEBAQEAwQEBAQGBAQEBAIEBQKgUgghIaUAAIiRMeiZZwwAAANgjjnvmRRKESVzzDGXoqQUvYURQCCAQCCSCAAAAAgAAABEqECleCVFkRAAiLSUWEgoJQAAiSOllEJIKVRiSymllCRFSSlCEVIAQQBBQAARAAAAEAAAACQpgeALJASiIwAQSQipE1BKRS+QSEohhRBSqES1UkopSIqSkkIiFAGwEZOwSaplZGx2VVXVSQIAgeIgSETy4RCSCEnoEONAgJCkd0I6p73QiKilk46RpCQZQoQIAFBVVVOVVFVVVUKqqiqKCACCDyKpiIoAICQJ9FAiCUE8ElUphRRCSqESUUohJSRJSUpECBEAoCrqoiqZqqqqiFRVUiIJAADKI5UQASEgSAoJpSRSCgECUlJKKYSUSiWilEJKSRKRlIgQJABAVVVEVVJVVVUhqaqqQhIACBQixEIBQFBg9AwyRhhDBEIIpGPOCyZl0kXJBJOMGMImEW9owAcbMQmrpKpKxjJiopQdFQAAAAAAAABAAAAAAAAAAIAAAOAAAAAAAAAAAAAACAAAAAAAAAAAAAAAAAQIAAAEAQAAAAIAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABAgAAAgCAAAAAgAA"));
        welcome = 0;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Layout {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Invisible {
    }
}

