/*____________________________________________________________________________*/
/*  KLL-engineering                                                           */
/*____________________________________________________________________________*/

char prev[5]="V0.2";
// testing DFRobot LCD shield
// 23.7.2011 and make a menu example for easy start
//           also here use textstrings in FLASH to save RAM
//___________________________________________________________________________________


#include <avr/pgmspace.h>

//example use of LCD4Bit_mod library

#include <LCD4Bit_mod.h> 
//create object to control an LCD.  
//number of lines in display=1
LCD4Bit_mod lcd = LCD4Bit_mod(2); 
/* 
DFRobot LCD shield (DFR0009) 

usage of ARDUINO pins:
Dout 4
Dout 5
Dout 6
Dout 7 are the 4 bit communication lines
Dout 8 RS
Dout 9 Enable
R/W wired to GND ( library Dout11 not used )
Dout10 backlitcontrol ( not used in library or example but wired )
( its a pwm pin, should test it for tune back light? )
Ain0 from a voltage devider by 5 PB and 5 resistors.
by analyzing this voltage a singlepressed PB can be detected. ( very nice idea!)
a reset button
example software use Dout13 arduino led, blinks on PB,
but is not really visible because of the LCD shield.
a poti adjust the contrast.
*/

//___________________________________________________________________________________

// in FLASH
prog_uchar PROGMEM L00[] = {"KLL-engineering "};//
prog_uchar PROGMEM L01[] = {" menu LCD shield"};// 

prog_uchar PROGMEM M00[]="MAIN MENU       ";//
prog_uchar PROGMEM M01[]="M1              ";//
prog_uchar PROGMEM M02[]="M2              ";//
prog_uchar PROGMEM M03[]="SERVICE MENU    ";//

prog_uchar PROGMEM M10[]="M1desc          ";//
prog_uchar PROGMEM M11[]="M11             ";// job11();
prog_uchar PROGMEM M12[]="M12             ";// job12();
prog_uchar PROGMEM M13[]="M13             ";// job13();

prog_uchar PROGMEM M20[]="M2desc          ";//
prog_uchar PROGMEM M21[]="M21             ";// job21();
prog_uchar PROGMEM M22[]="M22             ";// job22();
prog_uchar PROGMEM M23[]="M23             ";// job23();

prog_uchar PROGMEM M30[]="SERVICE MENU    ";//
prog_uchar PROGMEM M31[]="BACKLIGHT ON/OFF";// job31();backlight();
prog_uchar PROGMEM M32[]="BACKLIGHT adjust";// job32();backlight_adjust();
prog_uchar PROGMEM M33[]="ASCII CHAR      ";// job33();test_ascii();

// in SRAM
char headerline[]=" job00          ";//
char  emptyline[]="                ";//
// in SRAM will hold copies of Mxx 
// because write to FLASH variables not possible, and used to convert uchar to char
char mline1[]="                ";//
char mline2[]="                ";//

// menue position
int Mpoint = 0;
int Mline = 0;


//Key message
//                  "1234567890123456"
char msgs[5][17] = {"Right Key       ", 
                    "Up Key          ", 
                    "Down Key        ", 
                    "Left Key        ", 
                    "Select Key      "};
int  adc_key_val[5] ={30, 150, 360, 535, 760 };
int NUM_KEYS = 5;
int adc_key_in;
int key=-1;
int oldkey=-1;

boolean Mup = false;
boolean Mdown = false;
boolean Mleft = false;
boolean Mright = false;
boolean Mselect = false;

boolean redraw = true;

int menudelay = 0;
int showjob = 800;


// test ascii routine variables
int tim_counter = 0;
int tim_reset = 2000;
char letter[17];
long ser0bd = 115200;                               // 300, 1200 good, 2400, 9600 good, 14400, 19200 good, 28800, 38400 good, 57600 setpoint not good, 115200 good
int ih =0, iz =0, ie =0, ixz = 0, ixe = 0;    

// backlight variables
int backlight_pin = 10;
boolean backlight_pwr = true;
byte backlight_pwm = 200;

// multitasking conti job timeslices

  unsigned long loopcount =0;                      // cycles 
  unsigned long loopreport=1000000;                // reset and time diag


  int execPBcount;                                 // conti job PB check
  int execPBtim = 2000;                             // timer
  
  int exec0count, exec1count, exec2count, exec3count, exec4count, exec5count, exec6count, exec7count, exec8count, exec9count; // now per job, only INT
  boolean exec0conti = true;                       // sinus ramp setpoint generator
  int sinexecuter = 200;                           // timing for setpoint ramp jobs
  
  boolean exec1conti = false;                       // job 11
  int exec1tim = 5000; 
  boolean exec2conti = false;                       // job 12
  int exec2tim = 5000; 
  boolean exec3conti = false;                       // job 13
  int exec3tim = 5000; 
  boolean exec4conti = false;                       // job 21
  int exec4tim = 5000; 
  boolean exec5conti = false;                       // job 22
  int exec5tim = 5000; 
  boolean exec6conti = false;                       // job 23
  int exec6tim = 5000; 
  boolean exec7conti = false;                       // job 31
  int exec7tim = 5000; 
  boolean exec8conti = false;                       // job 32
  int exec8tim = 5000; 
  boolean exec9conti = false;                       // job 33
  int exec9tim = 5000; 



// general time variables
 unsigned long Ltime;                              // milliseconds   works for about 50 days
 unsigned long Ltime_old;                          // milliseconds memory last scan
 unsigned long Ltime_delta;                        // milliseconds delta from last scan
 
                                                   // L___ for calc actual values ( from millis )
                                                   // I___ for user set timer, I1__ for ON, I0__ for OFF,  
 int Ldays; 
 int Lhours;
 int Lminutes;
 int Lseconds;



// sinus ramp     setpoint  "rampsin"
 int rampcount;
 const float rad = 0.0245;                             // 2 * PI / 256
 byte rampsin;                                         // byte format for RGB   

//___________________________________________________________________________________

void setup() { 
  pinMode(13, OUTPUT);  //we'll use the debug LED to output a heartbeat

   pinMode(backlight_pin, OUTPUT);  // test backlight transistor of LCD shield
//  digitalWrite(backlight_pin, HIGH);   // set the LED on 
   analogWrite(backlight_pin, backlight_pwm);
 
  Serial.begin(ser0bd);
  Serial.println("kll-engineering on ARDUINO");
  Serial.print(" LCD shield menu inflash kll ");
  Serial.println(prev); 

  lcd.init();
  showmenuintro();  

}  // end SETUP

//___________________________________________________________________________________

void loop() {

  if (redraw) {   drawmenu();   redraw=false; }                // only write LCD 2 lines if change

  conti_jobs();
  
}   // end loop

//___________________________________________________________________________________


void screen2L(char X0[],char X1[],int showtime,boolean sclear)
{

 if ( sclear ) { lcd.clear(); delay(100); } //
                   lcd.cursorTo(1, 0);           //line=1, x=0
                   lcd.printIn(X0);              //
                   lcd.cursorTo(2, 0);           //line=1, x=0
                   lcd.printIn(X1);              //
                 delay(showtime);
   } // end screen2L

//___________________________________________________________________________________

void showmenuintro()
{
          for (int i=0; i<=15; i++) { mline1[i] = pgm_read_byte(&L00[i]); }
          for (int i=0; i<=15; i++) { mline2[i] = pgm_read_byte(&L01[i]); }
          // kll engineering info page 
          screen2L(mline1,mline2,showjob,true);

}

//___________________________________________________________________________________

void show_setpoint(char X0[],char X1[],int setpoint,boolean sclear) {
int firstX = 0;

          for (int i=0; i<=15; i++) { mline1[i] = X0[i]; } 
          for (int i=0; i<=15; i++) { 
                                  mline2[i] = X1[i];
                                 if ( (firstX == 0) && (i > 0) && (mline2[i] == 'X') ) { firstX = i; } 
                                       }
         // now we must transfer setpoint to 3 characters and put in place of line 2 where XXX is shown 
// DEC
                   ih = setpoint/100;
                   iz = ( setpoint - ih*100 )/10;
                   ie = setpoint - ih*100 - iz*10;
                   mline2[firstX] = num_char(ih);
                   mline2[firstX+1] = num_char(iz);
                   mline2[firstX+2] = num_char(ie);

  screen2L(mline1,mline2,100,sclear);
} // end show setpoint
//___________________________________________________________________________________

