/*_________________________________________________________________*/
/*  KLL-engineering                                                */
/*  Anet slave                                                     */
/*  20.9.2011 kll-engineering                                      */
/*  V0.7 21.02.2012 revised to ARDUINO 1.0                         */
/*    Binary sketch size:                          10934 bytes     */
/*  V0.8 22.02.2012 EEPROM setup                   11042           */
/*  V0.9 24.02.2012 PID                                            */
/*  V1.0 26.02.2012 RS485                                          */
/*_________________________________________________________________*/
char prev[5]="V1.0"; 

// STEP 1
// using NewSoftSerial on in: D2 out: D3
// to link 2 arduinos
// STEP 2
// then using RSD485 for 1600ft distance
// STEP 3
// and addressing frames for multidrop

// slave    only read single character send get syncron at 19200 and 2millisec delay between send and avail check
// slave1   get a string and compare and send AKN
// slave2   check master 2 on higher dbrate 38400 and start with device numbers 
// slave3   extended header, ; ADDRESS , Command , I/Oadd , Data CR
//            toggle diag by USB 'd'
// slave4   speedtests by master
// slave5   master gets a menuprogram
//          measuring/set cycles
                                                // setcmd from master
                                                // expect after header ;01,SET, :  INT1, INT2,
                                                // INT1 :  xxxx000100000x    example, set D7  to output and write  ( ONLY one channel at a time!!! )
                                                // INT2 : PWM duty cycle: between 0 (always off) and 255 (always on); DIGITAL 0 OFF , (>0) 1  ON
// slave6   measuring analog calc with VCC and filter ( option CALIB use Vccread, option AFIL use filter )
//            from USB operate toggle CALIB 'c', toggle AFIL 'f'

// slave7   after "0022" now use "ARDUINO 1.0"

// slave8   use eeprom for setup

// slave 9  PID control ( eeprom settings )
//                      with MODE = 0  have normal remote I/O 



// if slave is connected to terminal ( via USB ) 
// see:
// bootinfo and init settings
// loopreport time (1.000.000 cycles )
// send:
// following commands are possible:
// d  toggle diagnostic
// c  toggle use VCC calibration
// f  toggle use filter on analog values
// e  list ee prom layout
// 0  NULL factory reset/init eeprom ( slave 0 )

//__________________________________________________________________
#include <EEPROM.h>

#include <SoftwareSerial.h>  // new version arduino 1.0 use new soft serial as software serial!

SoftwareSerial anet_serial(2, 3); // Order is input pin, output pin
const int RSen = 4;

    char DIO[15] = {'x', 'x', 'x', 'x', 'x', 'i', 'i', 'i', 'i', 'i', 'i', 'i', 'i', 'o' };

  int getDOchannel,getDOval;
  int msgforslave;

  char uokcmd[4]="UOK";             // check if slave is alive
  char getcmd[4]="GET";             // ask slave to send data from his I/O add
  char setcmd[4]="SET";             // ask slave to set his I/O
  char AKNcmd[4]="AKN";             // slave acknowledges
  char comcmd[4]="CCK";             // make com check by compare known textstring

  char in_cmd[4]="   ";             // to get commands from master  
  // for testing
  char sendStr[25] = "arduino rocks and is fun";  // 24 + 1
  
  char   inStr[41];
  char inChar = 'i';
  int getChar = 0, getCharlast;
  boolean getbyte = false;
  
boolean debuga = false, debugas = false, debugt = true, debugc = true, debugm = false, echo = false;

const long ser0bd = 115200, anetbd = 57600;       // 300, 1200 good, 2400, 9600 good, 14400, 19200 good, 28800, 38400 good, 57600 setpoint not good, 115200 good
const int ms = 6;                                  // delay between first and all available 40ms for 19200, 10ms for 38400

const int headeroffset = 8;

   char inByte;                                      // USB commands
//   int delayusb = 100;                               // wait
   int serloop = 0; 
   const int serloopend = 5001;               // only after serloopend cycles check for USB income

   int measloop = 0;
   const int measloopend = 500;               // check all 500 loops
  unsigned long Ltimem, sampletimem = 1000;   // measuring loop 1sec
  
   int setloop = 0;
   const int setloopend = 30001;             // calibration VCCread timer

  unsigned long loopcount =0;                          // cycles 
const unsigned long loopreport=1000000;                // reset and time diag
// see 44sec ( with measuring every second  and send every 10 sec )

  
// time variables
 unsigned long Ltime;                             // milliseconds   works for about 50 days
 unsigned long Ltime_old;                         // milliseconds memory last scan
 unsigned long Ltime_delta;                       // milliseconds delta from last scan

                                                  // L___ for calc actual values ( from millis )
                                                  // I___ for user set timer, I1__ for ON, I0__ for OFF,  
 int Ldays; 
 int Lhours;
 int Lminutes;
 int Lseconds;
   
long VCCread=0;
unsigned int sendarray[8];
float Aival[6],AiY[6];                  // filtered values 
const float Aifil0 = 0.8;               // analog inputs filter first order
const float Aifil1 = 0.2;               // analog inputs filter first order
boolean CALIB = true;                   // use VCC calibrated values millivolt or 5000 millivolt
boolean AFIL = true;                    // filter every reading, if true send it, if false send unfil

//eeprom
 int aword = 1;                         // word for read write eeprom
 int eeprom_base = 510;                 // our variables dataset start

/* 510.511 */ int myslave = 0;          // my slave address

//pid
unsigned long Ctimem, Ctimlim = 3000;   // control loop
float Cifil0 = 0.7;                     // controller input filter related to measuring timer, not control loop timer
float Cifil1 = 0.3;
float gain=0.50;                         // tuning
float epsilon=0.01;                      // integrate low lim
float reset=0.01;
float rate=2.0;
int action=-1;                          // reverse
float delta=0.0, deltamem=0.0, integral=0.0, derivate=0.0;
float ARWU=1000.0;                      // anti reset windup
float processvalue=0.0;                 // operation
float setpoint=50.0;
float CASsetpoint=0.0;
float output=0.0;                       // later to PWM 0 .. 255
float Moutput=0.0;
float outmin=-100.0, outmax=100.0;
int mode=0;                             // 0 disable, 1 interlock, 2 MAN, 3 AUTO, 4 CAS,  
  boolean SIM = false;
  int simcount=0, simcountlim=20;
  float simpv1=1500.0,simpv2=3500.0,simsel;
//__________________________________________________________________

  
void setup() {
  Serial.begin(ser0bd);


  ee_setup();               // check eeprom setup


  DIOsetup();               // input output puls
  digitalWrite(13, LOW);    // set the LED off

  

  Serial.print(F("KLL A-net SLAVE "));
  Serial.print(myslave);
  Serial.print(F(" has booted. rev: ")); Serial.println(prev);
  
  anet_serial.begin(anetbd);
 
}

//__________________________________________________________________

void loop() {

      checkUSB();                  // check on debug ...

 msgforslave=listen(); 
if ( getbyte ) {
               if ( debuga ) {  Serial.print(" i get msg, for ");}
               if (  msgforslave == myslave) { 
                     if ( debuga ) { Serial.print(" me, "); }
                       
                     if ( check3byte(in_cmd,uokcmd) ) { sendAKN(); if ( debuga ) {  Serial.println("uokcmd"); } }
                     
                     if ( check3byte(in_cmd,comcmd) ) { if ( checksame() ) {  sendAKN(); } if ( debuga ) {  Serial.println("comcmd"); } }
                     
                     if ( check3byte(in_cmd,getcmd) ) { sendGET(); if ( debuga ) {  Serial.println("getcmd"); } }

                     if ( check3byte(in_cmd,setcmd) ) { doSET(); if ( debuga ) {  Serial.println("setcmd"); } }

                                                  } else { if ( debuga ) {  Serial.println(msgforslave); } }
                                                  // end for me
                                  } // getbyte true 
        
        
       checkIO();   

       loopreporting();
       
                 } // end loop
//__________________________________________________________________

