void ee_read(int ee_off) {

  aword = EEPROM.read(eeprom_base+ee_off+1);                //read the high byte
  aword = aword << 8;                                       //bitshift the high byte left 8 bits to make room for the low byte
  aword =  aword | EEPROM.read(eeprom_base+ee_off);         //read the low byte
  
} // end ee_read

void ee_write(int ee_off) {
  int checkit;
  // first read from eeprom 
  checkit = EEPROM.read(eeprom_base+ee_off+1);               // read the high byte
  checkit = checkit << 8;                                    // bitshift the high byte left 8 bits to make room for the low byte
  checkit =  checkit | EEPROM.read(eeprom_base+ee_off);      // read the low byte
  if ( checkit == aword ) { } else {                         // write only on changes
  EEPROM.write(eeprom_base+ee_off, lowByte(aword));          // writes the first byte to EEPROM address 510
  EEPROM.write(eeprom_base+ee_off+1, highByte(aword));       // writes the second byte to EEPROM address 511
                                   }
} // end ee_write

void ee_list() {
// slave DIO definition
// x == not avail
// i == input
// s == switch input with internal pullup ( PB to GND )
// o == output
// p == pwm output
// DIO 0,1 serial port
// DIO 2,4 soft serial port to A-net
// DIO 13 arduino board LED


                  Serial.println(F(" SLAVE EEPROM ( rev REMOTE I/O PID )"));                                             
                  Serial.println(F(" 510 INT slave add 0..32")); 
                  Serial.println(F(" 512 INT free")); 
                  Serial.println(F(" 514 INT free")); 
                  Serial.println(F(" 516 INT free")); 
                  Serial.println(F(" 518 INT free")); 
                  Serial.println(F(" DIO  (0 i, 1 s, 2 0, 3 p)")); 
                  Serial.println(F(" 520 BYTE DIO[0] x")); 
                  Serial.println(F(" 521 BYTE DIO[1] x")); 
                  Serial.println(F(" 522 BYTE DIO[2] x")); 
                  Serial.println(F(" 523 BYTE DIO[3] x")); 
                  Serial.println(F(" 524 BYTE DIO[4] x")); 
                  Serial.println(F(" 525 BYTE DIO[5]")); 
                  Serial.println(F(" 526 BYTE DIO[6]")); 
                  Serial.println(F(" 527 BYTE DIO[7]")); 
                  Serial.println(F(" 528 BYTE DIO[8]")); 
                  Serial.println(F(" 529 BYTE DIO[9] p PWM output PID")); 
                  Serial.println(F(" 530 BYTE DIO[10]")); 
                  Serial.println(F(" 531 BYTE DIO[11]")); 
                  Serial.println(F(" 532 BYTE DIO[12]")); 
                  Serial.println(F(" 533 BYTE DIO[13] o LED")); 
                  Serial.println(F(" 534 BYTE free")); 
                  Serial.println(F(" 535 BYTE free")); 
                  Serial.println(F(" 536 BYTE free")); 
                  Serial.println(F(" 537 BYTE free")); 
                  Serial.println(F(" 538 BYTE free")); 
                  Serial.println(F(" 539 BYTE free")); 
                  
//                  Serial.println(F(" PID")); 
                  Serial.println(F(" 540 INT PID PV fil 0      // *100     Cifil0 "));
                  Serial.println(F(" 542 INT PID PV fil 1      // *100     Cifil1 "));            
                  Serial.println(F(" 544 INT PID GAIN          // *100     gain "));             
                  Serial.println(F(" 546 INT PID RESET         // *100     reset"));
                  Serial.println(F(" 548 INT PID RATE          // *100     rate"));
                  Serial.println(F(" 550 INT PID action        //          action"));
                  Serial.println(F(" 552 INT PID SETPOINT      // *100     setpoint")); 
                  Serial.println(F(" 554 INT PID MAN OUTPUT    // *100     Moutput")); 
                  Serial.println(F(" 556 INT PID OUT MIN       // *100     outmin"));   
                  Serial.println(F(" 558 INT PID OUT MAX       // *100     outmax"));
                  Serial.println(F(" 560 INT PID MODE          //0 disable, 1 interlock, 2 MAN, 3 AUTO, 4 CAS,")); 
                  Serial.println(F(" 562 INT PID SIM           //          SIM  >0 true"));
                  Serial.println(F(" 564 INT PID looptime      //          Ctimlim"));
} // end ee_list

void ee_show(int offs) { 
                         if ( debugt ) {
                         Serial.print("_EE:");Serial.print(eeprom_base + offs);Serial.print("_");Serial.println(aword); 
                                       }
                        }

void ee_setup() {
  char eX=' ';
  boolean eeset=false;
    ee_read(0);                                              ee_show(0);// 510, 511: slave add
    myslave = aword;                                          // on new cpu see '-1'
    if ( myslave < 0  ) { myslave = 0; }                      // uninit
    if ( myslave > 32 ) { myslave = 0; }                      // uninit
    if ( myslave == 0 ) {   Serial.println(" uninit slave ");  }
 
    ee_read(2);                                               ee_show(2);// 512
    ee_read(4);                                               ee_show(4);// 514
    ee_read(6);                                               ee_show(6);// 516
    ee_read(8);                                               ee_show(8);// 518
    
    ee_read(30);                                              ee_show(30);// 540
    Cifil0 = aword/100.0;
    ee_read(32);                                              ee_show(32);// 542
    Cifil1 = aword/100.0;
    ee_read(34);                                              ee_show(34);// 544
    gain = aword/100.0; 
    ee_read(36);                                              ee_show(36);// 546
    reset = aword/100.0;
    ee_read(38);                                              ee_show(38);// 548
    rate = aword/100.0;
    ee_read(40);                                              ee_show(40);// 550
    action = aword; 
    ee_read(42);                                              ee_show(42);// 552
    setpoint = aword/100.0; 
    ee_read(44);                                              ee_show(44);// 554 
    Moutput = aword/100.0;
    ee_read(46);                                              ee_show(46);// 556 
    outmin = aword/100.0;
    ee_read(48);                                              ee_show(48);// 558
    outmax = aword/100.0;
    ee_read(50);                                              ee_show(50);// 560
    mode = aword;
    ee_read(52);                                              ee_show(52);// 562
    SIM = aword;
    ee_read(54);                                              ee_show(54);// 564 
    Ctimlim = aword;

 
 // DIO  read from eeprom 520..533 as bytes
      Serial.print(" read eeprom I/O: ");
      for ( int i=0 ; i < 14 ; i++ ) {
      eeset = false;
      eX = EEPROM.read(eeprom_base + 10 + i );                  // Serial.print(" see eeprom "); Serial.print(eeprom_base + 10 + i); Serial.println( eX ); 
      if (eX == 'x')  { DIO[i] = 'x'; eeset = true; }
      if (eX == 'i')  { DIO[i] = 'i'; eeset = true; }
      if (eX == 'o')  { DIO[i] = 'o'; eeset = true; }
      if (eX == 'p')  { DIO[i] = 'p'; eeset = true; }
      if (eX == 's')  { DIO[i] = 's'; eeset = true; }
      
      if ( !eeset ) {                                           // eeprom was not set, we do now
                EEPROM.write(eeprom_base + 10 + i, DIO[i] );    // with default
                                                                // Serial.print(" set eeprom "); Serial.print(eeprom_base + 10 + i); Serial.print(" _"); 
                    }
       Serial.print( DIO[i] );                              }
       Serial.println();
} // end ee_setup



void ee_reset() {                                               // should be used for new cpu also
  aword = 0; ee_write(0);                                       // slave add
  aword = 0; ee_write(2);  
  aword = 0; ee_write(4);
  aword = 0; ee_write(6);
  aword = 0; ee_write(8);
  EEPROM.write(eeprom_base + 10 + 0, 'x' );
  EEPROM.write(eeprom_base + 10 + 1, 'x' );
  EEPROM.write(eeprom_base + 10 + 2, 'x' );  //RS Rx
  EEPROM.write(eeprom_base + 10 + 3, 'x' );  //RS Tx
  EEPROM.write(eeprom_base + 10 + 4, 'o' );  //RS en
  EEPROM.write(eeprom_base + 10 + 5, 'i' );
  EEPROM.write(eeprom_base + 10 + 6, 'i' );
  EEPROM.write(eeprom_base + 10 + 7, 'i' );
  EEPROM.write(eeprom_base + 10 + 8, 'i' );
  EEPROM.write(eeprom_base + 10 + 9, 'p' );
  EEPROM.write(eeprom_base + 10 + 10, 'i' );
  EEPROM.write(eeprom_base + 10 + 11, 'i' );
  EEPROM.write(eeprom_base + 10 + 12, 'i' );
  EEPROM.write(eeprom_base + 10 + 13, 'o' );
  
  EEPROM.write(eeprom_base + 10 + 14, 'a' );  //Ain PID
  EEPROM.write(eeprom_base + 10 + 15, 'a' );
  EEPROM.write(eeprom_base + 10 + 16, 'a' );
  EEPROM.write(eeprom_base + 10 + 17, 'a' );
  EEPROM.write(eeprom_base + 10 + 18, 'a' );
  EEPROM.write(eeprom_base + 10 + 19, 'a' );  
  
  aword = 70; ee_write(30);
  aword = 30; ee_write(32);
  aword = 50; ee_write(34);
  aword = 1; ee_write(36);
  aword = 200; ee_write(38);
  aword = -1; ee_write(40);
  aword = 0; ee_write(42);
  aword = 0; ee_write(44);
  aword = -10000; ee_write(46);
  aword = 10000; ee_write(48);
  aword = 0; ee_write(50);
  aword = 0; ee_write(52);
  aword = 3000; ee_write(54);
  
      
} // end ee_reset






