/*   from WIKI
previous_error = setpoint - process_feedback
integral = 0
start:
  wait(dt)
  error = setpoint - process_feedback
  integral = integral + (error*dt)
  derivative = (error - previous_error)/dt
  output = (Kp*error) + (Ki*integral) + (Kd*derivative)
  previous_error = error
  goto start
  
*/
/* from http://www.jashaw.com/pid/code.htm
 1.           IF Mode = ‘AUTO’ THEN
2.             Err=SetP- Input           Error based on reverse action
3.             IF Action = ‘DIRECT’ THEN
4.                   Err=0 – Err           Change sign of error for direct action
5.             ENDIF
6.            OutP=OutP+Gain*(Err-ErrLast+Reset*Err+Deriv*(Err-ErrLast*2+ErrLastLast))
Calculate the change in output using the derivative of the PID algorithm, then add to the previous output.
7.             ErrLastLast=ErrLast
8.         ErrLast=Err
9.       ELSE
10.         InputLast=Input           While loop in manual, stay ready for bumpless switch to Auto.
11.         ErrLastLast=Err
12.         ErrLast=Err
13.       ENDIF
14.       IF OutP > 100 THEN OutP=100  Limit output to between
15.       IF OutP < 0 THEN OutP=0      0 and 100 percent
*/
/* see also
   http://www.straightlinecontrol.com/pid_algorithms.html

   http://www.embeddedheaven.com/pid-control-algorithm-c-language.htm
*/

//pid variables in MAIN
//unsigned long Ctimem, Ctimlim = x00;       // control loop
//float Cifil0 = ;                        // controller input filter 
//float Cifil1 = ;
//float gain=;                            // tuning
//float epsilon=0.01;                     // integrate low lim
//float reset=;
//float rate=;
//int action=-1;                          // reverse
//float delta=0.0, deltamem=0.0, integral=0.0, derivate=0.0;
//float ARWU=1000.0;                      // anti reset windup
//float processvalue=0.0;                 // operation
//float setpoint=0.0;                     // operation
//float CASsetpoint=0.0;
//float output=0.0;                       // to PWM 0 .. 255
//float Moutput=0.0;
//float outmin=-100.0, outmax=100.0;
//int mode=3;                             // 0 disable, 1 interlock, 2 MAN, 3 AUTO, 4 CAS,  
//  boolean SIM = true;
//  int simcount=0, simcountlim=20;
//  float simpv1=1500.0,simpv2=3500.0,simsel;

    // PV input and filter see sheet hardwareIO, procedure readIO(), range: 0 .. 5000 [mV]
    // for PID PV use A0 and filter here with measuring timer, independent from control timer
    //               processvalue = processvalue * Cifil0 + Aival[0] * Cifil1;          // recursiv digital filter PID PV

void PIDIO() {
  boolean PIDen = true;
 
  switch (mode) {                                               // 
    case 0:
     output = 0.0;                                              // safe mode, no limit used 
     PIDen = false;    
    break;
    
    case 1:                                                     // interlock
     output = 0.0;                                              // safe mode, no limit used
    break;
    
    case 2:                                                     // MAN
     output = Moutput;                                          // from MASTER
     if (output > outmax ) { output = outmax; }
     if (output < outmin ) { output = outmin; }      
    break;
    
    case 3:                                                     // AUTO
     if ( SIM ) { 
              simcount = simcount + 1 ;
              if ( simcount > simcountlim ) {
                  simcount = 0;
                  if ( simsel < 2500 ) { simsel = simpv2; } else { simsel = simpv1; } // toggle PV
                                            }
              processvalue = simsel;
              }
           
     delta = setpoint - processvalue/50.0 ; 
     if ( abs(delta) > epsilon ) {                                // only integrate if not too small error
       integral = integral + delta * Ctimlim/1000;                // from millis to sec
       if ( integral >ARWU ) { integral = ARWU; }                 // with ANTI RESET WINDUP
       if ( integral < ARWU*(-1.0)) { integral = ARWU*(-1.0);}
                              }
     derivate = ( delta - deltamem )*1000/Ctimlim;

     output = action * ( gain * delta + reset * integral + rate * derivate );
     if (output > outmax ) { output = outmax; }
     if (output < outmin ) { output = outmin; }
    break;
    
    case 4:                                                     // CAS
     delta = CASsetpoint - processvalue/50.0 ;
     if ( abs(delta) > epsilon ) {                                // only integrate if not too small error
       integral = integral + delta * Ctimlim/1000;                // from millis to sec
       if ( integral > ARWU ) { integral = ARWU; }                // with ANTI RESET WINDUP
       if ( integral < ARWU*(-1.0)) { integral = ARWU*(-1.0);}
                              }
     derivate = ( delta - deltamem )*1000/Ctimlim;


     output = action * ( gain * delta + reset * integral + rate * derivate );
     if (output > outmax ) { output = outmax; }
     if (output < outmin ) { output = outmin; }
    break;

    default:
     output = 0.0;                                              // safe mode, no limit used
    } // end switch mode
  deltamem=delta;

 if ( PIDen ) {                                                     
                  getDOval = map(int(output*100.0),-10000,10000,0,255);    //PWM range
                  analogWrite (9, getDOval );                         // map output to PIN 9 PWM                                           
              }


  if ( debugc && ( mode != 0 )) { Serial.print(" PID loop "); 
                  Serial.print(millis()/1000); 
                  Serial.print(F(" PV ")); 
                  Serial.print(processvalue/50.0); 
                  Serial.print(F(" SP ")); 
                  Serial.print(setpoint); 
                  Serial.print(F(" INT ")); 
                  Serial.print(integral); 
                  Serial.print(F(" OP ")); 
                  Serial.print(output); 
                  Serial.print(F(" PWM ")); 
                  Serial.print(getDOval); 
                  Serial.print(F(" mode ")); 
                  Serial.print(mode); 
                  Serial.println();                  
                  } 

}  // end PIDIO
